/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.file;

import java.io.IOException;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.util.FileChooser;
import org.herac.tuxguitar.gui.util.MessageDialog;
import org.herac.tuxguitar.io.importer.MidiImporter;
import org.herac.tuxguitar.song.models.Song;

public class ImportMidiAction
extends Action {
    public static final String NAME = "IMPORT_MIDI";

    public ImportMidiAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        this.getEditor().getSongManager().getPlayer().reset();
        Shell shell = this.getEditor().getTablature().getShell();
        final String string = FileChooser.instance().open(shell, FileChooser.IMPORT_MIDI_FORMAT, TuxGuitar.instance().getFileHistory().getFileName());
        if (string != null) {
            this.getEditor().getTablature().changeCursor(1);
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Song song = new MidiImporter().importSong(string);
                        TuxGuitar.instance().getSongManager().setSong(song);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    catch (Error error) {
                        error.printStackTrace();
                    }
                    new SyncThread(new Runnable(){

                        public void run() {
                            if (!TuxGuitar.isDisposed()) {
                                ImportMidiAction.this.getEditor().resetDefaults();
                                TuxGuitar.instance().getMixer().update();
                                TuxGuitar.instance().getTableViewer().getTableInfo().fireUpdate();
                                ImportMidiAction.this.redraw();
                                ImportMidiAction.this.getEditor().getTablature().changeCursor(0);
                            }
                        }
                    }).start();
                }
            }).start();
        }
        return true;
    }

    private void showErrorMessage(final String string) {
        new SyncThread(new Runnable(){

            public void run() {
                if (!TuxGuitar.isDisposed()) {
                    ImportMidiAction.this.getEditor().getTablature().changeCursor(0);
                    String string3 = "Error Message";
                    String string2 = "Cannot Open file: " + string;
                    new MessageDialog(string3, string2, 33).show(ImportMidiAction.this.getEditor().getTablature().getShell());
                }
            }
        }).start();
    }
}

