/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.composition;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.SongCoords;
import org.herac.tuxguitar.gui.undo.undoables.custom.UndoableChangeTimeSignature;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.TimeSignature;

public class ChangeTimeSignatureAction
extends Action {
    public static final String NAME = "CHANGE_TIME_SIGNATURE";

    public ChangeTimeSignatureAction(TablatureEditor tablatureEditor) {
        super(NAME, true, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        this.showDialog(this.getEditor().getTablature().getShell());
        return true;
    }

    public void showDialog(Shell shell) {
        MeasureCoords measureCoords = this.getEditor().getTablature().getCaret().getMeasureCoords();
        if (measureCoords != null) {
            final Shell shell2 = new Shell(shell, 67680);
            shell2.setLayout(new GridLayout());
            shell2.setText(TuxGuitar.getProperty("composition.timesignature"));
            Composite composite = new Composite(shell2, 0);
            composite.setLayout(new GridLayout(2, false));
            composite.setLayoutData(new GridData(4, 4, true, true));
            TimeSignature timeSignature = measureCoords.getMeasure().getTimeSignature();
            Label label = new Label(composite, 0);
            label.setText(TuxGuitar.getProperty("composition.timesignature.Numerator"));
            final Combo combo = new Combo(composite, 0);
            for (int i = 1; i <= 32; ++i) {
                combo.add(Integer.toString(i));
            }
            combo.setText(Integer.toString(timeSignature.getNumerator()));
            combo.setLayoutData(new GridData(0x1000008, 4, true, true));
            Label label2 = new Label(composite, 0);
            label2.setText(TuxGuitar.getProperty("composition.timesignature.denominator"));
            final Combo combo2 = new Combo(composite, 0);
            for (int i = 1; i <= 32; i *= 2) {
                combo2.add(Integer.toString(i));
            }
            combo2.setText(Integer.toString(timeSignature.getDenominator().getValue()));
            combo2.setLayoutData(new GridData(0x1000008, 4, true, true));
            Composite composite2 = new Composite(shell2, 0);
            composite2.setLayout(new GridLayout());
            composite2.setLayoutData(new GridData(4, 4, true, true));
            final Button button = new Button(composite2, 32);
            button.setText(TuxGuitar.getProperty("composition.timesignature.to-the-end"));
            button.setSelection(true);
            Composite composite3 = new Composite(shell2, 0);
            composite3.setLayout(new GridLayout(2, false));
            composite3.setLayoutData(new GridData(0x1000008, 4, true, true));
            GridData gridData = new GridData(4, 4, true, true);
            gridData.minimumWidth = 80;
            gridData.minimumHeight = 25;
            Button button2 = new Button(composite3, 8);
            button2.setText(TuxGuitar.getProperty("ok"));
            button2.setLayoutData(gridData);
            button2.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    boolean bl = button.getSelection();
                    int n = Integer.parseInt(combo.getText());
                    int n2 = Integer.parseInt(combo2.getText());
                    TimeSignature timeSignature = new TimeSignature(n, new Duration(n2));
                    ChangeTimeSignatureAction.this.setTimeSignature(timeSignature, bl);
                    shell2.dispose();
                }
            });
            Button button3 = new Button(composite3, 8);
            button3.setLayoutData(gridData);
            button3.setText(TuxGuitar.getProperty("cancel"));
            button3.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    shell2.dispose();
                }
            });
            shell2.pack();
            shell2.open();
            int n = shell.getBounds().x + (shell.getBounds().width - shell2.getSize().x) / 2;
            int n2 = shell.getBounds().y + (shell.getBounds().height - shell2.getSize().y) / 2;
            shell2.setLocation(n, n2);
            while (!shell2.isDisposed()) {
                if (shell2.getDisplay().readAndDispatch()) continue;
                shell2.getDisplay().sleep();
            }
        }
    }

    private void setTimeSignature(TimeSignature timeSignature, boolean bl) {
        UndoableChangeTimeSignature undoableChangeTimeSignature = UndoableChangeTimeSignature.startUndo();
        Caret caret = this.getEditor().getTablature().getCaret();
        SongCoords songCoords = caret.getSongCoords();
        MeasureCoords measureCoords = caret.getMeasureCoords();
        this.getSongManager().changeTimeSignature(measureCoords.getMeasure().getStart(), timeSignature, bl);
        this.updateTablature();
        this.redraw();
        this.getEditor().getUndoManager().addEdit(undoableChangeTimeSignature.endUndo(timeSignature, bl));
    }
}

