/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.composition;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.SongCoords;
import org.herac.tuxguitar.gui.undo.undoables.custom.UndoableChangeTempo;
import org.herac.tuxguitar.gui.util.MessageDialog;
import org.herac.tuxguitar.song.models.Tempo;

public class ChangeTempoAction
extends Action {
    public static final String NAME = "CHANGE_TEMPO";
    private static final int MIN_TEMPO = 30;
    private static final int MAX_TEMPO = 320;

    public ChangeTempoAction(TablatureEditor tablatureEditor) {
        super(NAME, true, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        this.showDialog(this.getEditor().getTablature().getShell());
        return true;
    }

    public void showDialog(Shell shell) {
        MeasureCoords measureCoords = this.getEditor().getTablature().getCaret().getMeasureCoords();
        if (measureCoords != null) {
            final Shell shell2 = new Shell(shell, 67680);
            shell2.setLayout(new GridLayout());
            shell2.setText(TuxGuitar.getProperty("composition.tempo"));
            Composite composite = new Composite(shell2, 0);
            composite.setLayout(new GridLayout(2, false));
            composite.setLayoutData(new GridData(4, 4, true, true));
            Tempo tempo = measureCoords.getMeasure().getTempo();
            Label label = new Label(composite, 0);
            label.setText(TuxGuitar.getProperty("composition.tempo"));
            final Spinner spinner = new Spinner(composite, 2048);
            spinner.setLayoutData(new GridData(0x1000008, 4, true, true));
            spinner.setMinimum(30);
            spinner.setMaximum(320);
            spinner.setSelection(tempo.getValue());
            Composite composite2 = new Composite(shell2, 0);
            composite2.setLayout(new GridLayout(2, false));
            composite2.setLayoutData(new GridData(0x1000008, 4, true, true));
            GridData gridData = new GridData(4, 4, true, true);
            gridData.minimumWidth = 80;
            gridData.minimumHeight = 25;
            Button button = new Button(composite2, 8);
            button.setText(TuxGuitar.getProperty("ok"));
            button.setLayoutData(gridData);
            button.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    boolean bl = false;
                    int n = spinner.getSelection();
                    if (n >= 30) {
                        Tempo tempo = new Tempo(n);
                        ChangeTempoAction.this.setTempo(tempo);
                        bl = true;
                    }
                    if (!bl) {
                        ChangeTempoAction.this.showErrorMessage(TuxGuitar.getProperty("composition.tempo.invalid"));
                    }
                    shell2.dispose();
                }
            });
            Button button2 = new Button(composite2, 8);
            button2.setText(TuxGuitar.getProperty("cancel"));
            button2.setLayoutData(gridData);
            button2.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    shell2.dispose();
                }
            });
            shell2.pack();
            shell2.open();
            int n = shell.getBounds().x + (shell.getBounds().width - shell2.getSize().x) / 2;
            int n2 = shell.getBounds().y + (shell.getBounds().height - shell2.getSize().y) / 2;
            shell2.setLocation(n, n2);
            while (!shell2.isDisposed()) {
                if (shell2.getDisplay().readAndDispatch()) continue;
                shell2.getDisplay().sleep();
            }
        }
    }

    private void setTempo(Tempo tempo) {
        UndoableChangeTempo undoableChangeTempo = UndoableChangeTempo.startUndo();
        Caret caret = this.getEditor().getTablature().getCaret();
        SongCoords songCoords = caret.getSongCoords();
        MeasureCoords measureCoords = caret.getMeasureCoords();
        this.getSongManager().changeTempo(measureCoords.getMeasure().getStart(), tempo, true);
        this.updateTablature();
        this.redraw();
        this.getEditor().getUndoManager().addEdit(undoableChangeTempo.endUndo(tempo));
    }

    private void showErrorMessage(String string) {
        String string2 = "Error Message";
        new MessageDialog(string2, string, 33).show(this.getEditor().getTablature().getShell());
    }
}

