/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.models;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.MeasureHeader;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.RGBColor;
import org.herac.tuxguitar.song.models.Silence;
import org.herac.tuxguitar.song.models.SongChannel;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;

public class SongTrack
implements Serializable {
    public static final int MAX_OFFSET = 24;
    public static final int MIN_OFFSET = -24;
    private long number;
    private SongChannel channel;
    private String name;
    private List measures;
    private List strings;
    private RGBColor color;
    private int offset;

    public SongTrack(long l, String string, SongChannel songChannel, List list, List list2, int n, RGBColor rGBColor) {
        this.number = l;
        this.name = string;
        this.channel = songChannel;
        this.measures = list;
        this.strings = list2;
        this.color = rGBColor;
        this.offset = n;
    }

    public long getNumber() {
        return this.number;
    }

    public void setNumber(long l) {
        this.number = l;
    }

    public List getMeasures() {
        return this.measures;
    }

    public void setMeasures(List list) {
        this.measures = list;
    }

    public SongChannel getChannel() {
        return this.channel;
    }

    public void setChannel(SongChannel songChannel) {
        this.channel = songChannel;
    }

    public List getStrings() {
        return this.strings;
    }

    public void setStrings(List list) {
        this.strings = list;
    }

    public RGBColor getColor() {
        return this.color;
    }

    public void setColor(RGBColor rGBColor) {
        this.color = rGBColor;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int n) {
        this.offset = n;
    }

    public boolean isPercussionTrack() {
        return this.getChannel().isPercusionChannel();
    }

    public void makeEqual(SongTrack songTrack, List list) {
        songTrack = (SongTrack)songTrack.clone(list);
        this.number = songTrack.getNumber();
        this.name = songTrack.getName();
        this.channel = songTrack.getChannel();
        this.measures = songTrack.getMeasures();
        this.strings = songTrack.getStrings();
        this.color = songTrack.getColor();
    }

    public Object clone(List list) {
        int n;
        Object object;
        Object object2;
        Object object3;
        Serializable serializable;
        ArrayList<Measure> arrayList = new ArrayList<Measure>();
        for (int i = 0; i < this.getMeasures().size(); ++i) {
            Measure measure = (Measure)this.getMeasures().get(i);
            serializable = (TimeSignature)measure.getTimeSignature().clone();
            object3 = (Tempo)measure.getTempo().clone();
            object2 = new ArrayList();
            for (int j = 0; j < measure.getNotes().size(); ++j) {
                Note note = (Note)measure.getNotes().get(j);
                object2.add((Note)note.clone());
            }
            object = new ArrayList();
            for (n = 0; n < measure.getSilences().size(); ++n) {
                Silence silence = (Silence)measure.getSilences().get(n);
                object.add((Silence)silence.clone());
            }
            arrayList.add(new Measure((MeasureHeader)list.get(i), (List)object2, (List)object, measure.getClef(), measure.getKeySignature()));
        }
        ArrayList<InstrumentString> arrayList2 = new ArrayList<InstrumentString>();
        for (int i = 0; i < this.getStrings().size(); ++i) {
            serializable = (InstrumentString)this.getStrings().get(i);
            arrayList2.add((InstrumentString)((InstrumentString)serializable).clone());
        }
        long l = this.getNumber();
        object3 = this.getName();
        object2 = (SongChannel)this.getChannel().clone();
        object = (RGBColor)this.getColor().clone();
        n = this.getOffset();
        return new SongTrack(l, (String)object3, (SongChannel)object2, arrayList, arrayList2, n, (RGBColor)object);
    }
}

