/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.managers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.gui.tab.TablatureUtil;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.BendEffect;
import org.herac.tuxguitar.song.models.Component;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.Silence;
import org.herac.tuxguitar.song.models.Tupleto;

public class MeasureManager {
    private SongManager songManager;

    public MeasureManager(SongManager songManager) {
        this.songManager = songManager;
    }

    public void orderNotes(Measure measure) {
        for (int i = 0; i < measure.getNotes().size(); ++i) {
            Note note = null;
            for (int j = i; j < measure.getNotes().size(); ++j) {
                Note note2 = (Note)measure.getNotes().get(j);
                if (note != null && note2.getStart() >= note.getStart()) continue;
                note = note2;
            }
            measure.getNotes().remove(note);
            measure.getNotes().add(i, note);
        }
    }

    public void addNote(Measure measure, Note note) {
        if (this.canInsert(measure, note, true, false)) {
            this.removeComponentsAt(measure, note.getStart(), note.getString(), false);
            measure.addNote(note);
            this.tryChangeSilenceAfter(measure, note);
        }
    }

    public void removeNote(Measure measure, Note note) {
        measure.removeNote(note);
    }

    public void addSilence(Measure measure, Silence silence) {
        if (this.canInsert(measure, silence, true, false)) {
            this.removeAllComponentsAt(measure, silence.getStart());
            measure.addSilence(silence);
        }
    }

    public void removeSilence(Measure measure, Silence silence) {
        measure.removeSilence(silence);
    }

    public void removeSilence(Measure measure, Silence silence, boolean bl) {
        List list = this.getComponents(measure);
        Component component = this.getComponent(list, silence.getStart());
        Component component2 = this.getNextComponent(list, component);
        this.removeSilence(measure, silence);
        if (bl) {
            long l = silence.getStart();
            long l2 = silence.getDuration().getTime();
            if (component2 != null) {
                l2 = component2.getStart() - l;
            }
            this.moveComponents(measure, l + l2, -l2);
        }
    }

    public void removeNotesAfterString(Measure measure, int n) {
        ArrayList<Note> arrayList = new ArrayList<Note>();
        for (Note note : measure.getNotes()) {
            if (note.getString() <= n) continue;
            arrayList.add(note);
        }
        for (Note note : arrayList) {
            this.removeNote(measure, note);
        }
    }

    public List getNotes(Measure measure, long l) {
        ArrayList<Note> arrayList = new ArrayList<Note>();
        for (Note note : measure.getNotes()) {
            if (note.getStart() != l) continue;
            arrayList.add(note);
        }
        return arrayList;
    }

    public Note getNote(Measure measure, long l, int n) {
        for (Note note : measure.getNotes()) {
            if (note.getStart() != l || note.getString() != n) continue;
            return note;
        }
        return null;
    }

    public void moveAllNotes(Measure measure, long l) {
        this.moveComponents(measure.getNotes(), l);
    }

    public void moveAllSilences(Measure measure, long l) {
        this.moveComponents(measure.getSilences(), l);
    }

    public void moveAllComponents(Measure measure, long l) {
        this.moveComponents(this.getComponents(measure), l);
    }

    public boolean moveComponents(Measure measure, long l, long l2) {
        long l3 = measure.getStart();
        long l4 = measure.getLength();
        List list = this.getComponentsBeforeEnd(this.getComponents(measure), l);
        this.moveComponents(list, l2);
        Component component = this.getFirstComponent(this.getComponents(measure));
        while (component instanceof Silence) {
            this.removeSilence(measure, (Silence)component);
            component = this.getNextComponent(this.getComponents(measure), component);
        }
        Component component2 = this.getLastComponent(this.getComponents(measure));
        while (component2 instanceof Silence) {
            this.removeSilence(measure, (Silence)component2);
            component2 = this.getPreviousComponent(this.getComponents(measure), component2);
        }
        if (component != null && component2 != null && (component.getStart() < l3 || component2.getStart() + component2.getDuration().getTime() > l3 + l4)) {
            this.moveComponents(list, -l2);
            return false;
        }
        return true;
    }

    private void moveComponents(List list, long l) {
        for (Component component : list) {
            this.moveComponent(component, l);
        }
    }

    private void moveComponent(Component component, long l) {
        long l2 = component.getStart();
        component.setStart(l2 + l);
    }

    public List getSilences(Measure measure, long l) {
        ArrayList<Silence> arrayList = new ArrayList<Silence>();
        for (int i = 0; i < measure.getSilences().size(); ++i) {
            Silence silence = (Silence)measure.getSilences().get(i);
            if (silence.getStart() != l) continue;
            arrayList.add(silence);
        }
        return arrayList;
    }

    public Silence getNextSilence(Measure measure, Component component) {
        Silence silence = null;
        for (int i = 0; i < measure.getSilences().size(); ++i) {
            Silence silence2 = (Silence)measure.getSilences().get(i);
            if (silence2.getStart() <= component.getStart()) continue;
            if (silence == null) {
                silence = silence2;
                continue;
            }
            if (silence2.getStart() < silence.getStart()) {
                silence = silence2;
                continue;
            }
            if (silence2.getStart() != silence.getStart() || silence2.getDuration().getTime() > silence.getDuration().getTime()) continue;
            silence = silence2;
        }
        return silence;
    }

    public List getComponents(Measure measure) {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(measure.getNotes());
        arrayList.addAll(measure.getSilences());
        return arrayList;
    }

    public Component getNextComponent(List list, Component component) {
        Component component2 = null;
        for (int i = 0; i < list.size(); ++i) {
            Component component3 = (Component)list.get(i);
            if (component3.getStart() <= component.getStart()) continue;
            if (component2 == null) {
                component2 = component3;
                continue;
            }
            if (component3.getStart() < component2.getStart()) {
                component2 = component3;
                continue;
            }
            if (component3.getStart() != component2.getStart() || component3.getDuration().getTime() > component2.getDuration().getTime()) continue;
            component2 = component3;
        }
        return component2;
    }

    public Component getPreviousComponent(List list, Component component) {
        Component component2 = null;
        for (int i = 0; i < list.size(); ++i) {
            Component component3 = (Component)list.get(i);
            if (component3.getStart() >= component.getStart()) continue;
            if (component2 == null) {
                component2 = component3;
                continue;
            }
            if (component3.getStart() > component2.getStart()) {
                component2 = component3;
                continue;
            }
            if (component3.getStart() != component2.getStart() || component3.getDuration().getTime() > component2.getDuration().getTime()) continue;
            component2 = component3;
        }
        return component2;
    }

    public Component getFirstComponent(List list) {
        Component component = null;
        for (int i = 0; i < list.size(); ++i) {
            Component component2 = (Component)list.get(i);
            if (component != null && component2.getStart() >= component.getStart()) continue;
            component = component2;
        }
        return component;
    }

    public Component getLastComponent(List list) {
        Component component = null;
        for (int i = 0; i < list.size(); ++i) {
            Component component2 = (Component)list.get(i);
            if (component != null && component.getStart() >= component2.getStart()) continue;
            component = component2;
        }
        return component;
    }

    public List getComponents(List list, long l) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (int i = 0; i < list.size(); ++i) {
            Component component = (Component)list.get(i);
            if (component.getStart() != l) continue;
            arrayList.add(component);
        }
        return arrayList;
    }

    public Component getComponent(List list, long l) {
        Component component = null;
        for (int i = 0; i < list.size(); ++i) {
            Component component2 = (Component)list.get(i);
            if (component2.getStart() != l) continue;
            component = component2;
            break;
        }
        return component;
    }

    public List getComponentsBeforeEnd(List list, long l) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (Component component : list) {
            if (component.getStart() < l) continue;
            arrayList.add(component);
        }
        return arrayList;
    }

    public Component getComponentAtSameBeat(List list, Component component) {
        Component component2 = null;
        for (int i = 0; i < list.size(); ++i) {
            Component component3 = (Component)list.get(i);
            if (component3.getStart() != component.getStart() || component3.equals(component)) continue;
            component2 = component3;
            break;
        }
        return component2;
    }

    public void removeComponentsAt(Measure measure, long l, int n, boolean bl) {
        List list;
        if (n != -1) {
            list = this.getNotes(measure, l);
            for (Component component : list) {
                if (((Note)component).getString() != n) continue;
                this.removeNote(measure, (Note)component);
                if (!bl || list.size() != 1) continue;
                this.addSilence(measure, new Silence(((Note)component).getStart(), (Duration)((Note)component).getDuration().clone()));
            }
        }
        list = this.getSilences(measure, l);
        for (Component component : list) {
            this.removeSilence(measure, (Silence)component);
        }
    }

    public void removeAllComponentsAt(Measure measure, long l) {
        Object object2;
        List list = this.getNotes(measure, l);
        for (Object object2 : list) {
            this.removeNote(measure, (Note)object2);
        }
        object2 = this.getSilences(measure, l);
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            Silence silence = (Silence)iterator.next();
            this.removeSilence(measure, silence);
        }
    }

    public void orderComponents(List list) {
        for (int i = 0; i < list.size(); ++i) {
            Component component = null;
            for (int j = i; j < list.size(); ++j) {
                Component component2 = (Component)list.get(j);
                if (component != null && component2.getStart() >= component.getStart()) continue;
                component = component2;
            }
            list.remove(component);
            list.add(i, component);
        }
    }

    public void transposeNotes(Measure measure, List list, int n) {
        for (Note note : measure.getNotes()) {
            int n2;
            int n3 = note.getValue() + n;
            if (n3 < 0) {
                for (n2 = note.getString(); list.size() > n2; ++n2) {
                    InstrumentString instrumentString = (InstrumentString)list.get(n2 - 1);
                    InstrumentString instrumentString2 = (InstrumentString)list.get(n2);
                    if ((n3 += instrumentString.getValue() - instrumentString2.getValue()) < 0) continue;
                    break;
                }
            }
            if (n3 < 0) continue;
            note.setValue(n3);
            note.setString(n2);
        }
    }

    public boolean canInsert(Measure measure, Component component, boolean bl, boolean bl2) {
        long l;
        Component component2;
        boolean bl3 = true;
        int n = 10;
        List list = this.getComponents(measure);
        this.orderComponents(list);
        if (component instanceof Note && (component2 = this.getComponentAtSameBeat(list, component)) instanceof Note && component.getDuration().getTime() <= component2.getDuration().getTime()) {
            return true;
        }
        component2 = this.getNextComponent(list, component);
        long l2 = component.getStart() + component.getDuration().getTime();
        if (component2 == null) {
            if (l2 > measure.getStart() + measure.getLength() + (long)n) {
                bl3 = false;
            }
        } else if (l2 > component2.getStart() + (long)n) {
            bl3 = false;
        }
        if (bl && !bl3 && component2 instanceof Silence) {
            l = 0L;
            ArrayList<Component> arrayList = new ArrayList<Component>();
            while (component2 instanceof Silence) {
                arrayList.add(component2);
                l = component2.getStart() + component2.getDuration().getTime();
                component2 = this.getNextComponent(list, component2);
            }
            if (component2 == null) {
                l = measure.getStart() + measure.getLength();
            } else if (component2 instanceof Note) {
                l = component2.getStart();
            }
            if (l2 <= l + (long)n) {
                while (!arrayList.isEmpty()) {
                    Silence silence = (Silence)arrayList.get(0);
                    measure.removeSilence(silence);
                    arrayList.remove(silence);
                }
                bl3 = true;
            }
        }
        if (!bl3 && bl && bl2 && (component2 = this.getNextComponent(list, component)) != null) {
            l = component.getDuration().getTime() - (component2.getStart() - component.getStart());
            long l3 = 0L;
            ArrayList<Silence> arrayList = new ArrayList<Silence>();
            Silence silence = this.getNextSilence(measure, component);
            while (silence != null) {
                arrayList.add(silence);
                l3 += silence.getDuration().getTime();
                silence = this.getNextSilence(measure, silence);
            }
            if (l <= l3 + (long)n) {
                list = this.getComponentsBeforeEnd(list, component2.getStart());
                while (!list.isEmpty()) {
                    Component component3 = (Component)list.get(0);
                    if (component3 instanceof Silence) {
                        Silence silence2 = (Silence)component3;
                        l -= silence2.getDuration().getTime();
                        measure.removeSilence(silence2);
                    } else if (l > 0L) {
                        this.moveComponent(component3, l);
                    }
                    list.remove(0);
                }
                bl3 = true;
            }
        }
        return bl3;
    }

    public void changeDuration(Measure measure, Component component, Duration duration) {
        this.changeDuration(measure, component, duration, true);
    }

    public void changeDuration(Measure measure, Component component, Duration duration, boolean bl) {
        Duration duration2 = (Duration)component.getDuration().clone();
        component.setDuration((Duration)duration.clone());
        if (this.canInsert(measure, component, true, bl)) {
            List list = this.getNotes(measure, component.getStart());
            for (Component component2 : list) {
                component2.setDuration((Duration)duration.clone());
            }
            boolean bl2 = component.getDuration().getTime() > duration2.getTime();
            this.tryChangeSilenceAfter(measure, component, bl2);
        } else {
            component.setDuration(duration2);
        }
    }

    public void tryChangeSilenceAfter(Measure measure, Component component) {
        this.tryChangeSilenceAfter(measure, component, true);
    }

    public void tryChangeSilenceAfter(Measure measure, Component component, boolean bl) {
        List list = this.getComponents(measure);
        this.autoCompleteSilences(measure, list);
        Component component2 = this.getNextComponent(this.getComponents(measure), component);
        long l = component.getStart() + component.getDuration().getTime();
        long l2 = measure.getStart() + measure.getLength();
        if (component2 instanceof Silence && l <= l2) {
            long l3 = this.getRealStart(measure, l) - this.getRealStart(measure, component2.getStart());
            if (component2.getStart() + l3 < l2 && component2.getStart() + component2.getDuration().getTime() + l3 <= l2) {
                this.moveComponent(component2, l3);
                this.changeDuration(measure, component2, (Duration)component.getDuration().clone(), bl);
            }
        }
    }

    public void autoCompleteSilences(Measure measure) {
        this.autoCompleteSilences(measure, this.getComponents(measure));
    }

    public void autoCompleteSilences(Measure measure, List list) {
        long l = measure.getStart();
        long l2 = 0L;
        long l3 = 0L;
        Component component = this.getFirstComponent(list);
        while (component != null) {
            l2 = component.getStart() + component.getDuration().getTime();
            if (component.getStart() > l && (l3 = component.getStart() - l) > 0L) {
                this.createSilences(measure, l, l3);
            }
            l = l2;
            component = this.getNextComponent(list, component);
        }
        l2 = measure.getStart() + measure.getLength();
        l3 = l2 - l;
        if (l3 > 0L) {
            this.createSilences(measure, l, l3);
        }
    }

    public void createSilences(Measure measure, long l, long l2) {
        List list = TablatureUtil.createDurations(l2);
        for (Duration duration : list) {
            Silence silence = new Silence(l, duration);
            this.addSilence(measure, silence);
            l += duration.getTime();
        }
    }

    public long getRealStart(Measure measure, long l) {
        boolean bl;
        long l2 = l;
        long l3 = TablatureUtil.getBeatLength(measure.getTimeSignature());
        boolean bl2 = bl = l2 % l3 == 0L;
        if (!bl) {
            Duration duration = new Duration(64, false, false, new Tupleto(3, 2));
            int n = 0;
            while ((long)n < duration.getTime()) {
                boolean bl3 = bl = ++l2 % l3 == 0L;
                if (bl) break;
                ++n;
            }
            if (!bl) {
                l2 = l;
            }
        }
        return l2;
    }

    public boolean areInSameBeat(Measure measure, Component component, Component component2) {
        long l = measure.getStart() + measure.getLength();
        long l2 = TablatureUtil.getBeatLength(measure.getTimeSignature());
        long l3 = this.getRealStart(measure, component.getStart());
        long l4 = this.getRealStart(measure, component2.getStart());
        long l5 = measure.getStart();
        boolean bl = false;
        while (!bl) {
            if (l3 >= l5 && l3 < l5 + l2 && l4 >= l5 && l4 < l5 + l2) {
                return true;
            }
            if ((l5 += l2) <= l) continue;
            bl = true;
        }
        return false;
    }

    public void changeTieNote(Measure measure, long l, int n) {
        Note note = this.getNote(measure, l, n);
        if (note != null) {
            this.changeTieNote(note);
        }
    }

    public void changeTieNote(Note note) {
        note.setTiedNote(!note.isTiedNote());
        note.getEffect().setDeadNote(false);
    }

    public void changeVibratoNote(Measure measure, long l, int n) {
        Note note = this.getNote(measure, l, n);
        if (note != null) {
            note.getEffect().setVibrato(!note.getEffect().isVibrato());
        }
    }

    public void changeDeadNote(Note note) {
        note.getEffect().set(note.getEffect().isVibrato(), null, !note.getEffect().isDeadNote(), false, false);
        note.setTiedNote(false);
    }

    public void changeSlideNote(Measure measure, long l, int n) {
        Note note = this.getNote(measure, l, n);
        if (note != null) {
            note.getEffect().set(note.getEffect().isVibrato(), null, false, !note.getEffect().isSlide(), false);
        }
    }

    public void changeHammerNote(Measure measure, long l, int n) {
        Note note = this.getNote(measure, l, n);
        if (note != null) {
            note.getEffect().set(note.getEffect().isVibrato(), null, false, false, !note.getEffect().isHammer());
        }
    }

    public void changeBendNote(Measure measure, long l, int n, BendEffect bendEffect) {
        Note note = this.getNote(measure, l, n);
        if (note != null) {
            note.getEffect().set(note.getEffect().isVibrato(), bendEffect, false, false, false);
        }
    }

    public void calculateNoteStartWidthRepetitions(Measure measure, long l) {
        for (int i = 0; i < measure.getNotes().size(); ++i) {
            Note note = (Note)measure.getNotes().get(i);
            note.setStartWidthRepetitions(note.getStart() + l);
        }
    }
}

