/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.play.models.tg_player;

import javax.sound.midi.Receiver;
import org.herac.tuxguitar.play.models.tg_player.MidiMessageUtils;
import org.herac.tuxguitar.song.models.Song;
import org.herac.tuxguitar.song.models.SongChannel;
import org.herac.tuxguitar.song.models.SongTrack;

public class ChannelControl {
    private Receiver receiver;

    public ChannelControl(Receiver receiver) {
        this.receiver = receiver;
    }

    public void update(Song song) {
        for (int i = 0; i < song.getTracks().size(); ++i) {
            SongTrack songTrack = (SongTrack)song.getTracks().get(i);
            this.updateChannel(songTrack.getChannel());
        }
    }

    public void updateChannel(SongChannel songChannel) {
        this.receiver.send(MidiMessageUtils.programChange(songChannel.getChannel(), songChannel.getInstrument()), -1L);
        this.receiver.send(MidiMessageUtils.controlChange(songChannel.getChannel(), 7, songChannel.getVolume()), -1L);
        this.receiver.send(MidiMessageUtils.controlChange(songChannel.getChannel(), 10, songChannel.getBalance()), -1L);
        this.receiver.send(MidiMessageUtils.controlChange(songChannel.getChannel(), 91, songChannel.getReverb()), -1L);
        this.receiver.send(MidiMessageUtils.controlChange(songChannel.getChannel(), 93, songChannel.getChorus()), -1L);
        this.receiver.send(MidiMessageUtils.controlChange(songChannel.getChannel(), 95, songChannel.getPhaser()), -1L);
        this.receiver.send(MidiMessageUtils.controlChange(songChannel.getChannel(), 92, songChannel.getTremolo()), -1L);
        if (songChannel.getChannel() != songChannel.getEffectChannel()) {
            this.receiver.send(MidiMessageUtils.programChange(songChannel.getEffectChannel(), songChannel.getInstrument()), -1L);
            this.receiver.send(MidiMessageUtils.controlChange(songChannel.getEffectChannel(), 7, songChannel.getVolume()), -1L);
            this.receiver.send(MidiMessageUtils.controlChange(songChannel.getEffectChannel(), 10, songChannel.getBalance()), -1L);
            this.receiver.send(MidiMessageUtils.controlChange(songChannel.getEffectChannel(), 91, songChannel.getReverb()), -1L);
            this.receiver.send(MidiMessageUtils.controlChange(songChannel.getEffectChannel(), 93, songChannel.getChorus()), -1L);
            this.receiver.send(MidiMessageUtils.controlChange(songChannel.getEffectChannel(), 95, songChannel.getPhaser()), -1L);
            this.receiver.send(MidiMessageUtils.controlChange(songChannel.getEffectChannel(), 92, songChannel.getTremolo()), -1L);
        }
    }
}

