/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.play.models.defaultplayer;

import java.util.List;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.BendEffect;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.SongChannel;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;
import org.herac.tuxguitar.song.models.Tupleto;

public class SongSequence {
    private static final int DEFAULT_BEND = 64;
    private static final int DEFAULT_DEAD_NOTE_DURATION = 50;
    private Sequence sequence;
    private SongManager songManager;
    private int fisrtTickMove;

    public SongSequence(SongManager songManager, int n) {
        this.songManager = songManager;
        this.fisrtTickMove = n;
    }

    public void createSongSecuence(boolean bl) {
        this.createSecuence(bl);
    }

    public Sequence getSongSecuence() {
        return this.sequence;
    }

    private void createSecuence(boolean bl) {
        try {
            this.sequence = new Sequence(0.0f, 1000);
            for (int i = 0; i < this.songManager.getSong().getTracks().size(); ++i) {
                SongTrack songTrack = (SongTrack)this.songManager.getSong().getTracks().get(i);
                this.createTrack(songTrack, i == 0, bl);
            }
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
        }
    }

    private void createTrack(SongTrack songTrack, boolean bl, boolean bl2) {
        try {
            Track track = this.sequence.createTrack();
            this.makeInstrument(track, songTrack.getChannel().getChannel(), songTrack.getChannel().getInstrument());
            this.addBend(track, 1000L, 64, songTrack.getChannel().getChannel());
            this.setChannelValues(track, songTrack.getChannel());
            long l = 1000L;
            boolean bl3 = true;
            long l2 = 0L;
            long l3 = 0L;
            int n = 0;
            int n2 = 0;
            if (songTrack.getChannel().getChannel() != songTrack.getChannel().getEffectChannel()) {
                this.makeInstrument(track, songTrack.getChannel().getEffectChannel(), songTrack.getChannel().getInstrument());
            }
            Measure measure = null;
            for (int i = 0; i < songTrack.getMeasures().size(); ++i) {
                Measure measure2 = (Measure)songTrack.getMeasures().get(i);
                if (bl && bl2) {
                    this.makeStartMoveMetaMessage(track, measure2.getStart(), l3);
                }
                this.makeNotes(track, songTrack, measure2, i, l3, songTrack.getChannel().getEffectChannel());
                this.addTimeSignature(measure2, measure, l3, track);
                this.addTempo(measure2, measure, l3, track);
                if (measure2.isRepeatStart()) {
                    n = i;
                    l = measure2.getStart();
                    bl3 = true;
                }
                if (bl3 && measure2.getNumberOfRepetitions() > 0) {
                    if (n2 < measure2.getNumberOfRepetitions()) {
                        l2 = measure2.getStart() + measure2.getLength();
                        l3 += l2 - l;
                        i = n - 1;
                        ++n2;
                    } else {
                        l = 0L;
                        n2 = 0;
                        l2 = 0L;
                        bl3 = false;
                    }
                }
                measure = measure2;
            }
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
        }
    }

    private void makeNotes(Track track, SongTrack songTrack, Measure measure, int n, long l, int n2) {
        for (int i = 0; i < measure.getNotes().size(); ++i) {
            Note note;
            Note note2 = (Note)measure.getNotes().get(i);
            if (note2.isTiedNote()) continue;
            int n3 = songTrack.getOffset() + note2.getValue() + ((InstrumentString)songTrack.getStrings().get(note2.getString() - 1)).getValue();
            NoteData noteData = this.checkTripletFeel(measure, note2, i);
            long l2 = noteData.start + l;
            long l3 = this.getRealNoteDuration(note2, noteData.duration, songTrack.getMeasures(), n, i);
            int n4 = note2.getVelocity();
            short s = songTrack.getChannel().getChannel();
            if (!songTrack.isPercussionTrack() && (note = this.getPrevNote(note2, songTrack.getMeasures(), n, i)) != null && note.getEffect().isHammer()) {
                n4 -= 25;
            }
            if (note2.getEffect().hasEffects() && n2 >= 0 && !songTrack.isPercussionTrack()) {
                this.makeNote(track, n3, l2, l3, n4, n2);
                if (note2.getEffect().isBend()) {
                    this.makeBend(track, l2, l3, note2.getEffect().getBend(), n2);
                    continue;
                }
                if (note2.getEffect().isSlide()) {
                    note = this.getNextNote(note2, songTrack.getMeasures(), n, i);
                    this.makeSlide(track, note2, note, l, n2);
                    continue;
                }
                if (!note2.getEffect().isVibrato()) continue;
                this.makeVibrato(track, l2, l3, n2);
                continue;
            }
            this.makeNote(track, n3, l2, l3, n4, s);
        }
    }

    private void makeNote(Track track, int n, long l, long l2, int n2, int n3) {
        try {
            ShortMessage shortMessage = new ShortMessage();
            ShortMessage shortMessage2 = new ShortMessage();
            shortMessage.setMessage(144, n3, n, n2);
            shortMessage2.setMessage(128, n3, n, n2);
            track.add(this.getMidiEvent(shortMessage, l));
            track.add(this.getMidiEvent(shortMessage2, l + l2));
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
        }
    }

    public void muteChannels() {
        try {
            if (this.sequence.getTracks().length > 0) {
                Track track = this.sequence.getTracks()[0];
                for (int i = 0; i < SongManager.MAX_CHANNELS; ++i) {
                    ShortMessage shortMessage = new ShortMessage();
                    shortMessage.setMessage(176, i, 7, 0);
                    track.add(this.getMidiEvent(shortMessage, 1000L));
                }
            }
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
        }
    }

    public void setChannelValues(Track track, SongChannel songChannel) {
        try {
            ShortMessage shortMessage = new ShortMessage();
            ShortMessage shortMessage2 = new ShortMessage();
            shortMessage.setMessage(176, songChannel.getChannel(), 7, songChannel.getVolume());
            shortMessage2.setMessage(176, songChannel.getChannel(), 10, songChannel.getBalance());
            track.add(this.getMidiEvent(shortMessage, 1000L));
            track.add(this.getMidiEvent(shortMessage2, 1000L));
            if (songChannel.getChannel() != songChannel.getEffectChannel()) {
                shortMessage = new ShortMessage();
                shortMessage2 = new ShortMessage();
                shortMessage.setMessage(176, songChannel.getEffectChannel(), 7, songChannel.getVolume());
                shortMessage2.setMessage(176, songChannel.getEffectChannel(), 10, songChannel.getBalance());
                track.add(this.getMidiEvent(shortMessage, 1000L));
                track.add(this.getMidiEvent(shortMessage2, 1000L));
            }
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
        }
    }

    private void makeInstrument(Track track, int n, int n2) {
        try {
            ShortMessage shortMessage = new ShortMessage();
            shortMessage.setMessage(192, n, n2, 0);
            track.add(this.getMidiEvent(shortMessage, 1000L));
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
            System.exit(1);
        }
    }

    private void addTimeSignature(Measure measure, Measure measure2, long l, Track track) throws InvalidMidiDataException {
        boolean bl = false;
        if (measure2 == null) {
            bl = true;
        } else {
            int n = measure.getTimeSignature().getNumerator();
            int n2 = measure.getTimeSignature().getDenominator().getValue();
            int n3 = measure2.getTimeSignature().getNumerator();
            int n4 = measure2.getTimeSignature().getDenominator().getValue();
            if (n != n3 || n2 != n4) {
                bl = true;
            }
        }
        if (bl) {
            this.addTimeSignature(measure.getTimeSignature(), measure.getStart() + l, track);
        }
    }

    private void addTimeSignature(TimeSignature timeSignature, long l, Track track) throws InvalidMidiDataException {
        MetaMessage metaMessage = new MetaMessage();
        byte[] byArray = new byte[4];
        byArray[0] = (byte)timeSignature.getNumerator();
        if (timeSignature.getDenominator().getValue() == 1) {
            byArray[1] = 0;
        } else if (timeSignature.getDenominator().getValue() == 2) {
            byArray[1] = 1;
        } else if (timeSignature.getDenominator().getValue() == 4) {
            byArray[1] = 2;
        } else if (timeSignature.getDenominator().getValue() == 8) {
            byArray[1] = 3;
        } else if (timeSignature.getDenominator().getValue() == 16) {
            byArray[1] = 4;
        } else if (timeSignature.getDenominator().getValue() == 32) {
            byArray[1] = 5;
        } else {
            throw new InvalidMidiDataException();
        }
        byArray[2] = (byte)(96 / timeSignature.getDenominator().getValue());
        byArray[3] = 8;
        metaMessage.setMessage(88, byArray, 4);
        MidiEvent midiEvent = this.getMidiEvent(metaMessage, l);
        track.add(midiEvent);
    }

    private void addTempo(Measure measure, Measure measure2, long l, Track track) throws InvalidMidiDataException {
        boolean bl = false;
        if (measure2 == null) {
            bl = true;
        } else if (measure.getTempo().getValue() != measure2.getTempo().getValue()) {
            bl = true;
        }
        if (bl) {
            this.addTempo(measure.getTempo(), measure.getStart() + l, track);
        }
    }

    private void addTempo(Tempo tempo, long l, Track track) throws InvalidMidiDataException {
        int n = (int)tempo.getInUSQ();
        MetaMessage metaMessage = new MetaMessage();
        byte[] byArray = new byte[]{(byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        metaMessage.setMessage(81, byArray, 3);
        MidiEvent midiEvent = this.getMidiEvent(metaMessage, l);
        track.add(midiEvent);
    }

    private long getRealNoteDuration(Note note, long l, List list, int n, int n2) {
        if (note.getEffect().isDeadNote()) {
            return 50L;
        }
        ++n2;
        for (int i = n; i < list.size(); ++i) {
            Measure measure = (Measure)list.get(i);
            for (int j = n2; j < measure.getNotes().size(); ++j) {
                Note note2 = (Note)measure.getNotes().get(j);
                if (note2.equals(note) || note2.getString() != note.getString()) continue;
                if (note2.isTiedNote()) {
                    l += note2.getDuration().getTime();
                    continue;
                }
                return l;
            }
            n2 = 0;
        }
        return l;
    }

    public void makeStartMoveMetaMessage(Track track, long l, long l2) {
        try {
            MetaMessage metaMessage = new MetaMessage();
            byte[] byArray = this.parseBytes(l2);
            metaMessage.setMessage(1, byArray, byArray.length);
            MidiEvent midiEvent = this.getMidiEvent(metaMessage, l + l2);
            track.add(midiEvent);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
        }
    }

    private byte[] parseBytes(long l) {
        byte[] byArray = new byte[]{(byte)(l & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 24 & 0xFFL), (byte)(l >> 32 & 0xFFL), (byte)(l >> 40 & 0xFFL), (byte)(l >> 48 & 0xFFL), (byte)(l >> 56 & 0xFFL)};
        return byArray;
    }

    private void addBend(Track track, long l, int n, int n2) {
        try {
            n = n > 127 ? 127 : n;
            ShortMessage shortMessage = new ShortMessage();
            shortMessage.setMessage(224, n2, 0, n);
            track.add(this.getMidiEvent(shortMessage, l));
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
        }
    }

    public void makeVibrato(Track track, long l, long l2, int n) {
        long l3 = l + l2;
        while (l < l3) {
            l = l + 160L > l3 ? l3 : l + 160L;
            this.addBend(track, l, 64, n);
            l = l + 160L > l3 ? l3 : l + 160L;
            this.addBend(track, l, 72, n);
        }
        this.addBend(track, l, 64, n);
    }

    public void makeBend(Track track, long l, long l2, BendEffect bendEffect, int n) {
        List list = bendEffect.getPoints();
        for (int i = 0; i < list.size(); ++i) {
            BendEffect.BendPoint bendPoint = (BendEffect.BendPoint)list.get(i);
            int n2 = 64 + bendPoint.getValue() * 8;
            long l3 = l + bendPoint.getTime(l2);
            this.addBend(track, l3, n2, n);
            if (list.size() <= i + 1) continue;
            BendEffect.BendPoint bendPoint2 = (BendEffect.BendPoint)list.get(i + 1);
            int n3 = 64 + bendPoint2.getValue() * 8;
            long l4 = l + bendPoint2.getTime(l2);
            double d = l4 - l3;
            double d2 = d = n3 - n2 > 0 ? d / (double)(n3 - n2) : 16.0;
            if (n2 < n3) {
                while (n2 < n3) {
                    l3 = (long)((double)l3 + d);
                    this.addBend(track, l3, ++n2, n);
                }
                continue;
            }
            if (n2 <= n3) continue;
            while (n2 > n3) {
                l3 = (long)((double)l3 + d);
                this.addBend(track, l3, --n2, n);
            }
        }
        this.addBend(track, l + l2, 64, n);
    }

    public void makeSlide(Track track, Note note, Note note2, long l, int n) {
        if (note2 != null) {
            long l2 = note2.getStart() + l;
            int n2 = Math.abs(note2.getValue() - note.getValue());
            int n3 = n2 = n2 > 2 ? 2 : n2;
            if (note2.getValue() > note.getValue()) {
                for (int i = 64 + 31 * n2; i > 64; i -= 10) {
                    this.addBend(track, l2 -= (long)(40 / n2), i, n);
                }
            } else if (note2.getValue() < note.getValue()) {
                for (int i = 64; i > 64 - 31 * n2; i -= 10) {
                    this.addBend(track, l2 -= (long)(40 / n2), i, n);
                }
            }
            this.addBend(track, note2.getStart() + l, 64, n);
        }
    }

    private MidiEvent getMidiEvent(MidiMessage midiMessage, long l) {
        return new MidiEvent(midiMessage, l + (long)this.fisrtTickMove);
    }

    private Note getNextNote(Note note, List list, int n, int n2) {
        Note note2 = null;
        ++n2;
        for (int i = n; i < list.size(); ++i) {
            Measure measure = (Measure)list.get(i);
            for (int j = n2; j < measure.getNotes().size(); ++j) {
                Note note3 = (Note)measure.getNotes().get(j);
                if (note3.getString() != note.getString() || note3.getStart() <= note.getStart() || note2 != null && note3.getStart() >= note2.getStart()) continue;
                note2 = note3;
            }
            n2 = 0;
        }
        return note2;
    }

    private Note getPrevNote(Note note, List list, int n, int n2) {
        Note note2 = null;
        for (int i = n; i >= 0; --i) {
            Measure measure = (Measure)list.get(i);
            if (n2 < 0) {
                n2 = measure.getNotes().size();
            }
            for (int j = n2 - 1; j >= 0; --j) {
                Note note3 = (Note)measure.getNotes().get(j);
                if (note3.getString() != note.getString() || note3.getStart() >= note.getStart() || note2 != null && note3.getStart() <= note2.getStart()) continue;
                note2 = note3;
            }
            if (note2 != null) break;
            n2 = -1;
        }
        return note2;
    }

    private NoteData checkTripletFeel(Measure measure, Note note, int n) {
        NoteData noteData = new NoteData();
        noteData.start = note.getStart();
        noteData.duration = note.getDuration().getTime();
        if (measure.getTripletFeel() == 2) {
            if (note.getDuration().isEqual(new Duration(8, false, false, Duration.NO_TUPLETO))) {
                Note note2;
                int n2 = (int)(Math.round((double)note.getStart() / 10.0) * 10L % 1000L);
                if (n2 == 0) {
                    Note note3 = this.getNextNote(note, measure, n);
                    if (note3 != null && note3.getDuration().isEqual(new Duration(8, false, false, Duration.NO_TUPLETO))) {
                        noteData.duration = new Duration(8, false, false, new Tupleto(3, 2)).getTime() * 2L;
                    }
                } else if ((long)n2 == 500L && (note2 = this.getPrevNote(note, measure, n)) != null && note2.getDuration().isEqual(new Duration(8, false, false, Duration.NO_TUPLETO))) {
                    Duration duration = new Duration(8, false, false, new Tupleto(3, 2));
                    noteData.start = note2.getStart() + duration.getTime() * 2L;
                    noteData.duration = duration.getTime();
                }
            }
        } else if (measure.getTripletFeel() == 3 && note.getDuration().isEqual(new Duration(16, false, false, Duration.NO_TUPLETO))) {
            Note note4;
            int n3 = (int)(Math.round((double)note.getStart() / 10.0) * 10L % 500L);
            if (n3 == 0) {
                Note note5 = this.getNextNote(note, measure, n);
                if (note5 != null && note5.getDuration().isEqual(new Duration(16, false, false, Duration.NO_TUPLETO))) {
                    noteData.duration = new Duration(16, false, false, new Tupleto(3, 2)).getTime() * 2L;
                }
            } else if ((long)n3 == 250L && (note4 = this.getPrevNote(note, measure, n)) != null && note4.getDuration().isEqual(new Duration(16, false, false, Duration.NO_TUPLETO))) {
                Duration duration = new Duration(16, false, false, new Tupleto(3, 2));
                noteData.start = note4.getStart() + duration.getTime() * 2L;
                noteData.duration = duration.getTime();
            }
        }
        return noteData;
    }

    private Note getPrevNote(Note note, Measure measure, int n) {
        Note note2 = null;
        for (int i = n - 1; i >= 0; --i) {
            Note note3 = (Note)measure.getNotes().get(i);
            if (note3.getStart() >= note.getStart() || note2 != null && note3.getStart() <= note2.getStart()) continue;
            note2 = note3;
        }
        return note2;
    }

    private Note getNextNote(Note note, Measure measure, int n) {
        Note note2 = null;
        for (int i = n + 1; i < measure.getNotes().size(); ++i) {
            Note note3 = (Note)measure.getNotes().get(i);
            if (note3.getStart() <= note.getStart() || note2 != null && note3.getStart() >= note2.getStart()) continue;
            note2 = note3;
        }
        return note2;
    }

    private class NoteData {
        private long start;
        private long duration;

        private NoteData() {
        }
    }
}

