/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo.undoables.track;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.RGBColor;
import org.herac.tuxguitar.song.models.SongTrack;

public class UndoableInfoTrack
implements UndoableEdit {
    private int doAction;
    private UndoableCaretHelper undoCaret;
    private UndoableCaretHelper redoCaret;
    private long trackNumber;
    private String undoName;
    private String redoName;
    private RGBColor undoColor;
    private RGBColor redoColor;
    private int undoOffset;
    private int redoOffset;

    private UndoableInfoTrack() {
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        SongManager songManager = TuxGuitar.instance().getSongManager();
        songManager.getTrackManager().changeInfo(songManager.getTrack(this.trackNumber), this.redoName, (RGBColor)this.redoColor.clone(), this.redoOffset);
        TuxGuitar.instance().fireUpdate();
        TuxGuitar.instance().getMixer().update();
        this.redoCaret.update();
        this.doAction = 1;
    }

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        SongManager songManager = TuxGuitar.instance().getSongManager();
        songManager.getTrackManager().changeInfo(songManager.getTrack(this.trackNumber), this.undoName, (RGBColor)this.undoColor.clone(), this.undoOffset);
        TuxGuitar.instance().fireUpdate();
        TuxGuitar.instance().getMixer().update();
        this.undoCaret.update();
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static UndoableInfoTrack startUndo(SongTrack songTrack) {
        UndoableInfoTrack undoableInfoTrack = new UndoableInfoTrack();
        Caret caret = UndoableInfoTrack.getCaret();
        undoableInfoTrack.doAction = 1;
        undoableInfoTrack.trackNumber = songTrack.getNumber();
        undoableInfoTrack.undoCaret = new UndoableCaretHelper();
        undoableInfoTrack.undoName = songTrack.getName();
        undoableInfoTrack.undoColor = (RGBColor)songTrack.getColor().clone();
        undoableInfoTrack.undoOffset = songTrack.getOffset();
        return undoableInfoTrack;
    }

    public UndoableInfoTrack endUndo(SongTrack songTrack) {
        this.redoCaret = new UndoableCaretHelper();
        this.redoName = songTrack.getName();
        this.redoColor = (RGBColor)songTrack.getColor().clone();
        this.redoOffset = songTrack.getOffset();
        return this;
    }

    private static Caret getCaret() {
        return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }
}

