/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.transport;

import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.play.models.Player;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.SongTrack;

public class SongTransport {
    public static final int STATUS_STOPED = 1;
    public static final int STATUS_PAUSED = 2;
    public static final int STATUS_RUNNING = 3;
    private Shell dialog;
    private Label label;
    private Scale tickScale;
    private ToolItem first;
    private ToolItem last;
    private ToolItem previous;
    private ToolItem next;
    private ToolItem stop;
    private ToolItem play;
    private boolean editingTickScale;
    private int status;

    public void show() {
        Shell shell = TuxGuitar.instance().getTablatureEditor().getTablature().getShell();
        this.dialog = new Shell(shell, 2144);
        this.dialog.setLayout(new GridLayout());
        this.init();
        this.dialog.pack();
        this.dialog.open();
        int n = shell.getBounds().x + (shell.getBounds().width - this.dialog.getSize().x) / 2;
        int n2 = shell.getBounds().y + (shell.getBounds().height - this.dialog.getSize().y) / 2;
        this.dialog.setLocation(n, n2);
        TuxGuitar.instance().updateItems();
        while (!this.dialog.isDisposed()) {
            if (this.dialog.getDisplay().readAndDispatch()) continue;
            this.dialog.getDisplay().sleep();
        }
        TuxGuitar.instance().updateItems();
    }

    private void init() {
        Composite composite = new Composite(this.dialog, 2048);
        composite.setLayout(new GridLayout());
        composite.setLayoutData(new GridData(4, 4, true, true));
        this.initLabel(composite);
        this.initScale(composite);
        this.initButtons(composite);
        this.updateItems();
        this.redraw();
    }

    private void initLabel(Composite composite) {
        this.label = new Label(composite, 133120);
        this.label.setLayoutData(new GridData(4, 4, true, true));
        this.label.setBackground(composite.getDisplay().getSystemColor(2));
        this.label.setForeground(composite.getDisplay().getSystemColor(9));
        this.label.setFont(new Font(composite.getDisplay(), "Minisystem", 36, 0));
    }

    private void initScale(Composite composite) {
        this.tickScale = new Scale(composite, 256);
        this.tickScale.setLayoutData(new GridData(4, 4, true, true));
        this.tickScale.setIncrement(1000);
        this.tickScale.setPageIncrement(1000);
        this.tickScale.setSelection(1000);
        this.tickScale.addMouseListener(new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                SongTransport.this.setEditingTickScale(true);
            }

            public void mouseUp(MouseEvent mouseEvent) {
                long l = SongTransport.this.tickScale.getSelection();
                SongTrack songTrack = SongTransport.this.getSongManager().getFirstTrack();
                SongTransport.this.gotoMeasure(SongTransport.this.getSongManager().getTrackManager().getMeasureAt(songTrack, l), true);
                SongTransport.this.redraw();
                SongTransport.this.setEditingTickScale(false);
            }
        });
    }

    private void initButtons(Composite composite) {
        ToolBar toolBar = new ToolBar(this.dialog, 0);
        toolBar.setLayout(new GridLayout(4, false));
        toolBar.setLayoutData(new GridData(4, 4, true, true));
        this.first = new ToolItem(toolBar, 8);
        this.first.setImage(SystemImages.TRANSPORT_FIRST_1);
        this.first.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SongTransport.this.gotoFirst(selectionEvent);
            }
        });
        this.previous = new ToolItem(toolBar, 8);
        this.previous.setImage(SystemImages.TRANSPORT_PREVIOUS_1);
        this.previous.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SongTransport.this.gotoPrevious(selectionEvent);
            }
        });
        this.stop = new ToolItem(toolBar, 8);
        this.stop.setImage(SystemImages.TRANSPORT_STOP_1);
        this.stop.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SongTransport.this.stop(selectionEvent);
            }
        });
        this.play = new ToolItem(toolBar, 8);
        this.play.setImage(SystemImages.TRANSPORT_PLAY_1);
        this.play.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SongTransport.this.play(selectionEvent);
            }
        });
        this.next = new ToolItem(toolBar, 8);
        this.next.setImage(SystemImages.TRANSPORT_NEXT_1);
        this.next.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SongTransport.this.gotoNext(selectionEvent);
            }
        });
        this.last = new ToolItem(toolBar, 8);
        this.last.setImage(SystemImages.TRANSPORT_LAST_1);
        this.last.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SongTransport.this.gotoLast(selectionEvent);
            }
        });
        this.setStatus(1);
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public void redraw() {
        if (!this.isDisposed()) {
            if (this.isEditingTickScale()) {
                this.label.setText(Long.toString(this.tickScale.getSelection()));
            } else {
                long l = this.getSongManager().getPlayer().getTickPosition();
                this.label.setText(Long.toString(l));
                this.tickScale.setSelection((int)l);
            }
        }
    }

    public void updateItems() {
        if (!this.isDisposed()) {
            int n = this.getStatus();
            if (this.getSongManager().getPlayer().isRunning()) {
                this.setStatus(3);
            } else if (this.getSongManager().getPlayer().isPaused()) {
                this.setStatus(2);
            } else {
                this.setStatus(1);
            }
            if (n != this.getStatus()) {
                if (this.getStatus() == 3) {
                    this.first.setImage(SystemImages.TRANSPORT_FIRST_2);
                    this.last.setImage(SystemImages.TRANSPORT_LAST_2);
                    this.previous.setImage(SystemImages.TRANSPORT_PREVIOUS_2);
                    this.next.setImage(SystemImages.TRANSPORT_NEXT_2);
                    this.stop.setImage(SystemImages.TRANSPORT_STOP_2);
                    this.play.setImage(SystemImages.TRANSPORT_PAUSE);
                } else if (this.getStatus() == 2) {
                    this.first.setImage(SystemImages.TRANSPORT_FIRST_2);
                    this.last.setImage(SystemImages.TRANSPORT_LAST_2);
                    this.previous.setImage(SystemImages.TRANSPORT_PREVIOUS_2);
                    this.next.setImage(SystemImages.TRANSPORT_NEXT_2);
                    this.stop.setImage(SystemImages.TRANSPORT_STOP_2);
                    this.play.setImage(SystemImages.TRANSPORT_PLAY_2);
                } else if (this.getStatus() == 1) {
                    this.first.setImage(SystemImages.TRANSPORT_FIRST_1);
                    this.last.setImage(SystemImages.TRANSPORT_LAST_1);
                    this.previous.setImage(SystemImages.TRANSPORT_PREVIOUS_1);
                    this.next.setImage(SystemImages.TRANSPORT_NEXT_1);
                    this.stop.setImage(SystemImages.TRANSPORT_STOP_1);
                    this.play.setImage(SystemImages.TRANSPORT_PLAY_1);
                }
            }
            Measure measure = this.getSongManager().getTrackManager().getFirstMeasure(this.getSongManager().getFirstTrack());
            Measure measure2 = this.getSongManager().getTrackManager().getLastMeasure(this.getSongManager().getFirstTrack());
            this.tickScale.setMinimum((int)measure.getStart());
            this.tickScale.setMaximum((int)(measure2.getStart() + measure2.getLength()));
            this.redraw();
        }
    }

    public void loadProperties() {
        if (!this.isDisposed()) {
            // empty if block
        }
    }

    public void dispose() {
        this.dialog.dispose();
    }

    public boolean isDisposed() {
        return this.dialog == null || this.dialog.isDisposed();
    }

    public boolean isEditingTickScale() {
        return this.editingTickScale;
    }

    public void setEditingTickScale(boolean bl) {
        this.editingTickScale = bl;
    }

    private SongManager getSongManager() {
        return TuxGuitar.instance().getSongManager();
    }

    public void gotoFirst(TypedEvent typedEvent) {
        this.gotoMeasure(this.getSongManager().getTrackManager().getFirstMeasure(this.getSongManager().getFirstTrack()), true);
    }

    public void gotoLast(TypedEvent typedEvent) {
        this.gotoMeasure(this.getSongManager().getTrackManager().getLastMeasure(this.getSongManager().getFirstTrack()), true);
    }

    public void gotoNext(TypedEvent typedEvent) {
        Player player = this.getSongManager().getPlayer();
        SongTrack songTrack = this.getSongManager().getFirstTrack();
        Measure measure = this.getSongManager().getTrackManager().getMeasureAt(songTrack, player.getTickPosition());
        if (measure != null) {
            this.gotoMeasure(this.getSongManager().getTrackManager().getNextMeasure(songTrack, measure), true);
        }
    }

    public void gotoPrevious(TypedEvent typedEvent) {
        Player player = this.getSongManager().getPlayer();
        SongTrack songTrack = this.getSongManager().getFirstTrack();
        Measure measure = this.getSongManager().getTrackManager().getMeasureAt(songTrack, player.getTickPosition());
        if (measure != null) {
            this.gotoMeasure(this.getSongManager().getTrackManager().getPrevMeasure(songTrack, measure), true);
        }
    }

    public void gotoMeasure(Measure measure) {
        this.gotoMeasure(measure, false);
    }

    private void gotoMeasure(Measure measure, boolean bl) {
        if (measure != null && !this.getSongManager().isAtPosition(measure.getHeader(), this.getSongManager().getPlayer().getTickPosition())) {
            this.getSongManager().getPlayer().setTickPosition(measure.getStartWidthRepetitions(), measure.getStartWidthRepetitions() - measure.getStart());
            if (bl) {
                TuxGuitar.instance().getTablatureEditor().getTablature().getCaret().goToTickPosition();
                TuxGuitar.instance().redraw();
            }
            this.redraw();
        }
    }

    public void play(TypedEvent typedEvent) {
        TuxGuitar.instance().getAction("PLAY_SONG").process(typedEvent);
    }

    public void stop(TypedEvent typedEvent) {
        TuxGuitar.instance().getAction("STOP_SONG").process(typedEvent);
    }
}

