/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tab.layout;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.printer.PrintDocument;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.tab.Tablature;
import org.herac.tuxguitar.gui.tab.layout.ViewLayout;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Note;

public class PrinterViewLayout
extends ViewLayout {
    protected static final int BOTTON_SPAN = 100;
    protected static final int DEFAULT_LINEAR_SPAN = 120;
    protected static final int DEFAULT_STRING_SPAN = 10;
    protected static final int DEFAULT_TRACK_SPAN = 100;
    private PrintDocument document;
    private Image page;
    private int divisionCount;

    public PrinterViewLayout(Tablature tablature, SongManager songManager, boolean bl, boolean bl2) {
        super(tablature, songManager, bl, bl2);
    }

    public PrintDocument makeDocument() {
        return this.makeDocument(new Rectangle(0, 0, 455, 650));
    }

    public PrintDocument makeDocument(Rectangle rectangle) {
        this.document = new PrintDocument();
        this.document.setPageSize(rectangle);
        this.page = new Image((Device)this.getTablature().getDisplay(), this.document.getPageSize());
        GC gC = new GC(this.page);
        this.paintHeader(gC);
        this.paintSong(gC, 0, this.getStartPosY());
        gC.dispose();
        return this.document;
    }

    private void makePage(GC gC) {
        String string = Integer.toString(this.document.count() + 1);
        this.setDefaultStyle(gC);
        gC.drawString(string, this.getRight(gC, string), this.document.getPageSize().height - 70);
        this.document.makePage(this.page.getImageData());
        gC.fillRectangle(this.document.getPageSize());
    }

    public void paintHeader(GC gC) {
        String string = this.getSongManager().getSong().getName();
        String string2 = this.getSongManager().getSong().getAuthor();
        String string3 = "(" + this.getTablature().getCaret().getSongTrackCoords().getTrack().getName() + ")";
        if (string == null || string.length() == 0) {
            string = TuxGuitar.getProperty("print-header.default-song-name");
        }
        if (string2 == null || string2.length() == 0) {
            string2 = TuxGuitar.getProperty("print-header.default-song-author");
        }
        Font font = new Font(this.getTablature().getDisplay(), "Sans", 16, 0x1000001);
        Font font2 = new Font(this.getTablature().getDisplay(), "Sans", 8, 0x1000001);
        Font font3 = new Font(this.getTablature().getDisplay(), "Sans", 8, 0x1000001);
        gC.setFont(font);
        gC.drawString(string, this.getCenter(gC, string), 0);
        gC.setFont(font2);
        gC.drawString(string3, this.getCenter(gC, string3), 30);
        gC.setFont(font3);
        gC.drawString(string2, this.getRight(gC, string2), 50);
        font.dispose();
        font2.dispose();
        font3.dispose();
        this.setDefaultStyle(gC);
    }

    private int getCenter(GC gC, String string) {
        int n = gC.stringExtent((String)string).x;
        return (this.getMaxWidth() - n) / 2;
    }

    private int getRight(GC gC, String string) {
        int n = gC.stringExtent((String)string).x;
        return this.getMaxWidth() - n;
    }

    public void paintSong(GC gC, Rectangle rectangle, int n, int n2) {
    }

    public void paintSong(GC gC, int n, int n2) {
        ArrayList<SongTrackCoords> arrayList = new ArrayList<SongTrackCoords>();
        arrayList.add(this.getTablature().getCaret().getSongTrackCoords());
        this.paintTracks(arrayList, gC, null, n, n2);
    }

    public void paintTracks(List list, GC gC, Rectangle rectangle, int n, int n2) {
        int n3 = n2 + this.getDefaultFirstTrackSpan();
        for (int i = 0; i < list.size(); ++i) {
            SongTrackCoords songTrackCoords = (SongTrackCoords)list.get(i);
            rectangle = new Rectangle(n, n3, songTrackCoords.getWidth(), 100);
            songTrackCoords.paintTrack(this, gC, n, n3, rectangle);
            n3 += 100;
        }
    }

    public void paintMeasures(SongTrackCoords songTrackCoords, List list, GC gC, int n, int n2, Rectangle rectangle) {
        songTrackCoords.setPosY(n2);
        int n3 = 0;
        int n4 = songTrackCoords.getPosY();
        int n5 = 0;
        int n6 = 0;
        this.divisionCount = 1;
        int n7 = 0;
        ArrayList<MeasureCoords> arrayList = new ArrayList<MeasureCoords>();
        for (int i = 0; i < list.size(); ++i) {
            MeasureCoords measureCoords = (MeasureCoords)list.get(i);
            measureCoords.calculateWidth();
            if (n7 + measureCoords.getWidth() >= this.getMaxWidth() && !arrayList.isEmpty()) {
                int n8 = 0;
                int n9 = this.getMaxWidth() - n7;
                if (n9 != 0 && arrayList.size() > 0) {
                    n8 = n9 / arrayList.size();
                }
                for (MeasureCoords measureCoords2 : arrayList) {
                    measureCoords2.setPosX(n3);
                    measureCoords2.setPosY(n4);
                    rectangle = new Rectangle(n3 + n, n4, measureCoords2.getWidth(), measureCoords2.getTabHeight());
                    this.paintMeasure(measureCoords2, gC, n3 + n, n4, n8, rectangle);
                    if ((n3 += measureCoords2.getWidth() + measureCoords2.getSpan()) <= n5) continue;
                    n5 = n3;
                }
                this.paintStrings(songTrackCoords, gC, n4, n3);
                n3 = 0;
                n6 += this.getLinearSpan();
                n7 = 0;
                arrayList.clear();
                ++this.divisionCount;
                if ((n4 += this.getLinearSpan()) + this.getTrackHeight(songTrackCoords) + 100 > this.getMaxHeight()) {
                    this.makePage(gC);
                    n4 = this.getStartPosY();
                }
            }
            n7 += measureCoords.getWidth();
            arrayList.add(measureCoords);
        }
        for (MeasureCoords measureCoords : arrayList) {
            measureCoords.setPosX(n3);
            measureCoords.setPosY(n4);
            rectangle = new Rectangle(n3 + n, n4, measureCoords.getWidth(), measureCoords.getTabHeight());
            this.paintMeasure(measureCoords, gC, n3 + n, n4, 0, rectangle);
            if ((n3 += measureCoords.getWidth() + measureCoords.getSpan()) <= n5) continue;
            n5 = n3;
        }
        this.paintStrings(songTrackCoords, gC, n4, n3);
        this.makePage(gC);
        this.setWidth(n5);
        this.setHeight((n6 += this.getLinearSpan()) + 100 + 100);
    }

    public void paintStrings(SongTrackCoords songTrackCoords, GC gC, int n, int n2) {
        int n3 = 0;
        for (InstrumentString instrumentString : songTrackCoords.getTrack().getStrings()) {
            int n4 = instrumentString.getNumber() * this.getStringSpan();
            gC.drawLine(n3, n + n4, n3 + n2, n + n4);
        }
    }

    public int getSpanForQuarter(Duration duration) {
        double d = 1000.0 / (double)duration.getTime() * (double)this.getMinSpan(duration);
        return (int)d;
    }

    private int getMinSpan(Duration duration) {
        int n = 0;
        switch (duration.getValue()) {
            case 1: {
                n = 18;
                break;
            }
            case 2: {
                n = 16;
                break;
            }
            case 4: {
                n = 14;
                break;
            }
            case 8: {
                n = 12;
                break;
            }
            default: {
                n = 12;
            }
        }
        return n;
    }

    public SongTrackCoords getTrackAt(List arrayList, int n, int n2) {
        if (!this.isMultitrack()) {
            arrayList = new ArrayList<SongTrackCoords>();
            arrayList.add(this.getTablature().getCaret().getSongTrackCoords());
        }
        SongTrackCoords songTrackCoords = null;
        int n3 = this.getLinearSpan();
        for (int i = 0; i < arrayList.size(); ++i) {
            SongTrackCoords songTrackCoords2 = (SongTrackCoords)arrayList.get(i);
            int n4 = songTrackCoords2.getHeight();
            for (int j = 0; j < this.divisionCount; ++j) {
                int n5 = songTrackCoords2.getPosY() + j * n3;
                if (n >= n5 - 50 && n <= n5 + n4 + 50) {
                    songTrackCoords = songTrackCoords2;
                }
                n5 += n3;
            }
        }
        return songTrackCoords;
    }

    public void followMeasure(MeasureCoords measureCoords, boolean bl) {
    }

    public boolean isCaretVisible() {
        return false;
    }

    public boolean isPlayModeEnabled() {
        return false;
    }

    public void setDefaultStyle(GC gC) {
        gC.setFont(this.getTablature().getPrinterDefaultFont());
    }

    public void setNoteStyle(GC gC) {
        gC.setFont(this.getTablature().getPrinterNoteFont());
    }

    public void setTimeSignatureStyle(GC gC) {
        gC.setFont(this.getTablature().getPrinterTimeSignatureFont());
    }

    public Point getNoteOrientation(GC gC, int n, int n2, Note note) {
        Point point = new Point(n, n2);
        point.y -= 5;
        point.x -= 2;
        if (!note.getEffect().isDeadNote() && note.getValue() > 9) {
            point.x -= 3;
        }
        return point;
    }

    private int getTrackHeight(SongTrackCoords songTrackCoords) {
        return songTrackCoords.getTrack().getStrings().size() * 10 + 20;
    }

    private int getLinearSpan() {
        int n = 120;
        if (this.isMultiTrack()) {
            n *= this.getTrackCount();
        }
        return n;
    }

    public int getStartPosY() {
        return this.getDefaultFirstTrackSpan();
    }

    public int getMaxWidth() {
        return this.document.getPageSize().width - 10;
    }

    public int getMaxHeight() {
        return this.document.getPageSize().height;
    }

    public int getStringSpan() {
        return 10;
    }
}

