/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.printer;

import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.printer.PrintDocument;
import org.herac.tuxguitar.gui.printer.PrintPage;

public class PrintPreview {
    private Shell dialog;
    private PrintDocument document;
    private PrintPage currentPage;
    private Composite previewComposite;
    private Composite pageComposite;
    private Text currentText;
    private Button previous;
    private Button next;

    public PrintPreview(PrintDocument printDocument) {
        this.document = printDocument;
    }

    public void showPreview(Shell shell) {
        this.dialog = new Shell(shell, 67680);
        this.dialog.setLayout(new GridLayout());
        this.dialog.setText(TuxGuitar.getProperty("print.preview"));
        this.initToolBar();
        this.initPreviewComposite();
        this.changePage(1);
        this.dialog.setMaximized(true);
        this.dialog.open();
        int n = shell.getBounds().x + (shell.getBounds().width - this.dialog.getSize().x) / 2;
        int n2 = shell.getBounds().y + (shell.getBounds().height - this.dialog.getSize().y) / 2;
        this.dialog.setLocation(n, n2);
        while (!this.dialog.isDisposed()) {
            if (this.dialog.getDisplay().readAndDispatch()) continue;
            this.dialog.getDisplay().sleep();
        }
    }

    private void initToolBar() {
        Composite composite = new Composite(this.dialog, 0);
        composite.setLayout(new GridLayout(5, false));
        composite.setLayoutData(new GridData(4, 4, true, false));
        this.previous = new Button(composite, 16388);
        this.currentText = new Text(composite, 2048);
        this.currentText.setLayoutData(new GridData(20, 10));
        this.next = new Button(composite, 131076);
        Label label = new Label(composite, 0);
        GridData gridData = new GridData(131072, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        Button button = new Button(composite, 8);
        button.setLayoutData(gridData);
        this.currentText.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 13) {
                    try {
                        Integer n = new Integer(PrintPreview.this.currentText.getText());
                        PrintPreview.this.changePage(n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        PrintPreview.this.changePage(PrintPreview.this.currentPage.getPageNumber() + 1);
                    }
                }
            }
        });
        this.previous.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (PrintPreview.this.currentPage != null) {
                    PrintPreview.this.changePage(PrintPreview.this.currentPage.getPageNumber());
                }
            }
        });
        this.next.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (PrintPreview.this.currentPage != null) {
                    PrintPreview.this.changePage(PrintPreview.this.currentPage.getPageNumber() + 2);
                }
            }
        });
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PrintPreview.this.dialog.dispose();
            }
        });
        label.setText("To " + this.document.getPages().size());
        button.setText(TuxGuitar.getProperty("exit"));
    }

    private void initPreviewComposite() {
        this.previewComposite = new Composite(this.dialog, 2560);
        this.previewComposite.setLayout(new GridLayout());
        this.previewComposite.setLayoutData(new GridData(4, 4, true, true));
        this.previewComposite.setBackground(this.previewComposite.getDisplay().getSystemColor(15));
        this.pageComposite = new Composite(this.previewComposite, 0x20000800);
        this.pageComposite.setLayout(new GridLayout());
        this.pageComposite.setBackground(this.previewComposite.getDisplay().getSystemColor(1));
        this.pageComposite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                if (PrintPreview.this.currentPage != null) {
                    int n = PrintPreview.this.previewComposite.getVerticalBar().getSelection();
                    Image image = new Image((Device)PrintPreview.this.dialog.getDisplay(), PrintPreview.this.currentPage.getData());
                    paintEvent.gc.drawImage(image, 50, 20 - n);
                    PrintPreview.this.updateScroll();
                    image.dispose();
                }
            }
        });
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 0x1000000;
        gridData.verticalAlignment = 0x1000000;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.widthHint = this.document.getPageSize().width + 70;
        gridData.heightHint = this.document.getPageSize().height;
        this.pageComposite.setLayoutData(gridData);
        this.previewComposite.getVerticalBar().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PrintPreview.this.pageComposite.redraw();
            }
        });
    }

    private void updateScroll() {
        ScrollBar scrollBar = this.previewComposite.getVerticalBar();
        Rectangle rectangle = this.pageComposite.getBounds();
        Rectangle rectangle2 = this.pageComposite.getClientArea();
        scrollBar.setMaximum(this.document.getPageSize().height);
        scrollBar.setThumb(Math.min(this.document.getPageSize().height, rectangle2.height));
    }

    private void changePage(int n) {
        if (this.document != null) {
            int n2 = this.document.getPages().size();
            if (n > 0 && n <= n2) {
                this.currentPage = (PrintPage)this.document.getPages().get(n - 1);
                this.currentText.setText(Integer.toString(n));
                this.pageComposite.redraw();
            } else if (this.currentPage != null) {
                this.currentText.setText(Integer.toString(this.currentPage.getPageNumber() + 1));
            }
            this.previous.setEnabled(this.currentPage.getPageNumber() > 0);
            this.next.setEnabled(this.currentPage.getPageNumber() + 1 < n2);
        } else {
            this.currentText.setEnabled(false);
            this.previous.setEnabled(false);
            this.next.setEnabled(false);
        }
    }
}

