/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.plugins;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

class JarClassLoader
extends ClassLoader {
    private Map loadedClasses = new HashMap();

    public JarClassLoader(JarFile jarFile) {
        this.loadJarFile(jarFile);
    }

    public void loadJarFile(JarFile jarFile) {
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            if (!jarEntry.getName().endsWith(".class")) continue;
            this.defineClass(jarFile, jarEntry);
        }
    }

    public Class defineClass(JarFile jarFile, JarEntry jarEntry) {
        Class<?> clazz = null;
        try {
            InputStream inputStream = jarFile.getInputStream(jarEntry);
            int n = inputStream.available();
            byte[] byArray = new byte[n];
            inputStream.read(byArray);
            clazz = this.defineClass(null, byArray, 0, byArray.length);
            this.loadedClasses.put(clazz.getName(), clazz);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Error error) {
            System.out.println(jarEntry.getName());
        }
        return clazz;
    }

    public Class loadClass(String string) {
        try {
            Class<?> clazz = new ClassLoader(){

                public Class findClass(String string) {
                    return (Class)JarClassLoader.this.loadedClasses.get(string);
                }
            }.loadClass(string);
            return clazz;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

