/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.mixer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.mixer.SongVolume;
import org.herac.tuxguitar.gui.mixer.TrackMixer;
import org.herac.tuxguitar.song.models.SongChannel;
import org.herac.tuxguitar.song.models.SongTrack;

public class SongMixer {
    private Shell dialog;
    private SongVolume songVolume;
    private List trackMixers = new ArrayList();

    public static void main(String[] stringArray) {
        new SongMixer();
    }

    public void show() {
        Shell shell = TuxGuitar.instance().getTablatureEditor().getTablature().getShell();
        this.dialog = new Shell(shell, 2144);
        this.loadData();
        this.dialog.open();
        int n = shell.getBounds().x + (shell.getBounds().width - this.dialog.getSize().x) / 2;
        int n2 = shell.getBounds().y + (shell.getBounds().height - this.dialog.getSize().y) / 2;
        this.dialog.setLocation(n, n2);
        TuxGuitar.instance().updateItems();
        while (!this.dialog.isDisposed()) {
            if (this.dialog.getDisplay().readAndDispatch()) continue;
            this.dialog.getDisplay().sleep();
        }
        TuxGuitar.instance().updateItems();
    }

    public void update() {
        if (!this.isDisposed()) {
            this.clear();
            this.loadData();
            this.dialog.layout();
        }
    }

    private void loadData() {
        this.trackMixers.clear();
        List list = TuxGuitar.instance().getTablatureEditor().getSongManager().getSong().getTracks();
        for (SongTrack songTrack : list) {
            TrackMixer trackMixer = new TrackMixer(this, songTrack);
            trackMixer.init(this.dialog);
            this.trackMixers.add(trackMixer);
        }
        this.songVolume = new SongVolume(TuxGuitar.instance().getSongManager());
        this.songVolume.init(this.dialog);
        this.loadProperties();
        this.dialog.setLayout(new GridLayout(this.dialog.getChildren().length, true));
        this.dialog.pack();
    }

    private void clear() {
        Control[] controlArray = this.dialog.getChildren();
        for (int i = 0; i < controlArray.length; ++i) {
            controlArray[i].dispose();
        }
    }

    public void dispose() {
        this.dialog.dispose();
    }

    public boolean isDisposed() {
        return this.dialog == null || this.dialog.isDisposed();
    }

    public void fireChanges(SongChannel songChannel) {
        for (TrackMixer trackMixer : this.trackMixers) {
            if (trackMixer.getTrack().getChannel().getChannel() == songChannel.getChannel()) {
                trackMixer.getTrack().getChannel().setVolume(songChannel.getVolume());
                trackMixer.getTrack().getChannel().setBalance(songChannel.getBalance());
                trackMixer.getTrack().getChannel().setChorus(songChannel.getChorus());
                trackMixer.getTrack().getChannel().setReverb(songChannel.getReverb());
                trackMixer.getTrack().getChannel().setPhaser(songChannel.getPhaser());
                trackMixer.getTrack().getChannel().setTremolo(songChannel.getTremolo());
                trackMixer.getTrack().getChannel().setSolo(songChannel.isSolo());
                trackMixer.getTrack().getChannel().setMute(songChannel.isMute());
                trackMixer.fireChanges();
                continue;
            }
            if (!songChannel.isSolo()) continue;
            trackMixer.getTrack().getChannel().setSolo(false);
            trackMixer.fireChanges();
        }
        if (TuxGuitar.instance().getTablatureEditor().getSongManager().getPlayer().isRunning()) {
            TuxGuitar.instance().getTablatureEditor().getSongManager().getPlayer().updateChannels();
        }
    }

    public void loadProperties() {
        if (!this.isDisposed()) {
            for (TrackMixer trackMixer : this.trackMixers) {
                trackMixer.loadProperties();
            }
            this.songVolume.loadProperties();
            this.dialog.layout();
        }
    }
}

