/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.marker;

import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.marker.MarkerEditor;
import org.herac.tuxguitar.gui.marker.MarkerNavigator;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.undo.undoables.custom.UndoableChangeMarker;
import org.herac.tuxguitar.song.models.Marker;

public class MarkerList {
    private Shell dialog;
    private Table table;
    private List markers;

    public void show(Shell shell) {
        this.dialog = new Shell(shell, 67680);
        this.dialog.setLayout(new GridLayout(2, false));
        this.dialog.setText(TuxGuitar.getProperty("marker.list"));
        this.dialog.setLayoutData(new GridData(4, 4, true, true));
        Composite composite = new Composite(this.dialog, 0);
        composite.setLayout(new GridLayout());
        composite.setLayoutData(new GridData(4, 4, true, true));
        this.table = new Table(composite, 2048);
        this.table.setLayoutData(new GridData(250, 200));
        TableColumn tableColumn = new TableColumn(this.table, 16384);
        TableColumn tableColumn2 = new TableColumn(this.table, 16384);
        tableColumn.setText(TuxGuitar.getProperty("measure"));
        tableColumn.setWidth(70);
        tableColumn2.setText(TuxGuitar.getProperty("title"));
        tableColumn2.setWidth(180);
        this.table.setHeaderVisible(true);
        this.loadTableItems();
        Composite composite2 = new Composite(this.dialog, 0);
        composite2.setLayout(new GridLayout(1, false));
        composite2.setLayoutData(new GridData(4, 4, true, true));
        Button button = new Button(composite2, 8);
        button.setText(TuxGuitar.getProperty("add"));
        button.setLayoutData(this.makeGridData(4, 128, false, 80, 25));
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Caret caret = TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
                Marker marker = new Marker(caret.getMeasureCoords().getMeasure().getNumber());
                new MarkerEditor(marker, 1).show(MarkerList.this.dialog);
                MarkerList.this.loadTableItems();
            }
        });
        Button button2 = new Button(composite2, 8);
        button2.setText(TuxGuitar.getProperty("edit"));
        button2.setLayoutData(this.makeGridData(4, 128, false, 80, 25));
        button2.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Marker marker = MarkerList.this.getSelectedMarker();
                if (marker != null) {
                    new MarkerEditor(marker, 2).show(MarkerList.this.dialog);
                    MarkerList.this.loadTableItems();
                }
            }
        });
        Button button3 = new Button(composite2, 8);
        button3.setText(TuxGuitar.getProperty("remove"));
        button3.setLayoutData(this.makeGridData(4, 128, false, 80, 25));
        button3.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Marker marker = MarkerList.this.getSelectedMarker();
                UndoableChangeMarker undoableChangeMarker = UndoableChangeMarker.startUndo(marker);
                TuxGuitar.instance().getSongManager().removeMarker(marker);
                MarkerList.this.loadTableItems();
                TuxGuitar.instance().getTablatureEditor().getUndoManager().addEdit(undoableChangeMarker.endUndo(null));
            }
        });
        Button button4 = new Button(composite2, 8);
        button4.setText(TuxGuitar.getProperty("go"));
        button4.setLayoutData(this.makeGridData(4, 1024, true, 80, 25));
        button4.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                new MarkerNavigator().goToSelectedMarker(MarkerList.this.getSelectedMarker());
            }
        });
        Button button5 = new Button(composite2, 8);
        button5.setText(TuxGuitar.getProperty("exit"));
        button5.setLayoutData(this.makeGridData(4, 1024, false, 80, 25));
        button5.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MarkerList.this.dialog.dispose();
            }
        });
        this.dialog.pack();
        this.dialog.open();
        int n = shell.getBounds().x + (shell.getBounds().width - this.dialog.getSize().x) / 2;
        int n2 = shell.getBounds().y + (shell.getBounds().height - this.dialog.getSize().y) / 2;
        this.dialog.setLocation(n, n2);
        while (!this.dialog.isDisposed()) {
            if (this.dialog.getDisplay().readAndDispatch()) continue;
            this.dialog.getDisplay().sleep();
        }
    }

    private GridData makeGridData(int n, int n2, boolean bl, int n3, int n4) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = n;
        gridData.verticalAlignment = n2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = bl;
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }

    private void clearTableItems() {
        TableItem[] tableItemArray = this.table.getItems();
        for (int i = 0; i < tableItemArray.length; ++i) {
            tableItemArray[i].dispose();
        }
    }

    private void loadTableItems() {
        int n = this.table.getSelectionIndex();
        this.clearTableItems();
        this.markers = TuxGuitar.instance().getSongManager().getMarkers();
        for (Marker marker : this.markers) {
            TableItem tableItem = new TableItem(this.table, 0);
            tableItem.setText(new String[]{Integer.toString(marker.getMeasure()), marker.getTitle()});
        }
        if (n >= 0 && n < this.markers.size()) {
            this.table.select(n);
        }
    }

    private Marker getSelectedMarker() {
        int n = this.table.getSelectionIndex();
        if (n >= 0 && n < this.markers.size()) {
            return (Marker)this.markers.get(n);
        }
        return null;
    }
}

