/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.keybindings.xml;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.keybindings.KeyBinding;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class KeyBindingReader {
    private static final String SHORTCUT_TAG = "shortcut";
    private static final String ACTION_ATTRIBUTE = "action";
    private static final String KEYS_ATTRIBUTE = "keys";

    public static Map getKeyBindings(String string) {
        Map map = null;
        File file = new File(string);
        if (file.exists()) {
            Document document = KeyBindingReader.getDocument(file);
            map = KeyBindingReader.getBindings(document.getFirstChild());
        }
        return map;
    }

    private static Document getDocument(File file) {
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(file);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return document;
    }

    private static Map getBindings(Node node) {
        HashMap<KeyBinding, Action> hashMap = new HashMap<KeyBinding, Action>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (!string.equals(SHORTCUT_TAG)) continue;
            NamedNodeMap namedNodeMap = node2.getAttributes();
            String string2 = namedNodeMap.getNamedItem(KEYS_ATTRIBUTE).getNodeValue();
            String string3 = namedNodeMap.getNamedItem(ACTION_ATTRIBUTE).getNodeValue();
            if (string2 == null || string3 == null || string2.trim().equals("") || string3.trim().equals("")) {
                throw new RuntimeException("Invalid KeyBinding file format.");
            }
            hashMap.put(KeyBinding.parse(string2), TuxGuitar.instance().getAction(string3));
        }
        return hashMap;
    }
}

