/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.config;

import java.io.InputStream;
import java.util.Properties;
import org.herac.tuxguitar.gui.util.TuxGuitarFileUtils;

public class Defaults {
    private Properties properties = new Properties();

    public Defaults() {
        this.loadDefaults();
        this.loadDefaultFile();
    }

    public void loadDefaultFile() {
        try {
            InputStream inputStream = TuxGuitarFileUtils.getResourceAsStream("defaults.properties");
            if (inputStream != null) {
                this.properties.load(inputStream);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void loadDefaults() {
        this.properties.setProperty("MAXIMIZED", "false");
        this.properties.setProperty("WIDTH", "800");
        this.properties.setProperty("HEIGHT", "600");
        this.properties.setProperty("SHOW_MIXER", "false");
        this.properties.setProperty("SHOW_FRETBOARD", "false");
        this.properties.setProperty("LAYOUT_MODE", "2");
        this.properties.setProperty("SHOW_MULTITRACK", "true");
        this.properties.setProperty("SHOW_SCORE", "true");
        this.properties.setProperty("FONT_DEFAULT", "Sans,9,0");
        this.properties.setProperty("FONT_NOTE", "Sans,9,0");
        this.properties.setProperty("FONT_TIME_SIGNATURE", "Sans,14,1");
        this.properties.setProperty("FONT_PRINTER_DEFAULT", "Sans,7,0");
        this.properties.setProperty("FONT_PRINTER_NOTE", "Sans,7,0");
        this.properties.setProperty("FONT_PRINTER_TIME_SIGNATURE", "Sans,12,1");
        this.properties.setProperty("COLOR_SCORE_NOTE", "0,0,0");
        this.properties.setProperty("COLOR_TAB_NOTE", "0,0,0");
        this.properties.setProperty("COLOR_PLAY_NOTE", "255,0,0");
        this.properties.setProperty("MAX_HISTORY_FILES", "10");
        this.properties.setProperty("AUTO_SPACING_ENABLE", "false");
        this.properties.setProperty("MIN_SCORE_TABLATURE_SPAN", "80");
        this.properties.setProperty("SCORE_LINE_SPAN", "10");
        this.properties.setProperty("TAB_LINE_SPAN", "12");
        this.properties.setProperty("FIRST_TRACK_SPAN", "50");
        this.properties.setProperty("TRACK_SPAN", "150");
    }

    public Properties getProperties() {
        return this.properties;
    }
}

