/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.file;

import java.io.File;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.util.ConfirmDialog;
import org.herac.tuxguitar.gui.util.FileChooser;

public class SaveAsFileAction
extends Action {
    public static final String NAME = "SAVE_AS_FILE";

    public SaveAsFileAction(TablatureEditor tablatureEditor) {
        super(NAME, true, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        Shell shell = this.getEditor().getTablature().getShell();
        Object var3_3 = null;
        String[] stringArray = new String[]{"*.gp4", "*.gp3", "*.tg"};
        String string = FileChooser.instance().save(shell, FileChooser.SAVE_FORMAT, TuxGuitar.instance().getFileHistory().getFileName());
        if (string != null) {
            ConfirmDialog confirmDialog;
            String string2;
            File file;
            boolean bl = true;
            if (!this.isSuportedFormat(string)) {
                string = string + this.getDefaultExtension();
            }
            if ((file = new File(string2 = string)).exists() && !(confirmDialog = new ConfirmDialog(this.getEditor().getTablature().getShell(), TuxGuitar.getProperty("replace-file-question"))).confirm()) {
                bl = false;
            }
            if (bl) {
                this.getEditor().getTablature().changeCursor(1);
                new Thread(new Runnable(){

                    public void run() {
                        SaveAsFileAction.this.getEditor().getSongManager().save(string2);
                        new SyncThread(new Runnable(){

                            public void run() {
                                if (!TuxGuitar.isDisposed()) {
                                    TuxGuitar.instance().getFileHistory().setFile(string2);
                                    TuxGuitar.instance().updateItems();
                                    SaveAsFileAction.this.getEditor().getTablature().changeCursor(0);
                                }
                            }
                        }).start();
                    }
                }).start();
            }
        }
        return true;
    }

    private String getDefaultFileName(String string) {
        String string2 = "untitled";
        String string3 = this.getDefaultExtension();
        if (string == null) {
            string = string2 + string3;
        } else if (!this.isSuportedFormat(string)) {
            string = this.chengeFormat(string, string3);
        }
        return string;
    }

    private boolean isSuportedFormat(String string) {
        return string.endsWith(".tg") || string.endsWith(".gp3") || string.endsWith(".gp4");
    }

    private String chengeFormat(String string, String string2) {
        return this.removeExtension(string) + string2;
    }

    private String removeExtension(String string) {
        int n = string.lastIndexOf(46);
        return string.substring(0, n);
    }

    private String getDefaultExtension() {
        return ".gp4";
    }
}

