/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.file;

import java.io.File;
import java.io.FileNotFoundException;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.util.ConfirmDialog;
import org.herac.tuxguitar.gui.util.FileChooser;
import org.herac.tuxguitar.io.exporter.ASCIITabOutputStream;

public class ExportASCIIAction
extends Action {
    public static final String NAME = "EXPORT_ASCII";

    public ExportASCIIAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        String string = this.chengeFormat(TuxGuitar.instance().getFileHistory().getFileName(), this.getDefaultExtension());
        Shell shell = this.getEditor().getTablature().getShell();
        Object var4_4 = null;
        String[] stringArray = new String[]{"*.tab"};
        String string2 = FileChooser.instance().save(shell, FileChooser.EXPORT_ASCII_FORMAT, string);
        if (string2 != null) {
            ConfirmDialog confirmDialog;
            String string3;
            File file;
            boolean bl = true;
            if (!this.isSuportedFormat(string2)) {
                string2 = string2 + this.getDefaultExtension();
            }
            if ((file = new File(string3 = string2)).exists() && !(confirmDialog = new ConfirmDialog(this.getEditor().getTablature().getShell(), TuxGuitar.getProperty("replace-file-question"))).confirm()) {
                bl = false;
            }
            if (bl) {
                this.getEditor().getTablature().changeCursor(1);
                new Thread(new Runnable(){

                    public void run() {
                        try {
                            new ASCIITabOutputStream(string3).writeSong(ExportASCIIAction.this.getSongManager().getSong());
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            fileNotFoundException.printStackTrace();
                        }
                        new SyncThread(new Runnable(){

                            public void run() {
                                if (!TuxGuitar.isDisposed()) {
                                    ExportASCIIAction.this.getEditor().getTablature().changeCursor(0);
                                }
                            }
                        }).start();
                    }
                }).start();
            }
        }
        return true;
    }

    private String getDefaultFileName(String string) {
        String string2 = "untitled";
        String string3 = this.getDefaultExtension();
        if (string == null) {
            string = string2 + string3;
        } else if (!this.isSuportedFormat(string)) {
            string = this.chengeFormat(string, string3);
        }
        return string;
    }

    private boolean isSuportedFormat(String string) {
        return string.endsWith(this.getDefaultExtension());
    }

    private String chengeFormat(String string, String string2) {
        return this.removeExtension(string) + string2;
    }

    private String removeExtension(String string) {
        int n = string.lastIndexOf(46);
        return string.substring(0, n);
    }

    private String getDefaultExtension() {
        return ".tab";
    }
}

