package org.herac.tuxguitar.song.models;

public class SongChannel {
	public static final short DEFAULT_PERCUSION_CHANNEL = 9;
	
	private static final short DEFAULT_VOLUME = 127;
	private static final short DEFAULT_BALANCE = 64;
	private static final short DEFAULT_CHORUS = 0;
	private static final short DEFAULT_REVERB = 0;
	private static final short DEFAULT_PHASER = 0;
	private static final short DEFAULT_TREMOLO = 0;
	private static final boolean DEFAULT_SOLO = false;
	private static final boolean DEFAULT_MUTE = false;
	
    private short channel;
    private short effectChannel;
    private short instrument;
    private short volume;
    private short balance;
    private short chorus;
    private short reverb;
    private short phaser;
    private short tremolo;
    private boolean solo;
    private boolean mute;
    
	public SongChannel(short channel,short effectChannel, short instrument, short volume, short balance, short chorus, short reverb, short phaser, short tremolo,boolean solo,boolean mute) {		
		this.channel = channel;
		this.effectChannel = effectChannel;
		this.instrument = instrument;
		this.volume = volume;
		this.balance = balance;
		this.chorus = chorus;
		this.reverb = reverb;
		this.phaser = phaser;
		this.tremolo = tremolo;
		this.solo = solo;
		this.mute = mute;
	}

	public SongChannel(short channel,short effectChannel, short instrument){
		this(channel,
			 effectChannel,
			 instrument,
			 DEFAULT_VOLUME,
			 DEFAULT_BALANCE,
			 DEFAULT_CHORUS,
			 DEFAULT_REVERB,
			 DEFAULT_PHASER,
			 DEFAULT_TREMOLO,
			 DEFAULT_SOLO,
			 DEFAULT_MUTE);
	}

	public short getBalance() {
		return balance;
	}

	public void setBalance(short balance) {
		this.balance = balance;
	}

	public short getChannel() {
		return channel;
	}

	public void setChannel(short channel) {
		this.channel = channel;
	}

	public short getEffectChannel() {
		return effectChannel;
	}

	public void setEffectChannel(short effectChannel) {
		this.effectChannel = effectChannel;
	}

	public short getChorus() {
		return chorus;
	}

	public void setChorus(short chorus) {
		this.chorus = chorus;
	}

	public short getInstrument() {
		return instrument;
	}

	public void setInstrument(short instrument) {
		this.instrument = instrument;
	}

	public short getPhaser() {
		return phaser;
	}

	public void setPhaser(short phaser) {
		this.phaser = phaser;
	}

	public short getReverb() {
		return reverb;
	}

	public void setReverb(short reverb) {
		this.reverb = reverb;
	}

	public short getTremolo() {
		return tremolo;
	}

	public void setTremolo(short tremolo) {
		this.tremolo = tremolo;
	}

	public short getVolume() {
		return volume;
	}

	public void setVolume(short volume) {
		this.volume = volume;
	}

	public boolean isMute() {
		return mute;
	}

	public void setMute(boolean mute) {
		this.mute = mute;
	}

	public boolean isSolo() {
		return solo;
	}

	public void setSolo(boolean solo) {
		this.solo = solo;
	}

	public boolean isPercusionChannel(){
        return (this.getChannel() == DEFAULT_PERCUSION_CHANNEL);
    }
	
    public static SongChannel getDefaultPercusionChannel(){
        return new SongChannel(DEFAULT_PERCUSION_CHANNEL,DEFAULT_PERCUSION_CHANNEL,(short)0,(short)100,(short)0,(short)0,(short)0,(short)0,(short)0,false,false);
    }
    
    public Object clone(){
    	return new SongChannel(channel,effectChannel,instrument,volume,balance,chorus,reverb,phaser,tremolo,solo,mute);
    }

}
