/*
 * Created on 23-nov-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.song.managers;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.sound.midi.Instrument;
import javax.sound.midi.Soundbank;

import org.herac.tuxguitar.io.SongLoader;
import org.herac.tuxguitar.io.SongWriter;
import org.herac.tuxguitar.io.gp.GPFormatException;
import org.herac.tuxguitar.play.models.Player;
import org.herac.tuxguitar.play.models.defaultplayer.SongPlayer;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.Song;
import org.herac.tuxguitar.song.models.SongChannel;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;
import org.herac.tuxguitar.song.models.TrackColor;


/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class SongManager {
    public static short MAX_CHANNELS = 16;
    
    private Song song;
    private Player player;
    private SongTrackManager trackManager;
    private MeasureManager measureManager;
    
    public SongManager(){               
        this.player = new SongPlayer(this);
        this.newSong();
    }
    
    public void setSongName(String name){
        getSong().setName(name);
    }
    
    public Song getSong(){
        return this.song;
    }
    
    public void newSong(){
        setSong(makeNewSong());        
    }
    
    public void save(String fileName){                        
        try {
            new SongWriter(fileName).write(getSong());    
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (GPFormatException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }         
    }
    
    public void open(String fileName) throws GPFormatException, IOException{
        SongLoader loader = new SongLoader(fileName);
        Song song = loader.load();
        if(song != null){
            setSong(song);
        }            
    }        

    public void setSong(Song song){
        this.song = song;
        this.player.reset();
    }
    
    public void setProperties(String name,String interpret,String album,String author){
        getSong().setName(name);
        getSong().setInterpret(interpret);
        getSong().setAlbum(album);
        getSong().setAuthor(author);
    }
    
    public Player getPlayer(){
        return this.player;
    }
    
    
    public void addTrack(SongTrack trackToAdd){
    	this.orderTracks();
    	int addIndex = -1;
    	for(int i = 0;i < getSong().getTracks().size();i++){
    		SongTrack track = (SongTrack)getSong().getTracks().get(i);
    		if(addIndex == -1 && track.getNumber() == trackToAdd.getNumber()){
    			addIndex = i;
    		}
    		if(addIndex >= 0){
    			track.setNumber(track.getNumber() + 1);
    		}
    	}
    	if(addIndex < 0){
    		addIndex = getSong().getTracks().size();
    	}
        getSong().getTracks().add(addIndex,trackToAdd);
    }
    
    public void removeTrack(long number){
    	this.orderTracks();
    	SongTrack trackToRemove = null;
    	
        Iterator it = getSong().getTracks().iterator();
        while(it.hasNext()){
            SongTrack currTrack = (SongTrack)it.next();            
            if(trackToRemove == null && currTrack.getNumber() == number){
            	trackToRemove = currTrack;
            }else if(currTrack.getNumber() == (number + 1)){            	
            	currTrack.setNumber(number);
            	number ++;
            }
            
        }
        getSong().getTracks().remove(trackToRemove);
    }
    
    private void orderTracks(){
        for(int i = 0;i < getSong().getTracks().size();i++){
        	SongTrack minTrack = null;
            for(int trackIdx = i;trackIdx < getSong().getTracks().size();trackIdx++){
            	SongTrack track = (SongTrack)getSong().getTracks().get(trackIdx);
                if(minTrack == null || track.getNumber() < minTrack.getNumber()){
                	minTrack = track;
                }
            }
            getSong().getTracks().remove(minTrack);
            getSong().getTracks().add(i,minTrack);
        }
    }
    
    public SongTrack getTrack(Measure measure){
        SongTrack track = null;
        Iterator it = getSong().getTracks().iterator();
        while(it.hasNext()){
            SongTrack currTrack = (SongTrack)it.next();
            if(currTrack.getMeasures().contains(measure)){
                track = currTrack;
                break;
            }
        }
        return track;
    }
    
    public static Song makeNewSong(){
        List tracks = new ArrayList();
        tracks.add(makeNewTrack(1,"Track 1"));
        
        return new Song(tracks);  
    }    

    public static SongTrack makeNewTrack(long number,String name){
        TimeSignature timeSignature = new TimeSignature(4,new Duration(Duration.QUARTER));
        Tempo tempo = new Tempo(100);        
        List strings = createDefaultInstrumentStrings();        

        List measures = new ArrayList();
        measures.add(new Measure(1,1000, new ArrayList(), new ArrayList(), timeSignature,tempo,1,0,false,0));

        return new SongTrack(number,name,new SongChannel((short)0,(short)1,(short)0), measures, strings,TrackColor.RED);        
    }
    
    public long getNextTrackNumber(){
    	return countTracks() + 1;
    }
    
    public boolean isEmpty(){
    	return this.song.getTracks().isEmpty();
    }
    
    public SongChannel getFreeChannel(short instrument,boolean isPercusion){
        return getFreeChannel(getSong().getTracks(),instrument,isPercusion);
    }
 
    public static SongChannel getFreeChannel(List tracks,short instrument,boolean isPercusion){
    	if(isPercusion){
    		return SongChannel.getDefaultPercusionChannel();
    	}
        short channel = -1;
        short effectChannel = -1;
    	
        boolean[] usedChannels = getUsedChannels(tracks);
        boolean[] usedEffectChannels = getUsedEffectChannels(tracks);        
        for(short i = 0;i < MAX_CHANNELS;i++){
        	if(!usedChannels[i] && !usedEffectChannels[i]){
	            channel = (channel < 0)?i:channel;
	            effectChannel = (effectChannel < 0 && i != channel)?i:effectChannel;
        	}
        }
        if(channel < 0 || effectChannel < 0){
        	if(channel >= 0 ){
        		effectChannel = channel;
        	}else{
        		SongChannel songChannel = (SongChannel)((SongTrack)tracks.get(tracks.size() - 1)).getChannel();
        		return (SongChannel)songChannel.clone();
        	}
        }
    	return new SongChannel(channel,effectChannel,instrument);
    }
    
    public boolean[] getUsedEffectChannels(){
        return getUsedEffectChannels(getSong().getTracks());
    }
    
    public static boolean[] getUsedEffectChannels(List tracks){
        boolean[] usedEffectChannels = new boolean[MAX_CHANNELS];
        
        for(int i = 0;i < tracks.size();i++){
            SongTrack track = (SongTrack)tracks.get(i);            
            usedEffectChannels[track.getChannel().getEffectChannel()] = true;
        }        
        return usedEffectChannels;
    }
    
    public boolean[] getUsedChannels(){
    	return getUsedChannels(getSong().getTracks());
    }
    
    public static boolean[] getUsedChannels(List tracks){
        boolean[] usedChannels = new boolean[MAX_CHANNELS];
        
        for(int i = 0;i < tracks.size();i++){
            SongTrack track = (SongTrack)tracks.get(i);            
            usedChannels[track.getChannel().getChannel()] = true;
        }        
        return usedChannels;
    }    
    
    public SongChannel getUsedChannel(int channel){
        for(int i = 0;i < getSong().getTracks().size();i++){
            SongTrack track = (SongTrack)getSong().getTracks().get(i);            
            if(channel == track.getChannel().getChannel()){
            	return (SongChannel)track.getChannel().clone();
            }
        }   
        return null;
    }
    
    public int countTracksForChannel(int channel){
    	int count = 0;
        for(int i = 0;i < getSong().getTracks().size();i++){
            SongTrack track = (SongTrack)getSong().getTracks().get(i);            
            if(channel == track.getChannel().getChannel()){
            	count ++;
            }
        }   
        return count;
    }
    
    public void updateChannel(SongChannel channel){
        for(int i = 0;i < getSong().getTracks().size();i++){
            SongTrack track = (SongTrack)getSong().getTracks().get(i);            
            if(channel.getChannel() == track.getChannel().getChannel()){
            	track.setChannel((SongChannel)channel.clone());
            }
        }
    }
    
    public static List createDefaultInstrumentStrings(){
        List strings = new ArrayList();        
        strings.add(new InstrumentString(1, 64));
        strings.add(new InstrumentString(2, 59));
        strings.add(new InstrumentString(3, 55));
        strings.add(new InstrumentString(4, 50));
        strings.add(new InstrumentString(5, 45));
        strings.add(new InstrumentString(6, 40));
        return strings;
    }
    
    public static List createPercusionStrings(int stringCount){
        List strings = new ArrayList();      
        for(int i = 1;i <= stringCount; i++){
            strings.add(new InstrumentString(i, 0));
        }
        return strings;
    }        
    
    public void calculateMeasureStartWidthRepetitions(){
        Iterator it = getSong().getTracks().iterator();
        while(it.hasNext()){
            SongTrack songTrack = (SongTrack)it.next();
            calculateMeasureStartWidthRepetitions(songTrack);
        }
    }
    
    private void calculateMeasureStartWidthRepetitions(SongTrack songTrack){
        boolean repeatOpen = true;        
        long repeatStart = 1000;
        
        long repeatEnd = 0;
        long startMove = 0;
        int repeatStartIndex = 0;
        int repeatNumber = 0;

        for (int measureIdx = 0; measureIdx < songTrack.getMeasures().size(); measureIdx++) {
            Measure measure = (Measure) songTrack.getMeasures().get(measureIdx);
            
            //asigno el start con repeticiones
            if(!repeatOpen || measure.getStart() + measure.getLength() > repeatEnd){
                measure.setStartWidthRepetitions(measure.getStart() + startMove);
                //calculo las notas dentro del compas
                calculateNoteStartWidthRepetitions(measure,startMove);
            }            

            //guardo el indice de el compas donde empieza una repeticion
            if (measure.isRepeatStart()) {
                repeatStartIndex = measureIdx;                
                repeatStart = measure.getStart();
                repeatOpen = true;
            }

            //si hay una repeticion la hago
            if (repeatOpen && measure.getNumberOfRepetitions() > 0) {
                if (repeatNumber < measure.getNumberOfRepetitions()) {
                    repeatEnd = measure.getStart() + measure.getLength();
                    startMove += repeatEnd - repeatStart;
                    measureIdx = repeatStartIndex - 1;
                    repeatNumber++;
                } else {
                    repeatStart = 0;
                    repeatNumber = 0;
                    repeatEnd = 0;
                    repeatOpen = false;
                }
            }

        }        
    }
    
    private void calculateNoteStartWidthRepetitions(Measure measure,long startMove) {
        for (int noteIdx = 0; noteIdx < measure.getNotes().size(); noteIdx++) {
            Note note = (Note) measure.getNotes().get(noteIdx);
            //asigno el start con repeticiones           
            note.setStartWidthRepetitions(note.getStart() + startMove);
        }

    }    
    
    public String getInstrumentName(int instrument){
    	String name = null;
    	Soundbank soundBank = getPlayer().getDefaultSoundbank();
    	if(soundBank != null){
    		Instrument[] instruments = soundBank.getInstruments();
    		name = instruments[instrument].getName();
    	}else{
    		name = Integer.toString(instrument);
    	}
    	return name;
    }
    
    public int countTracks(){
    	return (getSong().getTracks().size());
    }

    public int countMeasures(){
    	return (getTrackManager().countMeasures(getFirstTrack()));
    }
    
    public SongTrackManager getTrackManager(){
    	if(this.trackManager == null){
    		this.trackManager = new SongTrackManager(this);
    	}
    	return this.trackManager;
    }
    
    public MeasureManager getMeasureManager(){
    	if(this.measureManager == null){
    		this.measureManager = new MeasureManager(this);
    	}
    	return this.measureManager;
    }
    
    
    
    
    
    
    
    
    
    
    
    public SongTrack getTrack(long number){
        SongTrack track = null;        
        for (int i = 0; i < getSong().getTracks().size(); i++) {
            SongTrack currTrack = (SongTrack) getSong().getTracks().get(i);            
            if(currTrack.getNumber() == number){
            	track = currTrack;
                break;
            }
        }     
        return track;
    }  
    
    
    public SongTrack getFirstTrack(){
        SongTrack track = null;
        if(!getSong().getTracks().isEmpty()){
            track = (SongTrack)getSong().getTracks().get(0);
        }
        return track;
    }       

    public SongTrack getLastTrack(){
        SongTrack track = null;
        if(!getSong().getTracks().isEmpty()){
            track = (SongTrack)getSong().getTracks().get(getSong().getTracks().size() - 1);
        }
        return track;
    }   

    public SongTrack cloneTrack(SongTrack track){
    	SongTrack clone = (SongTrack)track.clone();
    	clone.setNumber(getNextTrackNumber());
    	addTrack(clone);    	
    	return clone;
    }
    
    public boolean moveTrackUp(SongTrack track){  
    	if(track.getNumber() > 1){
    		SongTrack prevTrack = getTrack(track.getNumber() - 1);
    		prevTrack.setNumber(prevTrack.getNumber() + 1);        
    		track.setNumber(track.getNumber() - 1);    		
    		orderTracks();
    		return true;
    	}
    	return false;
    }       

    public boolean moveTrackDown(SongTrack track){  
    	if(track.getNumber() < this.countTracks()){
    		SongTrack nextTrack = getTrack(track.getNumber() + 1);
    		nextTrack.setNumber(nextTrack.getNumber() - 1);        
    		track.setNumber(track.getNumber() + 1);    		
    		orderTracks();
    		return true;
    	}
    	return false;
    }    

    private SongTrack makeNewTrack(SongTrack songTrack){        
        //measures
        List measures = new ArrayList();        
        Iterator measureIt = songTrack.getMeasures().iterator();
        while(measureIt.hasNext()){
            Measure measure = (Measure)measureIt.next();
            int number = measure.getNumber();
            long start = measure.getStart();
            int clef = measure.getClef();
            int keySignature = measure.getKeySignature();
            boolean repeatStart = measure.isRepeatStart();
            int nombreOfRepetitions = measure.getNumberOfRepetitions();
            TimeSignature timeSignature = (TimeSignature)measure.getTimeSignature().clone();
            Tempo tempo = (Tempo)measure.getTempo().clone();
            
            measures.add(new Measure(number,start,new ArrayList(),new ArrayList(),timeSignature,tempo,clef,keySignature,repeatStart,nombreOfRepetitions));
        }
        //Strings
        long number = getNextTrackNumber();
        String name = "Track " + number;
        SongChannel channel = getFreeChannel((short)0,false);
        List strings = createDefaultInstrumentStrings();

        return new SongTrack(number,name,channel,measures,strings,TrackColor.RED);
    }
    
    public SongTrack createTrack(){
        SongTrack track = null;
        if(getSong().getTracks().isEmpty()){
        	long number = getNextTrackNumber();
            track = SongManager.makeNewTrack(number,"Track " + number);
        }else{
            track = makeNewTrack(getFirstTrack());
        }
        addTrack(track);
        return track;
    }

    public void removeTrack(SongTrack track){
    	removeTrack(track.getNumber());
    }    
    
    public void changeTimeSignature(long start,TimeSignature timeSignature,boolean toEnd){
        Iterator it = getSong().getTracks().iterator();
        while(it.hasNext()){
            SongTrack track = (SongTrack)it.next();
            getTrackManager().changeTimeSignature(track,start,timeSignature,toEnd);
        }
    }
    
    public void changeTempo(long start,Tempo tempo,boolean toEnd){
        Iterator it = getSong().getTracks().iterator();
        while(it.hasNext()){
            SongTrack track = (SongTrack)it.next();
            getTrackManager().changeTempo(track,start,tempo,toEnd);
        }
    }    

    public void changeOpenRepeat(long start){
        Iterator it = getSong().getTracks().iterator();
        while(it.hasNext()){
            SongTrack track = (SongTrack)it.next();
            getTrackManager().changeOpenRepeat(track,start);
        }
        calculateMeasureStartWidthRepetitions();
    }        
    
    public void changeCloseRepeat(long start,int numberOfRepetitions){
        Iterator it = getSong().getTracks().iterator();
        while(it.hasNext()){
            SongTrack track = (SongTrack)it.next();
            getTrackManager().changeCloseRepeat(track,start,numberOfRepetitions);
        }
        calculateMeasureStartWidthRepetitions();
    }         

    public void addNewMeasureBeforeEnd(){        
        Iterator it = getSong().getTracks().iterator();
        while(it.hasNext()){
        	SongTrack track = (SongTrack)it.next();
            
            getTrackManager().addNewMeasureBeforeEnd(track);            
        }   
        calculateMeasureStartWidthRepetitions();
    }

    public void removeMeasures(long p1,long p2){
        Iterator it = getSong().getTracks().iterator();
        while(it.hasNext()){
        	SongTrack track = (SongTrack)it.next();
            getTrackManager().removeMeasures(track,p1,p2);    	            
        } 
        calculateMeasureStartWidthRepetitions();
    }
    
    public void removeMeasure(long start){
        Iterator it = getSong().getTracks().iterator();
        while(it.hasNext()){
        	SongTrack track = (SongTrack)it.next();
            getTrackManager().removeMeasure(track,start);     
        }   
        calculateMeasureStartWidthRepetitions();
    }
        
    public List getMeasures(long start){
    	List measures = new ArrayList();
        Iterator it = getSong().getTracks().iterator();
        while(it.hasNext()){
        	SongTrack track = (SongTrack)it.next();
            Measure measure = getTrackManager().getMeasureAt(track,start);
            if(measure != null){
            	measures.add(measure);
            }
        }  
        return measures;
    }    
    
    
    public List[] copyMeasures(long p1,long p2){
    	List[] trackMeasures = new List[getSong().getTracks().size()];
    	
        for(int i = 0;i < trackMeasures.length;i++){
        	SongTrack track = getTrack((i + 1));
            List measures = getTrackManager().copyMeasures(track,p1,p2);
            trackMeasures[i] = measures;
        }  
    	
    	return trackMeasures;
    }
        
    public SongTrack replaceTrack(SongTrack t){
    	SongTrack track = getTrack(t.getNumber());
    	if(track != null){
    		track.makeEqual(t);
    	}
    	return track;
    }
}
