package org.herac.tuxguitar.play.models.tg_player;


import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.sound.midi.Receiver;

import org.herac.tuxguitar.song.models.InstrumentString;

public class NotePlayer {
	/**
	 * Receiver
	 */		
	private Receiver receiver;
	/**
	 * Notas en proceso
	 */
	private List channelNotes;	
	/**
	 * Notas para reproducir
	 */	
	private List startNotes = new ArrayList();
	/**
	 * Notas para finalizar
	 */		
	private List stopNotes = new ArrayList();
	/**
	 * Notas que estan reproduciendo efectos
	 */			
	private List effectNotes = new ArrayList();	
	
	
	public NotePlayer(Receiver receiver){
		this.receiver = receiver;
		this.channelNotes = new ArrayList();
	}
	
	public void addNote(ChannelNote data){
		channelNotes.add(data);
	}

	public void playNote(ChannelNote data){
		int channel = data.getTrack().getChannel().getChannel();
		int note = data.getNote().getValue() + ((InstrumentString)data.getTrack().getStrings().get(data.getNote().getString() - 1)).getValue();		
		this.receiver.send(MidiMessageUtils.noteOn(channel,note,64),-1);
	}	
	
	public void stopNote(ChannelNote data){
		int channel = data.getTrack().getChannel().getChannel();
		int note = data.getNote().getValue() + ((InstrumentString)data.getTrack().getStrings().get(data.getNote().getString() - 1)).getValue();				
		this.receiver.send(MidiMessageUtils.noteOff(channel,note,64),-1);
	}	
	
	public void checkNotes(){
		startNotes.clear();
		stopNotes.clear();
		effectNotes.clear();
		
		Iterator it = channelNotes.iterator();
		while(it.hasNext()){
			ChannelNote channelNote = (ChannelNote)it.next();
			if(channelNote.shouldStop()){
				stopNotes.add(channelNote);
			}else if(!channelNote.isPlaying()){
				startNotes.add(channelNote);		
			}
		}		
		
		stopNotes();
		playNotes();
	}
	
	public void playNotes(){		
		Iterator it = startNotes.iterator();
		while(it.hasNext()){
			ChannelNote data = (ChannelNote)it.next();
			data.setPlaying();
			playNote(data);			
		}
	}	
	
	public void stopNotes(){		
		Iterator it = stopNotes.iterator();
		while(it.hasNext()){
			ChannelNote data = (ChannelNote)it.next();
			stopNote(data);
			channelNotes.remove(data);
		}
	}

	public void stopAll(){
		startNotes.clear();
		stopNotes.clear();
		effectNotes.clear();
		
		Iterator it = channelNotes.iterator();
		while(it.hasNext()){
			ChannelNote channelNote = (ChannelNote)it.next();
			stopNotes.add(channelNote);
		}	
		stopNotes();
	}
}
