package org.herac.tuxguitar.play.models.tg_player;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.SongTrack;

public class ChannelNote{	
	private SongTrack track;	
	private Measure measure;
	private Note note;
	private boolean playing;
	private long durationInMillis;
	private long startInMillis;
	
	public ChannelNote(SongTrack track,Measure measure,Note note){
		this.track = track;
		this.measure = measure;
		this.note = note;					
	}
	
	public void setPlaying(){
		this.playing = true;
		this.durationInMillis = SongPlayer.getTime(measure.getTempo().getValue(),note.getDuration().getTime());			
		this.startInMillis = System.currentTimeMillis();
	}
	
	public boolean isPlaying(){
		return this.playing;
	}
	
	public Measure getMeasure() {
		return measure;
	}

	public void setMeasure(Measure measure) {
		this.measure = measure;
	}

	public Note getNote() {
		return note;
	}

	public void setNote(Note note) {
		this.note = note;
	}

	public SongTrack getTrack() {
		return track;
	}

	public void setTrack(SongTrack track) {
		this.track = track;
	}

	public boolean shouldStop(){
		return (isPlaying() && System.currentTimeMillis() > (startInMillis + durationInMillis));
	}
}	