package org.herac.tuxguitar.play.models.tg_player;


import javax.sound.midi.Receiver;

import org.herac.tuxguitar.play.models.defaultplayer.DefinedControllers;
import org.herac.tuxguitar.song.models.Song;
import org.herac.tuxguitar.song.models.SongChannel;
import org.herac.tuxguitar.song.models.SongTrack;

public class ChannelControl {

	private Receiver receiver;
	
	public ChannelControl(Receiver receiver){
		this.receiver = receiver;
	}
	
	public void update(Song song){
		for(int i = 0;i < song.getTracks().size();i++){
			SongTrack track = (SongTrack)song.getTracks().get(i);
			
			updateChannel(track.getChannel());
		}
	}
	
	public void updateChannel(SongChannel channel){
		receiver.send(MidiMessageUtils.programChange(channel.getChannel(),channel.getInstrument()),-1);		
		receiver.send(MidiMessageUtils.controlChange(channel.getChannel(),DefinedControllers.VOLUME,channel.getVolume()),-1);
		receiver.send(MidiMessageUtils.controlChange(channel.getChannel(),DefinedControllers.BALANCE,channel.getBalance()),-1);	
		receiver.send(MidiMessageUtils.controlChange(channel.getChannel(),DefinedControllers.REVERB,channel.getReverb()),-1);
		receiver.send(MidiMessageUtils.controlChange(channel.getChannel(),DefinedControllers.CHORUS,channel.getChorus()),-1);
		receiver.send(MidiMessageUtils.controlChange(channel.getChannel(),DefinedControllers.PHASER,channel.getPhaser()),-1);
		receiver.send(MidiMessageUtils.controlChange(channel.getChannel(),DefinedControllers.TREMOLO,channel.getTremolo()),-1);
		
		if(channel.getChannel() != channel.getEffectChannel()){
			receiver.send(MidiMessageUtils.programChange(channel.getEffectChannel(),channel.getInstrument()),-1);
			receiver.send(MidiMessageUtils.controlChange(channel.getEffectChannel(),DefinedControllers.VOLUME,channel.getVolume()),-1);
			receiver.send(MidiMessageUtils.controlChange(channel.getEffectChannel(),DefinedControllers.BALANCE,channel.getBalance()),-1);
			receiver.send(MidiMessageUtils.controlChange(channel.getEffectChannel(),DefinedControllers.REVERB,channel.getReverb()),-1);
			receiver.send(MidiMessageUtils.controlChange(channel.getEffectChannel(),DefinedControllers.CHORUS,channel.getChorus()),-1);
			receiver.send(MidiMessageUtils.controlChange(channel.getEffectChannel(),DefinedControllers.PHASER,channel.getPhaser()),-1);
			receiver.send(MidiMessageUtils.controlChange(channel.getEffectChannel(),DefinedControllers.TREMOLO,channel.getTremolo()),-1);		
		}
	}
}
