package org.herac.tuxguitar.play.models.tg_player;


import java.util.List;

import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.Song;
import org.herac.tuxguitar.song.models.SongTrack;

public class BeatIterator {
	/**
	 * Posicion actual
	 */
	private long tickPosition;
	/**
	 * Siguiente posicion
	 */
	private long nextTickPosition;
	/**
	 * Tiempo de duracion del beat
	 */
	private long beatDuration;	
	/**
	 * Indice del compas actual
	 */	
	private int measureIndex;		
	/**
	 * Reproductor de notas
	 */
	private NotePlayer notePlayer;
	
	public BeatIterator(NotePlayer notePlayer){			
		this.notePlayer = notePlayer;	
		this.initPosition();
	}
	
	private void initPosition(){
		this.nextTickPosition = 1000;
	}	
	
	public void nextBeat(Song song){		
		this.tickPosition = this.nextTickPosition;
		this.nextTickPosition = 0;
		
		this.loadSongBeat(song);
		
		if(this.nextTickPosition <= 0){
			SongTrack firstTrack = (SongTrack)song.getTracks().get(0);
			Measure nextMeasure = getNextMeasure(firstTrack);
			if(nextMeasure != null){
				this.nextTickPosition = nextMeasure.getStart();
			}
		}				
		this.checkBeatDuration(song);
	}
	
	public void loadSongBeat(Song song){
		for(int tIdx = 0;tIdx < song.getTracks().size();tIdx++){
			SongTrack track = (SongTrack)song.getTracks().get(tIdx);
			Measure measure = getCurrentMeasure(track);
			if(measure != null){
				loadMeasureBeat(track,measure);
			}
		}
	}

	
	public void loadMeasureBeat(SongTrack track,Measure measure){
		for(int i = 0;i < measure.getNotes().size();i++){						
			Note note = (Note)measure.getNotes().get(i);
			//chequeo si esta en el tickposition
			if(note.getStart() == this.tickPosition){
				notePlayer.addNote(new ChannelNote(track,measure,note));
			}else if(note.getStart() > this.tickPosition){
				//chequeo si es el proximo tickposition
				if(this.nextTickPosition <= 0 || note.getStart() < this.nextTickPosition){
					this.nextTickPosition = note.getStart();
				}
			}
		}	
	}

	public Measure getCurrentMeasure(SongTrack track){
		List measures = track.getMeasures();
		for(int i = this.measureIndex;i < measures.size();i ++){						
			Measure measure = (Measure)measures.get(i);
			if(this.tickPosition >= measure.getStart() && this.tickPosition < measure.getStart() + measure.getLength()){
				this.measureIndex = i;
				return measure;
			}
		}		
		this.measureIndex = 0;
		return null;
	}

	public Measure getNextMeasure(SongTrack track){
		List measures = track.getMeasures();
		if(measures.size() > (this.measureIndex + 1)){
			return (Measure)measures.get((this.measureIndex + 1));
		}		
		return null;
	}
	
	public void checkBeatDuration(Song song){
		if(this.nextTickPosition > 0){
			SongTrack firstTrack = (SongTrack)song.getTracks().get(0);
			Measure current = getCurrentMeasure(firstTrack);
			if(current != null){
				int tempo = current.getTempo().getValue();
				long time = this.nextTickPosition - this.tickPosition;
				this.beatDuration = SongPlayer.getTime(tempo,time);
			}
		}			
	}
	
	public long getNextTickPosition() {
		return nextTickPosition;
	}
/*
	public void setNextTickPosition(long nextTickPosition) {
		this.nextTickPosition = nextTickPosition;
		this.measureIndex = 0;
	}
*/
	public long getTickPosition() {
		return tickPosition;
	}

	public void setTickPosition(long tickPosition) {
		this.tickPosition = tickPosition;
		
		this.nextTickPosition = tickPosition;
		this.measureIndex = 0;		
	}

	public long getBeatDuration() {
		return beatDuration;
	}
	
}
