/*
 * Created on 24-nov-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.play.models.defaultplayer;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Transmitter;

import org.herac.tuxguitar.play.models.Player;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.SongChannel;
import org.herac.tuxguitar.song.models.SongTrack;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class SongPlayer implements Player {

    private SongManager songManager;

    private Sequencer sequencer;

    private Synthesizer synthesizer;

    private Soundbank soundbank;

    private MeasureStartMetaEventListener controller;

    private boolean realTimeSequencer;
    
    private boolean running;

    private boolean paused;
    
    private boolean changeTickPosition;

    private long tickPosition;

    public SongPlayer(SongManager songManager) {        
    	this.songManager = songManager;
        this.controller = new MeasureStartMetaEventListener();        	
		this.init();
		this.reset();        
    }

    /**
     * Retorna el Sequenciador
     * @throws MidiUnavailableException 
     */
    private Sequencer getSequencer() throws MidiUnavailableException {
    	if (this.sequencer == null) {
    		this.sequencer = MidiSystem.getSequencer();
            this.sequencer.addMetaEventListener(this.controller);
        }
        if (!this.sequencer.isOpen()) {
        	this.sequencer.open();
        }            
        return this.sequencer;
    }

    /**
     * Retorna el Sintetizador
     * @throws MidiUnavailableException 
     */
    public Synthesizer getSynthesizer() throws MidiUnavailableException {
    	if (this.synthesizer == null) {
    		Sequencer sequencer = getSequencer();
    		if (sequencer instanceof Synthesizer) {
    			this.synthesizer = MidiSystem.getSynthesizer();
    			this.synthesizer.open();        
    			this.realTimeSequencer = false;
    		} else {                
    			this.synthesizer = MidiSystem.getSynthesizer();
                this.synthesizer.open();      
                this.realTimeSequencer = true;
                Receiver receiver = this.synthesizer.getReceiver();
                Transmitter transmitter = sequencer.getTransmitter();
                transmitter.setReceiver(receiver);                                
    		}
    	} 
        return this.synthesizer;
    }
    
    /**
     * Retorna el Soundbank por defecto
     * @throws MidiUnavailableException 
     */
    public Soundbank getDefaultSoundbank(){
    	if (this.soundbank == null) {      
    		try{    		  	
    			Synthesizer synthesizer = getSynthesizer();
    			this.soundbank = synthesizer.getDefaultSoundbank();                         	
        	} catch (MidiUnavailableException e) {
        		e.printStackTrace();
        	}   
    	}
        return this.soundbank;
    }
    
    /**
     * Inicia el Secuenciador y Sintetizador
     * @throws MidiUnavailableException 
     */

    public void init() {
        try{
        	getSynthesizer();
        	getSequencer();
        } catch (MidiUnavailableException e) {
        	e.printStackTrace();
        }         
    }

    /**
     * Resetea los valores
     * @throws MidiUnavailableException 
     */
    public void reset(){
    	this.stop();
        this.tickPosition = 1000;
        this.setChangeTickPosition(false);
        this.controller.reset();       
    }

    /**
     * Cierra el Secuenciador y Sintetizador
     * @throws MidiUnavailableException 
     */
    public void close(){
    	try{
    		stop();
    		Synthesizer synthesizer = getSynthesizer();
    		if (synthesizer != null) {
    			synthesizer.close();
    		}        
    		Sequencer sequencer = getSequencer();
    		if (sequencer != null) {
    			sequencer.close();
    		}
    	} catch (MidiUnavailableException e) {
    		e.printStackTrace();
    	}         
    }

    public void allSoundOff(){
    	try{
    		MidiChannel[] channels = getSynthesizer().getChannels();
    		for(int i = 0;i < channels.length;i ++){
    			channels[i].allSoundOff();
    		}
		} catch (MidiUnavailableException e) {
			e.printStackTrace();
		}    				
		this.setRunning(false);		
    }
    
    /**
     * Para la reproduccion
     * @throws MidiUnavailableException 
     */
    public void stop(boolean paused) {        
    	this.setPaused(paused);    		 
    	try{
    		if(this.isRunning() && this.getSequencer().isOpen()){
    			this.getSequencer().stop();
    			this.allSoundOff();    		
    		}	
    	} catch (MidiUnavailableException e) {
    		e.printStackTrace();
    	}      	
    	this.setRunning(false);
    }    
    
    /**
     * Para la reproduccion
     * @throws MidiUnavailableException 
     */
    public void stop() {        
    	this.stop(false);   		               	
    }

    public void pause(){
    	this.stop(true); 
    }
    
    /**
     * Return true if this sequencer is a real time sequencer
     */
    public boolean isRealTimeSequencer(){
    	return this.realTimeSequencer;
    }
    
    /**
     * Inicia la reproduccion
     * @throws MidiUnavailableException 
     */
    public synchronized void play(){     
    	try {      	
    		this.stop(); 
    		this.setRunning(true);     
    	
    		this.addSecuence();                    
    		this.setChangeTickPosition(true);
    		this.getSequencer().start();    
    		new Thread(new Runnable() {
    			public synchronized void run() {
    				try {                	
    					while (getSequencer().isRunning() && isRunning()) {
    						if (isChangeTickPosition()) {
    							changeTickPosition();
    						}	
    						tickPosition =  getSequencer().getTickPosition();
    						Thread.sleep(10);
    					}
                    
    					//FINISH
    					if(isRunning()){
    						if(tickPosition >= (getSequencer().getTickLength() - 500)){
    							reset();
    						}else {
    							stop(isPaused());
    						}               
    					}
    				} catch (InterruptedException e) {
    					e.printStackTrace();
    				} catch (MidiUnavailableException e) {
    					reset();  
						e.printStackTrace();
					}
    			}
    		}).start();
    	
    	}catch (MidiUnavailableException e) {
    		reset();   	
			e.printStackTrace();
		}
    }


    /**
     * Asigna el valor a running
     */
    public void setRunning(boolean running) {
        this.running = running;
    }

    /**
     * Retorna True si esta reproduciendo
     */
    public boolean isRunning() {
        return this.running;
    }

    public boolean isPaused() {
		return paused;
	}

	public void setPaused(boolean paused) {
		this.paused = paused;
	}

	/**
     * Retorna True si hay cambios en la posicion
     */
    private boolean isChangeTickPosition() {
        return changeTickPosition;
    }

    /**
     * Asigna los cambios de la posicion
     */
    private void setChangeTickPosition(boolean changeTickPosition) {
        this.changeTickPosition = changeTickPosition;
    }


    /**
     * Indica la posicion del secuenciador
     * @throws MidiUnavailableException 
     */
    public void setTickPosition(long position) {
    	setTickPosition(position,controller.getStartMove()); 
    }    
    
    /**
     * Indica la posicion del secuenciador
     * @throws MidiUnavailableException 
     */
    public void setTickPosition(long position,long startMove) {
    	this.tickPosition = position;
    	this.controller.setStartMove(startMove);
    	this.setChangeTickPosition(true);
    	if(!isRunning()){
    		this.allSoundOff();
    		this.changeTickPosition();
    	}
    }
    
    /**
     * Retorna el tick de la nota que esta reproduciendo
     */
    public long getTickPosition() {
    	return this.tickPosition - this.controller.getStartMove();
    }

    private void changeTickPosition(){
    	try{
    		if(isRunning()){
    			getSequencer().setTickPosition(tickPosition);
    		}    		
    		updateChannels();
		} catch (MidiUnavailableException e) {
			e.printStackTrace();
		}        
        setChangeTickPosition(false);    	
    }
    
    /**
     * Agrega la Secuencia
     * @throws MidiUnavailableException 
     */
    public void addSecuence() {
    	try{
    		SongSequence songSequence = new SongSequence(songManager);
    		songSequence.createSongSecuence(isRealTimeSequencer(),true);
    		getSequencer().setSequence(songSequence.getSongSecuence());
		} catch (MidiUnavailableException e) {
			e.printStackTrace();
		} catch (InvalidMidiDataException e) {
			e.printStackTrace();
		}    		
    }
    
    
    public void loadSoundbank(File file){    
		try {
			Soundbank soundbank = MidiSystem.getSoundbank(file);
			if (soundbank != null){
				if(getSynthesizer().isSoundbankSupported(soundbank)){
					getSynthesizer().loadAllInstruments(soundbank);
					this.soundbank = soundbank;
				}
			}    	
		} catch (InvalidMidiDataException e) {			
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		} catch (MidiUnavailableException e) {
			e.printStackTrace();
		}
    }
    
    public void updateChannels() {    	
    	if(isRealTimeSequencer()){
    		Iterator it = this.songManager.getSong().getTracks().iterator();
        	while(it.hasNext()){
           		SongTrack track = (SongTrack)it.next();
           		updateChannel(track.getChannel());            
        	}
    	}	
    }
    
    public void updateChannel(SongChannel channel)  {
    	try {
    		double gain = (double)(this.songManager.getSong().getVolume() / 10.0);
    		int volume = (int)(gain * channel.getVolume());      	
    		int balance = channel.getBalance();   	
    		boolean solo = channel.isSolo();
    		boolean mute = channel.isMute();
    	
    		Synthesizer synthesizer = getSynthesizer();
    		MidiChannel[] channels = synthesizer.getChannels();   
        
    		channels[channel.getChannel()].controlChange(DefinedControllers.VOLUME,volume);
    		channels[channel.getChannel()].controlChange(DefinedControllers.BALANCE,balance);
    		channels[channel.getChannel()].setSolo(solo);
    		channels[channel.getChannel()].setMute(mute);
    		if(channel.getChannel() != channel.getEffectChannel()){
    			channels[channel.getEffectChannel()].controlChange(DefinedControllers.VOLUME,volume);
    			channels[channel.getEffectChannel()].controlChange(DefinedControllers.BALANCE,balance);
    			channels[channel.getEffectChannel()].setSolo(solo);
    			channels[channel.getEffectChannel()].setMute(mute);
    		}        
		} catch (MidiUnavailableException e) {
			e.printStackTrace();
		}        
    }
    
    public void playBeat(final SongTrack track,final List notes) {
    	try {    	
    		final MidiChannel[] channels = getSynthesizer().getChannels();

    		Iterator it = notes.iterator();
    		while(it.hasNext()){
    			Note note = (Note)it.next();							    	
    			final int noteValue = (note.getValue() + ((InstrumentString)track.getStrings().get(note.getString() - 1)).getValue());
    			final int channel = (note.getEffect().hasEffects())?track.getChannel().getEffectChannel():track.getChannel().getChannel();
    			new Thread(new Runnable() {		
    				public void run() {
    					try {								
    						channels[channel].controlChange(DefinedControllers.VOLUME,127);
    						channels[channel].controlChange(DefinedControllers.BALANCE,64);					
    						channels[channel].programChange(track.getChannel().getInstrument());					
    						channels[channel].noteOn(noteValue,64);		
									
    						Thread.sleep(750);
									
    						channels[channel].noteOff(noteValue,32);		
    					} catch (InterruptedException e) {					
    						e.printStackTrace();
    					}
    				}		
    			}).start();
    		}					
		} catch (MidiUnavailableException e) {
			e.printStackTrace();
		} 
    }
    
    
    public void write(OutputStream out){
    	try {
    		SongSequence songSequence = new SongSequence(songManager);
    		songSequence.createSongSecuence(false,false);               
    		int type = ((songManager.countTracks() > 1)?1:0);
    		
			MidiSystem.write(songSequence.getSongSecuence(),type,out);
		} catch (IOException e) {		
			e.printStackTrace();
		}
    }
}