/*
 * Created on 08-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.io.tg.old;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.NoteEffect;
import org.herac.tuxguitar.song.models.Silence;
import org.herac.tuxguitar.song.models.Song;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;
import org.herac.tuxguitar.song.models.Tupleto;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class TGLoader {

    public static Song openSong(String fileName) {
        File file = new File(fileName);
        Document doc = getDocument(file);
        return readSong(doc.getFirstChild());
    }    

    
    
    private static Document getDocument(File file) {
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(file);
        } catch (SAXException sxe) {
            sxe.printStackTrace();
        } catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        } catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return document;
    }    
    
    
    private static Song readSong(Node node) {
        List tracks = new ArrayList();
        String name = "";

        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); i++) {
            Node child = nodeList.item(i);
            String nodeName = child.getNodeName();

            if (nodeName.equals(TGFormat.PARAM_NAME)) {
                name = readValue(child);
            } else if (nodeName.equals(TGFormat.MODEL_TRACK)) {
                tracks.add(readTrack(child));
            }

        }

        return new Song(name,"","","", tracks,Song.MAX_VOLUME);
    }

    private static SongTrack readTrack(Node node) {
        List measures = new ArrayList();
        List strings = new ArrayList();
        int channel = 0;
        int instrument = 0;

        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); i++) {
            Node child = nodeList.item(i);
            String nodeName = child.getNodeName();

            if (nodeName.equals(TGFormat.PARAM_CHANNEL)) {
                channel = Integer.parseInt(readValue(child));
            } else if (nodeName.equals(TGFormat.PARAM_INSTRUMENT)) {
                instrument = Integer.parseInt(readValue(child));
            } else if (nodeName.equals(TGFormat.MODEL_MEASURE)) {
                measures.add(readMeasure(child));
            } else if (nodeName.equals(TGFormat.MODEL_INSTRUMENTSTRING)) {
                strings.add(readInstrumentString(child));
            }
        }

        return new SongTrack(0,"",null, measures, strings,null);
    }

    private static Measure readMeasure(Node node) {
        List notes = new ArrayList();
        List silences = new ArrayList();
        TimeSignature timeSignature = null;
        Tempo tempo = null;
        long start = 0;
        boolean repeatStart = false;
        int numberOfRepetitions = 0;
        
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); i++) {
            Node child = nodeList.item(i);
            String nodeName = child.getNodeName();

            if (nodeName.equals(TGFormat.PARAM_START)) {
                start = Long.parseLong(readValue(child));
            }else if (nodeName.equals(TGFormat.PARAM_REPEATSTART)) {
                repeatStart = Boolean.valueOf(readValue(child)).booleanValue();
            }else if (nodeName.equals(TGFormat.PARAM_NUMBEROFREPETITIONS)) {
                numberOfRepetitions = Integer.parseInt(readValue(child));
            } else if (nodeName.equals(TGFormat.MODEL_NOTE)) {
                notes.add(readNote(child));
            } else if (nodeName.equals(TGFormat.MODEL_SILENCE)) {
                silences.add(readSilence(child));
            } else if (nodeName.equals(TGFormat.MODEL_TIMESIGNATURE)) {
                timeSignature = readTimeSignature(child);
            } else if (nodeName.equals(TGFormat.MODEL_TEMPO)) {
                tempo = readTempo(child);
            }
        }

        return new Measure(0,start, notes, silences, timeSignature, tempo,1,0,repeatStart,numberOfRepetitions);
    }

    private static Note readNote(Node node) {
        int value = 0;
        long start = 0;
        Duration duration = null;
        int velocity = 0;
        InstrumentString string = null;
        boolean tiedNote = false;

        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); i++) {
            Node child = nodeList.item(i);
            String nodeName = child.getNodeName();

            if (nodeName.equals(TGFormat.PARAM_VALUE)) {
                value = Integer.parseInt(readValue(child));
            } else if (nodeName.equals(TGFormat.PARAM_START)) {
                start = Long.parseLong(readValue(child));
            } else if (nodeName.equals(TGFormat.PARAM_VELOCITY)) {
                velocity = Integer.parseInt(readValue(child));
            } else if (nodeName.equals(TGFormat.PARAM_TIEDNOTE)) {
                tiedNote = Boolean.valueOf(readValue(child)).booleanValue();
            } else if (nodeName.equals(TGFormat.MODEL_DURATION)) {
                duration = readDuration(child);
            } else if (nodeName.equals(TGFormat.MODEL_INSTRUMENTSTRING)) {
                string = readInstrumentString(child);
            }
        }

        return new Note(value, start, duration, velocity, string.getNumber(),tiedNote,new NoteEffect());
    }

    private static Silence readSilence(Node node) {
        long start = 0;
        Duration duration = null;

        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); i++) {
            Node child = nodeList.item(i);
            String nodeName = child.getNodeName();

            if (nodeName.equals(TGFormat.PARAM_START)) {
                start = Long.parseLong(readValue(child));
            } else if (nodeName.equals(TGFormat.MODEL_DURATION)) {
                duration = readDuration(child);
            }
        }

        return new Silence(start, duration);
    }

    private static InstrumentString readInstrumentString(Node node) {
        int number = 0;
        int value = 0;

        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); i++) {
            Node child = nodeList.item(i);
            String nodeName = child.getNodeName();

            if (nodeName.equals(TGFormat.PARAM_NUMBER)) {
                number = Integer.parseInt(readValue(child));
            } else if (nodeName.equals(TGFormat.PARAM_VALUE)) {
                value = Integer.parseInt(readValue(child));
            }

        }
        return new InstrumentString(number, value);
    }

    private static Tempo readTempo(Node node) {
        int value = 0;

        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); i++) {
            Node child = nodeList.item(i);
            String nodeName = child.getNodeName();

            if (nodeName.equals(TGFormat.PARAM_VALUE)) {
                value = Integer.parseInt(readValue(child));
            }

        }
        return new Tempo(value);
    }

    private static TimeSignature readTimeSignature(Node node) {
        Duration denominator = null;
        int numerator = 0;

        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); i++) {
            Node child = nodeList.item(i);
            String nodeName = child.getNodeName();

            if (nodeName.equals(TGFormat.PARAM_NUMERATOR)) {
                numerator = Integer.parseInt(readValue(child));
            } else if (nodeName.equals(TGFormat.MODEL_DURATION)) {
                denominator = readDuration(child);
            }

        }
        return new TimeSignature(numerator, denominator);
    }

    private static Duration readDuration(Node node) {
        int value = 0;
        boolean dotted = false;
        Tupleto tupleto = null;

        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); i++) {
            Node child = nodeList.item(i);
            String nodeName = child.getNodeName();

            if (nodeName.equals(TGFormat.PARAM_VALUE)) {
                value = Integer.parseInt(readValue(child));
            } else if (nodeName.equals(TGFormat.PARAM_DOTTED)) {
                dotted = Boolean.valueOf(readValue(child)).booleanValue();
            } else if (nodeName.equals(TGFormat.MODEL_TUPLETO)) {
                tupleto = readTupleto(child);
            }

        }
        return new Duration(value, dotted,false, tupleto);
    }

    private static Tupleto readTupleto(Node node) {
        int enters = 0;
        int times = 0;

        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); i++) {
            Node child = nodeList.item(i);
            String nodeName = child.getNodeName();

            if (nodeName.equals(TGFormat.PARAM_ENTERS)) {
                enters = Integer.parseInt(readValue(child));
            } else if (nodeName.equals(TGFormat.PARAM_TIMES)) {
                times = Integer.parseInt(readValue(child));
            }

        }
        return new Tupleto(enters, times);
    }

    private static String readValue(Node node) {
        Node child = node.getFirstChild();
        return child.getNodeValue();
    }

}