/*
 * Created on 19-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.io;

import java.io.IOException;

import org.herac.tuxguitar.io.gp.GP3InputStream;
import org.herac.tuxguitar.io.gp.GP4InputStream;
import org.herac.tuxguitar.io.gp.GP5InputStream;
import org.herac.tuxguitar.io.gp.GPFormatException;
import org.herac.tuxguitar.io.tg.TGInputStream;
import org.herac.tuxguitar.song.models.Song;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class SongLoader {    
    private String fileName;
    
    public SongLoader(String fileName){
        this.fileName = fileName;
    }

    public Song load() throws GPFormatException, IOException{
        Song song = null;
        
        //TuxGuitar Format
        TGInputStream tg = new TGInputStream(this.fileName);
        if(tg.isSupportedVersion()){
        	return tg.read();
        }
        //Guitar Pro 3 Format
        GP3InputStream gp3 = new GP3InputStream(this.fileName);
        if(gp3.isSupportedVersion()){
        	return gp3.readSong();
        }
        //Guitar Pro 4 Format        
        GP4InputStream gp4 = new GP4InputStream(this.fileName);
        if(gp4.isSupportedVersion()){
        	return gp4.readSong();
        }        
        //Guitar Pro 5 Format        
        GP5InputStream gp5 = new GP5InputStream(this.fileName);
        if(gp5.isSupportedVersion()){
        	return gp5.readSong();
        }   
        return null;
    }    
    
}
