package org.herac.tuxguitar.gui.undo.undoables.track;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.SongTrack;

public class UndoableMoveTrackDown implements UndoableEdit{
	private int doAction;
	private UndoableCaretHelper undoCaret;
	private UndoableCaretHelper redoCaret;	
	private long trackNumber;
	
	private UndoableMoveTrackDown(){
		
	}
	
	public void redo() throws CannotRedoException {	
		if(!canRedo()){
			throw new CannotRedoException();
		}        
		SongManager manager = TuxGuitar.instance().getSongManager();
		manager.moveTrackDown(manager.getTrack(trackNumber - 1));
		TuxGuitar.instance().fireUpdate();
		TuxGuitar.instance().getMixer().update();		
		this.redoCaret.update();
		this.doAction = UNDO_ACTION;
	}

	public void undo() throws CannotUndoException {
		if(!canUndo()){
			throw new CannotUndoException();
		}
		SongManager manager = TuxGuitar.instance().getSongManager();
		manager.moveTrackUp(manager.getTrack(trackNumber));
		TuxGuitar.instance().fireUpdate();
		TuxGuitar.instance().getMixer().update();				
		this.undoCaret.update();
		this.doAction = REDO_ACTION;
	}

    public boolean canRedo() {
        return (doAction == REDO_ACTION);
    }

    public boolean canUndo() {
        return (doAction == UNDO_ACTION);
    }
   
    
    public static UndoableMoveTrackDown startUndo(){
    	UndoableMoveTrackDown undoable = new UndoableMoveTrackDown();	    	
    	undoable.doAction = UNDO_ACTION;
    	undoable.undoCaret = new UndoableCaretHelper();	
    	
    	return undoable;
    }
    
    public UndoableMoveTrackDown endUndo(SongTrack track){    
    	this.redoCaret = new UndoableCaretHelper();
    	this.trackNumber = track.getNumber();
    	
		return this;
    }
    
    
    private static Caret getCaret(){
    	return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }
    
}
