package org.herac.tuxguitar.gui.undo.undoables.measure;

import java.util.List;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.SongTrack;

public class UndoableRemoveMeasure implements UndoableEdit{
	private int doAction;
	private UndoableCaretHelper undoCaret;
	private UndoableCaretHelper redoCaret;
	private long p1;
	private long p2;	
	private List[] trackMeasures;

	
	public UndoableRemoveMeasure(long p1,long p2){
    	Caret caret = getCaret();    	    	
    	this.doAction = UNDO_ACTION;
    	this.undoCaret = new UndoableCaretHelper();
    	this.p1 = p1;
    	this.p2 = p2;
    	this.trackMeasures = TuxGuitar.instance().getSongManager().copyMeasures(p1,p2);
	}
	
	public void redo() throws CannotRedoException {	
		if(!canRedo()){
			throw new CannotRedoException();
		}        
		TuxGuitar.instance().getSongManager().removeMeasures(this.p1,this.p2);    
		TuxGuitar.instance().fireUpdate();
		
		this.redoCaret.update();				
		this.doAction = UNDO_ACTION;
	}

	public void undo() throws CannotUndoException {
		if(!canUndo()){
			throw new CannotUndoException();
		}			
		int fromNumber = 0;
		SongManager manager = TuxGuitar.instance().getSongManager();
		Measure fromMeasure = manager.getTrackManager().getMeasureAt(manager.getFirstTrack(),this.p1);
		if(fromMeasure == null){
			fromNumber = manager.getTrackManager().getLastMeasure(manager.getFirstTrack()).getNumber() + 1;
		}else{
			fromNumber = fromMeasure.getNumber();
		}
		       
		for(int i = 0;i < trackMeasures.length;i++){ 
            List measures = manager.getTrackManager().getCloneMeasures(trackMeasures[i]);
            SongTrack track = manager.getTrack((i + 1));
            
            TuxGuitar.instance().getSongManager().getTrackManager().insertMeasures(track,measures,fromNumber);
        }

		TuxGuitar.instance().fireUpdate();
		this.undoCaret.update();
		
		this.doAction = REDO_ACTION;
	}

    public boolean canRedo() {
        return (doAction == REDO_ACTION);
    }

    public boolean canUndo() {
        return (doAction == UNDO_ACTION);
    }
      
    private static Caret getCaret(){
    	return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }  
    
    public UndoableRemoveMeasure endUndo(){
    	this.redoCaret = new UndoableCaretHelper();
    	return this;
    }

}
