package org.herac.tuxguitar.gui.undo.undoables.component;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.Measure;

public class UndoableComponentGeneric implements UndoableEdit{
	private int doAction;
	private long trackNumber;
	private UndoableCaretHelper undoCaret;
	private UndoableCaretHelper redoCaret;	
	private UndoComponent undoComponent;
	private RedoComponent redoComponent;
	
	private UndoableComponentGeneric(){
		
	}
	
	public void redo() throws CannotRedoException {	
		if(!canRedo()){
			throw new CannotRedoException();
		}        
		redoComponent.redo();
		this.redoCaret.update();
		this.doAction = UNDO_ACTION;
	}

	public void undo() throws CannotUndoException {
		if(!canUndo()){
			throw new CannotUndoException();
		}		        
		undoComponent.undo();		
		this.undoCaret.update();
		this.doAction = REDO_ACTION;
	}

    public boolean canRedo() {
        return (doAction == REDO_ACTION);
    }

    public boolean canUndo() {
        return (doAction == UNDO_ACTION);
    }
   
    
    public static UndoableComponentGeneric startUndo(){
    	UndoableComponentGeneric undoable = new UndoableComponentGeneric();
    	Caret caret = getCaret();    	    	
    	undoable.doAction = UNDO_ACTION;
    	undoable.trackNumber = caret.getSongTrackCoords().getTrack().getNumber();
    	undoable.undoCaret = new UndoableCaretHelper();
    	undoable.undoComponent = undoable.new UndoComponent(caret.getMeasureCoords().getMeasure(),caret.getDuration());	
    	
    	return undoable;
    }
    
    public UndoableComponentGeneric endUndo(){    
    	Caret caret = getCaret(); 
    	this.redoCaret = new UndoableCaretHelper();
		this.redoComponent = new RedoComponent(caret.getMeasureCoords().getMeasure(),caret.getDuration());	
		return this;
    }
    
    
    private static Caret getCaret(){
    	return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }
    
    private class UndoComponent{
    	private Measure measure;
    	private Duration caretDuration;
    	
    	public UndoComponent(Measure measure,Duration caretDuration){
    		if(measure != null){
    			this.measure = (Measure)measure.clone();
    			this.caretDuration = (Duration)caretDuration.clone();
    		}
    	}
    	
    	public void undo(){
    		SongTrackCoords track = getCaret().getSongCoords().getTrack(trackNumber);    
    		if(track != null && this.measure != null){
    			Measure measure = TuxGuitar.instance().getSongManager().getTrackManager().replaceMeasure(track.getTrack(),(Measure)this.measure.clone());
    			getCaret().setSelectedDuration((Duration)caretDuration.clone());
    			TuxGuitar.instance().getTablatureEditor().getTablature().getViewLayout().fireUpdate(measure.getNumber(),false);    			
    		}
    	}
    }
    
    private class RedoComponent{
    	private Measure measure;
    	private Duration caretDuration;
    	
    	public RedoComponent(Measure measure,Duration caretDuration){
    		if(measure != null){
    			this.measure = (Measure)measure.clone();    			
    		}
    		this.caretDuration = (Duration)caretDuration.clone();
    	}
    	public void redo(){
    		SongTrackCoords track = getCaret().getSongCoords().getTrack(trackNumber);    	
    		if(track != null && this.measure != null){
    			Measure measure = TuxGuitar.instance().getSongManager().getTrackManager().replaceMeasure(track.getTrack(),(Measure)this.measure.clone());
    			getCaret().setSelectedDuration((Duration)caretDuration.clone());
    			TuxGuitar.instance().getTablatureEditor().getTablature().getViewLayout().fireUpdate(measure.getNumber(),false);    				
    		}    		
    	}
    }
}
