package org.herac.tuxguitar.gui.undo.undoables;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.song.models.InstrumentString;

public class UndoableCaretHelper {
	private long track;
	private long position;
	private int string;
	
	public UndoableCaretHelper(){
		Caret caret = getCaret();
    	this.track = caret.getSongTrackCoords().getTrack().getNumber();
    	this.position = caret.getPosition();
    	this.string = 1;
    	InstrumentString instrumentString = caret.getSelectedString();
    	if(instrumentString != null){
    		this.string = instrumentString.getNumber();
		}
	}
	
	public void update(){
		getCaret().update(track,position,string);
	}	
	
    private static Caret getCaret(){
    	return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    } 
	
}
