/*
 * Created on 20-mar-2006
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.transport;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.player.PlaySongAction;
import org.herac.tuxguitar.gui.actions.player.StopSongAction;
import org.herac.tuxguitar.play.models.Player;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.SongTrack;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window -
 * Preferences - Java - Code Style - Code Templates
 */
public class SongTransport {
	public static final int STATUS_STOPED = 1;
	public static final int STATUS_PAUSED = 2;
	public static final int STATUS_RUNNING = 3;
	
	private Shell dialog;
	private Label label;
	private Scale tickScale;
	private ToolItem first;
	private ToolItem last;
	private ToolItem previous;
	private ToolItem next;
	private ToolItem stop;
	private ToolItem play;	
	private boolean editingTickScale;
	private int status;
	
	public SongTransport() {
	}
	
	public void show() {
		Shell shell = TuxGuitar.instance().getTablatureEditor().getTablature().getShell();
		this.dialog = new Shell(shell, SWT.DIALOG_TRIM);		
		this.dialog.setLayout(new GridLayout());
		this.init();
		this.dialog.pack();
		this.dialog.open();
		
		int x = shell.getBounds().x + (shell.getBounds().width - dialog.getSize().x) / 2;
		int y = shell.getBounds().y + (shell.getBounds().height - dialog.getSize().y) / 2;
		this.dialog.setLocation(x, y);
				
		TuxGuitar.instance().updateItems();
		while (!this.dialog.isDisposed()) {
			if (!this.dialog.getDisplay().readAndDispatch()) {
				this.dialog.getDisplay().sleep();
			}
		}		
		TuxGuitar.instance().updateItems();
		
	}
	
	private void init(){
		Composite composite = new Composite(this.dialog,SWT.BORDER);
		composite.setLayout(new GridLayout());
		composite.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));
		
		initLabel(composite);
		initScale(composite);
		initButtons(composite);
		
		this.updateItems();
		this.redraw();
	}

	private void initLabel(Composite parent){		
		this.label = new Label(parent,SWT.BORDER | SWT.RIGHT);
		this.label.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));	
		this.label.setBackground(parent.getDisplay().getSystemColor(SWT.COLOR_BLACK));
		this.label.setForeground(parent.getDisplay().getSystemColor(SWT.COLOR_BLUE));
		this.label.setFont(new Font(parent.getDisplay(),"Minisystem",36,SWT.NORMAL));
		
		
	}
	
	private void initScale(Composite parent){
		this.tickScale = new Scale(parent, SWT.HORIZONTAL);
		this.tickScale.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));	
		this.tickScale.setIncrement(1000);
		this.tickScale.setPageIncrement(1000);		
		this.tickScale.setSelection(1000);
		this.tickScale.addMouseListener(new MouseAdapter() {		
			public void mouseDown(MouseEvent e) {
				setEditingTickScale(true);
			}		
			public void mouseUp(MouseEvent e) {
				long position = tickScale.getSelection();
				SongTrack track = getSongManager().getFirstTrack();			
				gotoMeasure(getSongManager().getTrackManager().getMeasureAt(track,position));
				redraw();
				setEditingTickScale(false);
			}			
		});
	}
	
	private void initButtons(Composite parent){
		ToolBar toolBar = new ToolBar(this.dialog,SWT.NONE);
		toolBar.setLayout(new GridLayout(4,false));
		toolBar.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));	
		
		this.first = new ToolItem(toolBar,SWT.PUSH);
		this.first.setImage(SystemImages.TRANSPORT_FIRST_1);
		this.first.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				gotoFirst(e);
			}		
		});
		
		this.previous = new ToolItem(toolBar,SWT.PUSH);
		this.previous.setImage(SystemImages.TRANSPORT_PREVIOUS_1);
		this.previous.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				gotoPrevious(e);
			}		
		});

		this.stop = new ToolItem(toolBar,SWT.PUSH);
		this.stop.setImage(SystemImages.TRANSPORT_STOP_1);
		this.stop.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				stop(e);
			}		
		});				
		
		this.play = new ToolItem(toolBar,SWT.PUSH);
		this.play.setImage(SystemImages.TRANSPORT_PLAY_1);	
		this.play.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				play(e);
			}		
		});		
		
		this.next = new ToolItem(toolBar,SWT.PUSH);
		this.next.setImage(SystemImages.TRANSPORT_NEXT_1);
		this.next.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				gotoNext(e);
			}		
		});
		
		this.last = new ToolItem(toolBar,SWT.PUSH);
		this.last.setImage(SystemImages.TRANSPORT_LAST_1);
		this.last.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				gotoLast(e);
			}		
		});
				
		this.setStatus(STATUS_STOPED);		
	}

	
	
	public int getStatus() {
		return status;
	}

	public void setStatus(int status) {
		this.status = status;
	}

	public void redraw(){		
		if(!isDisposed()){			
			if(isEditingTickScale()){
				this.label.setText(Long.toString(this.tickScale.getSelection()));
			}else{
				long tickPosition = getSongManager().getPlayer().getTickPosition();
				this.label.setText(Long.toString(tickPosition));				
				this.tickScale.setSelection((int)tickPosition);
			}
		}
	}
	
	public void updateItems(){
		if(!isDisposed()){
			int lastStatus = getStatus();
			
			if(getSongManager().getPlayer().isRunning()){
				setStatus(STATUS_RUNNING);			
			}else if(getSongManager().getPlayer().isPaused()){
				setStatus(STATUS_PAUSED);
			}else{
				setStatus(STATUS_STOPED);
			}		
			
			if(lastStatus != getStatus()){
				if(getStatus() == STATUS_RUNNING){
					this.first.setImage(SystemImages.TRANSPORT_FIRST_2);
					this.last.setImage(SystemImages.TRANSPORT_LAST_2);
					this.previous.setImage(SystemImages.TRANSPORT_PREVIOUS_2);
					this.next.setImage(SystemImages.TRANSPORT_NEXT_2);
					this.stop.setImage(SystemImages.TRANSPORT_STOP_2);
					this.play.setImage(SystemImages.TRANSPORT_PAUSE);				
				}else if(getStatus() == STATUS_PAUSED){
					this.first.setImage(SystemImages.TRANSPORT_FIRST_2);
					this.last.setImage(SystemImages.TRANSPORT_LAST_2);
					this.previous.setImage(SystemImages.TRANSPORT_PREVIOUS_2);
					this.next.setImage(SystemImages.TRANSPORT_NEXT_2);
					this.stop.setImage(SystemImages.TRANSPORT_STOP_2);
					this.play.setImage(SystemImages.TRANSPORT_PLAY_2);	
					
				}else if(getStatus() == STATUS_STOPED){
					this.first.setImage(SystemImages.TRANSPORT_FIRST_1);
					this.last.setImage(SystemImages.TRANSPORT_LAST_1);
					this.previous.setImage(SystemImages.TRANSPORT_PREVIOUS_1);
					this.next.setImage(SystemImages.TRANSPORT_NEXT_1);
					this.stop.setImage(SystemImages.TRANSPORT_STOP_1);
					this.play.setImage(SystemImages.TRANSPORT_PLAY_1);
				}	
			}
			
			Measure first = getSongManager().getTrackManager().getFirstMeasure(getSongManager().getFirstTrack());
			Measure last = getSongManager().getTrackManager().getLastMeasure(getSongManager().getFirstTrack());
			this.tickScale.setMinimum((int)first.getStart());
			this.tickScale.setMaximum((int)(last.getStart() + last.getLength()));
			
			redraw();
		}		
	}
	
	
	
	public void loadProperties(){
		if(!isDisposed()){						
		}
	}	
	
	public void dispose() {
		this.dialog.dispose();
	}

	public boolean isDisposed() {
		return (this.dialog == null || this.dialog.isDisposed());
	}

	public boolean isEditingTickScale() {
		return editingTickScale;
	}

	public void setEditingTickScale(boolean editingTickScale) {
		this.editingTickScale = editingTickScale;
	}

	private SongManager getSongManager(){
		return TuxGuitar.instance().getSongManager();
	}
	
	public void gotoFirst(TypedEvent e){
		gotoMeasure(getSongManager().getTrackManager().getFirstMeasure(getSongManager().getFirstTrack()));
	}
	
	public void gotoLast(TypedEvent e){
		gotoMeasure(getSongManager().getTrackManager().getLastMeasure(getSongManager().getFirstTrack())) ;		
	}
	
	public void gotoNext(TypedEvent e){
		Player player = getSongManager().getPlayer();
		SongTrack track = getSongManager().getFirstTrack();
		Measure measure = getSongManager().getTrackManager().getMeasureAt(track,player.getTickPosition());
		if(measure != null){
			gotoMeasure(getSongManager().getTrackManager().getNextMeasure(track,measure));
		}
	}
	
	public void gotoPrevious(TypedEvent e){
		Player player = getSongManager().getPlayer();
		SongTrack track = getSongManager().getFirstTrack();
		Measure measure = getSongManager().getTrackManager().getMeasureAt(track,player.getTickPosition());
		if(measure != null){
			gotoMeasure(getSongManager().getTrackManager().getPrevMeasure(track,measure));
		}		
	}	
	
	public void gotoMeasure(Measure measure){
		if(measure != null){
			getSongManager().getPlayer().setTickPosition(measure.getStartWidthRepetitions(),measure.getStartWidthRepetitions() - measure.getStart());
			redraw();
		}		
	}
	
	public void play(TypedEvent e){
		TuxGuitar.instance().getAction(PlaySongAction.NAME).process(e);
	}
	
	public void stop(TypedEvent e){
		TuxGuitar.instance().getAction(StopSongAction.NAME).process(e);
	}	
}
