/*
 * Created on 04-ene-2006
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.tab.layout;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.printer.PrintDocument;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.tab.Tablature;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Note;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class PrinterViewLayout extends ViewLayout{
	protected static final int BOTTON_SPAN = 100;
	
	protected static final int DEFAULT_LINEAR_SPAN = 120;
	
	protected static final int DEFAULT_STRING_SPAN = 10;
	
	protected static final int DEFAULT_TRACK_SPAN = 100;
	
	protected static Font FONT_NOTE = new Font(TuxGuitar.instance().getDisplay(),"Sans",7, SWT.NORMAL);
	protected static Font FONT_PAGE_NUMBER = new Font(TuxGuitar.instance().getDisplay(),"Sans",8, SWT.NORMAL);
	
	private PrintDocument document;
    private Image page;
    private int divisionCount;
    
    public PrinterViewLayout(Tablature tablature,SongManager songManager,boolean multitrack,boolean scoreEnabled){
        super(tablature,songManager,multitrack,scoreEnabled);
    }
    
    public PrintDocument makeDocument(){ 
    	return makeDocument(new Rectangle(0,0,455,650));
    }
    
    public PrintDocument makeDocument(Rectangle size){    	
    	//-------init document-------------------------------------------------------
    	this.document = new PrintDocument();
    	this.document.setPageSize(size);
    	//-------draw the image------------------------------------------------------
    	this.page = new Image(getTablature().getDisplay(),this.document.getPageSize());
    	GC gc = new GC(this.page);
    	paintHeader(gc);
    	paintSong(gc,0,getStartPosY());
    	gc.dispose();
    	
    	return this.document;
    }
    
    private void makePage(GC gc){
    	String pageNumber = Integer.toString(this.document.count() + 1);
    	setPageNumberStyle(gc);
    	gc.drawString(pageNumber,getRight(gc,pageNumber),this.document.getPageSize().height - (BOTTON_SPAN - 30));
    	
    	this.document.makePage(this.page.getImageData());
    	gc.fillRectangle(this.document.getPageSize());
    }
    
    public void paintHeader(GC gc){
    	String songName = getSongManager().getSong().getName();
    	String songAuthor = getSongManager().getSong().getAuthor();
    	String trackName = "(" + getTablature().getCaret().getSongTrackCoords().getTrack().getName() + ")";
    	
    	if(songName == null || songName.length() == 0){
    		songName = TuxGuitar.getProperty("print-header.default-song-name");
    	}
    	if(songAuthor == null || songAuthor.length() == 0){
    		songAuthor = TuxGuitar.getProperty("print-header.default-song-author");
    	}
    	Font songNameFont = new Font(getTablature().getDisplay(),"Sans",16, SWT.BOLD | SWT.CENTER);
    	Font trackNameFont = new Font(getTablature().getDisplay(),"Sans",8, SWT.BOLD | SWT.CENTER);
    	Font songAuthorFont = new Font(getTablature().getDisplay(),"Sans",8, SWT.BOLD | SWT.CENTER);
    		
    	gc.setFont(songNameFont);  
    	gc.drawString(songName,getCenter(gc,songName),0);
    	gc.setFont(trackNameFont);
    	gc.drawString(trackName,getCenter(gc,trackName),30);
    	gc.setFont(songAuthorFont);
    	gc.drawString(songAuthor,getRight(gc,songAuthor),50);
    	
    	songNameFont.dispose();
    	trackNameFont.dispose();
    	songAuthorFont.dispose();
    	
    	setDefaultStyle(gc);
    }
    
    private int getCenter(GC gc,String text){
    	int textWidth = gc.stringExtent(text).x;
    	return ((getMaxWidth() - textWidth) / 2);
    }

    private int getRight(GC gc,String text){
    	int textWidth = gc.stringExtent(text).x;
    	return ((getMaxWidth() - textWidth));
    }
    
    public void paintSong(GC gc,Rectangle clientArea,int fromX,int fromY){
    	
    }
    
    public void paintSong(GC gc,int fromX,int fromY){ 
        List tracksCoords = new ArrayList();
        tracksCoords.add(getTablature().getCaret().getSongTrackCoords());
        paintTracks(tracksCoords,gc,null,fromX,fromY);        
    }
    
    public void paintTracks(List tracksCoords,GC gc,Rectangle clientArea,int fromX,int fromY) {               
        int posY = fromY + getDefaultFirstTrackSpan();
        for (int trackIdx = 0; trackIdx < tracksCoords.size(); trackIdx++) {
            SongTrackCoords trackCoords = (SongTrackCoords) tracksCoords.get(trackIdx);
            
            clientArea = new Rectangle(fromX,posY,trackCoords.getWidth(),DEFAULT_TRACK_SPAN);
            trackCoords.paintTrack(this,gc,fromX, posY,clientArea);            
            posY += DEFAULT_TRACK_SPAN;            
        }                  
    }

    
    
    public void paintMeasures(SongTrackCoords trackCoords,List measuresCoords,GC gc,int fromX, int fromY,Rectangle clientArea) {  
        trackCoords.setPosY(fromY);
        int posX = 0 ;
        int posY = trackCoords.getPosY();
        int width = 0;
        int height = 0;
        this.divisionCount = 1;
        
        int tempWidth = 0;
        List tempMeasures = new ArrayList();
        for (int measureIdx = 0; measureIdx < measuresCoords.size(); measureIdx++) {            
            MeasureCoords measureCoords = (MeasureCoords) measuresCoords.get(measureIdx);                                                       
            measureCoords.calculateWidth();    
                        
            //verifico si tengo que bajar de linea
            if((tempWidth + measureCoords.getWidth()) >=  getMaxWidth() && !tempMeasures.isEmpty()){
                
                int measureSpan = 0;
                int diff = ( getMaxWidth() - tempWidth);
                if(diff != 0 && tempMeasures.size() > 0){
                    measureSpan = diff / tempMeasures.size();                    
                }                
                
                Iterator it = tempMeasures.iterator();
                while(it.hasNext()){
                    MeasureCoords currMeasureCoords = (MeasureCoords)it.next();
                                           
                    //asigno la posicion dentro del compas
                    currMeasureCoords.setPosX(posX);
                    currMeasureCoords.setPosY(posY);              
                    
                    //pinto el compas                    
                    clientArea = new Rectangle((posX + fromX),posY,currMeasureCoords.getWidth(),currMeasureCoords.getHeight());
                    paintMeasure(currMeasureCoords,gc,posX + fromX, posY,measureSpan,clientArea);
                                         
                    posX += currMeasureCoords.getWidth() + currMeasureCoords.getSpan();
                    
                    if(posX > width){
                        width = posX;
                    }                    
                                    
                }             
                //pinto las cuerdas
                paintStrings(trackCoords,gc,posY,posX);
                
                posX = 0;
                posY += (getLinearSpan());
                height += getLinearSpan();                                          
                tempWidth = 0;
                tempMeasures.clear();
                this.divisionCount ++;
                
                if((posY + getTrackHeight(trackCoords) + BOTTON_SPAN) > getMaxHeight()){
                	makePage(gc);
                	posY = getStartPosY();
                }
            }
            tempWidth +=  measureCoords.getWidth();       
            tempMeasures.add(measureCoords);

            
        }
        Iterator it = tempMeasures.iterator();
        while(it.hasNext()){
            MeasureCoords currMeasureCoords = (MeasureCoords)it.next();
                
            //asigno la posicion dentro del compas
            currMeasureCoords.setPosX(posX);
            currMeasureCoords.setPosY(posY);              
            
            //pinto el compas     
            clientArea = new Rectangle((posX + fromX),posY,currMeasureCoords.getWidth(),currMeasureCoords.getHeight());            
            paintMeasure(currMeasureCoords,gc,posX + fromX, posY,0,clientArea);
             
            
            posX += currMeasureCoords.getWidth() + currMeasureCoords.getSpan();
            
            if(posX > width){
                width = posX;
            }                    
        
        }                        
        //pinto las cuerdas
        paintStrings(trackCoords,gc,posY,posX);        
        
        makePage(gc);
        
        height += getLinearSpan();   
        
        setWidth(width);
        setHeight(height + DEFAULT_TRACK_SPAN + 100);
    }    
    
 
    
    public void paintStrings(SongTrackCoords trackCoords,GC gc,int posY,int width) {                
        int posX = 0;      
                
        Iterator it = trackCoords.getTrack().getStrings().iterator();
        while(it.hasNext()){
            InstrumentString string = (InstrumentString)it.next();                                       
            int stringSpan = string.getNumber() * getStringSpan();
            gc.drawLine(posX,(posY + stringSpan),(posX + width),(posY + stringSpan));                            
        }       
    }
        
    /**
     * Calcula el espacio minimo entre negras, dependiendo de la duracion de la nota 
     */
    public int getSpanForQuarter(Duration duration){        
        double span = ((double)Duration.QUARTER_TIME / (double)duration.getTime()) * getMinSpan(duration);
        return  (int)span;
    }       
    
    /**
     * Calcula el Espacio minimo que quedara entre nota y nota
     */
    private int getMinSpan(Duration duration){
        int minSpan = 0;
        switch(duration.getValue()){
        	case Duration.WHOLE:
        	    minSpan = 18;
        	    break;
        	case Duration.HALF:
        	    minSpan = 16;
        	    break;
        	case Duration.QUARTER:
        	    minSpan = 14;
        	    break;
        	case Duration.EIGHTH:
        	    minSpan = 12;
        	    break;       
        	default:
        	    minSpan = 12;
        	    break;
        }        
        return minSpan;        
    } 
    
    public SongTrackCoords getTrackAt(List tracksCoords,int y,int vScroll){
        if(!isMultitrack()){
            tracksCoords = new ArrayList();
            tracksCoords.add(getTablature().getCaret().getSongTrackCoords());
        }           
        SongTrackCoords trackCoords = null;    
        int linearSpan = getLinearSpan();
        for (int trackIdx = 0; trackIdx < tracksCoords.size(); trackIdx++) {
            SongTrackCoords track = (SongTrackCoords) tracksCoords.get(trackIdx);            
                          
            int trackHeight = track.getHeight();
            for(int i = 0;i<this.divisionCount;i++){
                int posY = track.getPosY() + (i * linearSpan);                
                if(y >= (posY - (DEFAULT_TRACK_SPAN / 2)) && y <= (posY + trackHeight + (DEFAULT_TRACK_SPAN / 2))){
                    trackCoords = track;
                }
                posY += linearSpan;
            }
                                    
        }     
        return trackCoords;
    }       
    
    
    
    
    public void followMeasure(MeasureCoords measure,boolean redraw){
        //getTablature().moveScrollVerticalTo(measure,ViewLayout.DEFAULT_FIRST_TRACK_SPAN,ViewLayout.DEFAULT_FIRST_TRACK_SPAN,redraw);
    }
    
    
    
    public boolean isCaretVisible(){
    	return false;
    }

    public boolean isPlayModeEnabled(){
    	return false;
    }
    
    public void setNoteStyle(GC gc){
    	gc.setFont(FONT_NOTE);    	
    }
    
    public void setPageNumberStyle(GC gc){
    	gc.setFont(FONT_PAGE_NUMBER);    	
    }
    
    public Point getNoteOrientation(GC gc,int x,int y,Note note){
    	Point point = new Point(x,y);
    	point.y -= 5;
    	point.x -= 2;
    	if (!note.getEffect().isDeadNote() && note.getValue() > 9) {
        	point.x -= 3;
        }     	
        return point;
    }
    
    private int getTrackHeight(SongTrackCoords track){
    	return ((track.getTrack().getStrings().size() * DEFAULT_STRING_SPAN) + 20);
    }
    
    private int getLinearSpan(){
        int linearSpan = DEFAULT_LINEAR_SPAN;
        if(isMultiTrack()){
            linearSpan = linearSpan * getTrackCount();
        }
        return linearSpan;
    }
    
    public int getStartPosY(){
    	return getDefaultFirstTrackSpan();
    }
   
    public int getMaxWidth(){
        return (this.document.getPageSize().width) - 10;
    }
    
    public int getMaxHeight(){
        return this.document.getPageSize().height;
    }    

    public int getStringSpan(){
    	return DEFAULT_STRING_SPAN;
    }
    
    public static void disposeFonts(){
    	FONT_NOTE.dispose();
    	FONT_PAGE_NUMBER.dispose();
    }
}
