/*
 * Created on 04-ene-2006
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.tab.layout;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.tab.Tablature;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.InstrumentString;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class PageViewLayout extends ViewLayout{
    private int displayWidth;
    private int divisionCount;
    
    public PageViewLayout(Tablature tablature,SongManager songManager,boolean multitrack,boolean scoreEnabled){
        super(tablature,songManager,multitrack,scoreEnabled);
        this.displayWidth = getTablature().getDisplay().getBounds().width - 35;
    }
    
    
    public void paintSong(GC gc,Rectangle clientArea,int fromX,int fromY){ 
        if(isMultitrack()){
            paintTracks(getTablature().getCaret().getSongCoords().getTrackCoords(),gc,clientArea,fromX,fromY);
        }else{
            List tracksCoords = new ArrayList();
            tracksCoords.add(getTablature().getCaret().getSongTrackCoords());
            paintTracks(tracksCoords,gc,clientArea,fromX,fromY);
        }
    }
    
    public void paintTracks(List tracksCoords,GC gc,Rectangle clientArea,int fromX,int fromY) {               
        int posY = fromY + getDefaultFirstTrackSpan();
        for (int trackIdx = 0; trackIdx < tracksCoords.size(); trackIdx++) {
            SongTrackCoords trackCoords = (SongTrackCoords) tracksCoords.get(trackIdx);
            
            trackCoords.paintTrack(this,gc,fromX, posY,clientArea);  
            if(isScoreEnabled()){
            	posY += getScoreSpan();
            }
            posY += DEFAULT_TRACK_SPAN;
        }                  
    }

    
    
    public void paintMeasures(SongTrackCoords trackCoords,List measuresCoords,GC gc,int fromX, int fromY,Rectangle clientArea) {  
        trackCoords.setPosY(fromY);        
        int posX = trackCoords.getPosX();
        int posY = trackCoords.getPosY();
        int width = 0;
        int height = 0;
        this.divisionCount = 1;
        
        int tempWidth = SongTrackCoords.DEFAULT_HORIZONTAL_SPAN;
        List tempMeasures = new ArrayList();
        for (int measureIdx = 0; measureIdx < measuresCoords.size(); measureIdx++) {        	        	
            MeasureCoords measureCoords = (MeasureCoords) measuresCoords.get(measureIdx);                                            
            measureCoords.calculateWidth();    
            
            //verifico si esta en el area de cliente
            boolean isAtX = ((posX + fromX) > clientArea.x - 1500 && (posX + fromX) < clientArea.x + clientArea.width + 100);
            boolean isAtY = (posY > clientArea.y - DEFAULT_TRACK_SPAN && posY < clientArea.y + clientArea.height + DEFAULT_TRACK_SPAN);            
            
            //verifico si tengo que bajar de linea
            if((tempWidth + measureCoords.getWidth()) >=  getMaxWidth() && !tempMeasures.isEmpty()){
                int measureSpan = 0;
                int diff = ( getMaxWidth() - tempWidth);
                if(diff != 0 && tempMeasures.size() > 0){
                    measureSpan = diff / tempMeasures.size();                    
                }
                
                Iterator it = tempMeasures.iterator();
                while(it.hasNext()){
                    MeasureCoords currMeasureCoords = (MeasureCoords)it.next();
                        
                    //asigno la posicion dentro del compas
                    currMeasureCoords.setPosX(posX);
                    currMeasureCoords.setPosY(posY);              

                    if(isAtX && isAtY){
                        paintMeasure(currMeasureCoords,gc,posX + fromX, posY,measureSpan,clientArea);
                    }else{
                    	currMeasureCoords.setOutOfBounds(true);
                    }                    
                    posX += currMeasureCoords.getWidth() + currMeasureCoords.getSpan();
                    
                    if(posX > width){
                        width = posX;
                    }                                                        
                }                
                //pinto las cuerdas
                if(isAtX && isAtY){
                	paintStrings(trackCoords,gc,fromX,posY,posX);
                }
                posX = trackCoords.getPosX();
                posY += (getLinearSpan());
                height += getLinearSpan();                                          
                tempWidth = SongTrackCoords.DEFAULT_HORIZONTAL_SPAN;
                tempMeasures.clear();
                this.divisionCount ++;                
            }
            tempWidth +=  measureCoords.getWidth();      
            measureCoords.setFirstOfLine(tempMeasures.isEmpty());
            tempMeasures.add(measureCoords);           
        }        
        //Solo pinto lo que entre en pantalla
        boolean isAtX = ((posX + fromX) > clientArea.x - 1500 && (posX + fromX) < clientArea.x + clientArea.width + 100);
        boolean isAtY = (posY > clientArea.y - DEFAULT_TRACK_SPAN && posY < clientArea.y + clientArea.height + DEFAULT_TRACK_SPAN);
        
        Iterator it = tempMeasures.iterator();
        while(it.hasNext()){
            MeasureCoords currMeasureCoords = (MeasureCoords)it.next();
                
            //asigno la posicion dentro del compas
            currMeasureCoords.setPosX(posX);
            currMeasureCoords.setPosY(posY);                          
            
            if(isAtX && isAtY){
                paintMeasure(currMeasureCoords,gc,posX + fromX, posY,0,clientArea);
            }
            
            posX += currMeasureCoords.getWidth() + currMeasureCoords.getSpan();
            
            if(posX > width){
                width = posX;
            }                            
        }        
        //pinto las cuerdas
        if(isAtX && isAtY){
        	int stringWidth = (getMaxWidth() - 15);
        	stringWidth = (posX > (stringWidth - 20))?posX:stringWidth;
        	paintStrings(trackCoords,gc,fromX,posY,stringWidth);
        }
        height += getLinearSpan();   
        
        setWidth(width);
        setHeight(height + DEFAULT_TRACK_SPAN + 100);
    }    
 
    
    public void paintStrings(SongTrackCoords trackCoords,GC gc,int fromX,int posY,int width) {     
    	int posX = trackCoords.getPosX();
    	
        if(isScoreEnabled()){
        	int y = 0;
        	for(int i = 1;i <= 5;i ++){
        		y = (posY + (i * getScoreLineSpan()));
        		gc.drawLine((fromX + posX),y,(fromX + width),y); 
        	}        	
        	posY += getScoreSpan();
        }    	
    	
        Iterator it = trackCoords.getTrack().getStrings().iterator();
        while(it.hasNext()){
            InstrumentString string = (InstrumentString)it.next();                                    
            int stringSpan = string.getNumber() * getStringSpan();
            gc.drawLine((fromX + posX),(posY + stringSpan),(fromX + width),(posY + stringSpan));                            
        }       
    }
    
    public SongTrackCoords getTrackAt(List tracksCoords,int y,int vScroll){
        if(!isMultitrack()){
            tracksCoords = new ArrayList();
            tracksCoords.add(getTablature().getCaret().getSongTrackCoords());
        }           
        SongTrackCoords trackCoords = null;    
        int linearSpan = getLinearSpan();
            
        for (int trackIdx = 0; trackIdx < tracksCoords.size(); trackIdx++) {
            SongTrackCoords track = (SongTrackCoords) tracksCoords.get(trackIdx);            
                          
            int trackHeight = track.getHeight();            
            for(int i = 0;i<this.divisionCount;i++){
                int posY = track.getPosY() + (i * linearSpan);                
                if(y >= (posY - (DEFAULT_TRACK_SPAN / 2)) && y <= (posY + trackHeight + (DEFAULT_TRACK_SPAN / 2))){
                    trackCoords = track;
                }
                posY += linearSpan;
            }
                                    
        }     
        return trackCoords;
    }       
    
    
    
    
    public void followMeasure(MeasureCoords measure,boolean redraw){
        getTablature().moveScrollVerticalTo(measure,getDefaultFirstTrackSpan(),getDefaultFirstTrackSpan() - measure.getHeight(),redraw);
    }
    
    
    
    
    private int getLinearSpan(){
        int linearSpan = 200;
        if(isScoreEnabled()){
        	linearSpan += getScoreSpan();
        }
        if(isMultiTrack()){
            linearSpan = linearSpan * getTrackCount();
        }
        return linearSpan;
    }
    
    
   
    public int getMaxWidth(){
        return displayWidth;
    }
    
    

    
    
}
