/*
 * Created on 04-ene-2006
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.tab.layout;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.tab.Tablature;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.InstrumentString;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class LinearViewLayout extends ViewLayout{

    public LinearViewLayout(Tablature tablature,SongManager songManager,boolean multitrack,boolean scoreEnabled){
        super(tablature,songManager,multitrack,scoreEnabled);
    }
    
    
    public void paintSong(GC gc,Rectangle clientArea,int fromX,int fromY){        
        if(isMultitrack()){
            paintTracks(getTablature().getCaret().getSongCoords().getTrackCoords(),gc,clientArea,fromX,fromY);
        }else{
            List tracksCoords = new ArrayList();
            tracksCoords.add(getTablature().getCaret().getSongTrackCoords());
            paintTracks(tracksCoords,gc,clientArea,fromX,fromY);
        }
    }
    
    public void paintTracks(List tracksCoords,GC gc,Rectangle clientArea,int fromX,int fromY) {               
        int posY = fromY + getDefaultFirstTrackSpan();
        int height = 0;   
        for (int trackIdx = 0; trackIdx < tracksCoords.size(); trackIdx++) {
            SongTrackCoords trackCoords = (SongTrackCoords) tracksCoords.get(trackIdx);
            
            trackCoords.paintTrack(this,gc,fromX, posY,clientArea);
            paintStrings(trackCoords,gc,posY,clientArea);
            posY += DEFAULT_TRACK_SPAN;
            
        	if(isScoreEnabled()){
        		posY += getScoreSpan();
        		height += getScoreSpan();
        	}                 
            height += DEFAULT_TRACK_SPAN;   
        }                  
        setHeight(height + 100);
    }
    

    
    public void paintMeasures(SongTrackCoords trackCoords,List measuresCoords,GC gc,int fromX, int fromY,Rectangle clientArea) {        
        trackCoords.setPosY(fromY);
        int posX = trackCoords.getPosX();
        int posY = trackCoords.getPosY();
        int width = 0;
             
        for (int measureIdx = 0; measureIdx < measuresCoords.size(); measureIdx++) {            
            MeasureCoords measureCoords = (MeasureCoords) measuresCoords.get(measureIdx);            
                      
            //asigno la posicion dentro del compas
            measureCoords.setPosX(posX);
            measureCoords.setPosY(posY);            
            
                       
            //Solo pinto lo que entre en pantalla  
            boolean isAtX = ((posX + fromX + measureCoords.getWidth()) > clientArea.x - 100 && (posX + fromX) < clientArea.x + clientArea.width + measureCoords.getWidth() + 100);
            boolean isAtY = (posY +measureCoords.getHeight() > clientArea.y && posY < clientArea.y + clientArea.height + 80);
            if(isAtX && isAtY){
                paintMeasure(measureCoords,gc,posX + fromX, posY,0,clientArea);
            }
            posX += measureCoords.getWidth();       
            
            width = posX;
        }

        setWidth(width);
        
    }

    
    /**
     * Pinta las cuerdas
     */
    public void paintStrings(SongTrackCoords trackCoords,GC gc,int fromY,Rectangle clientArea) {
        int posX = SongTrackCoords.DEFAULT_HORIZONTAL_SPAN - getTablature().getHorizontalBar().getSelection();
        posX = (posX < 0)?0:posX;
        
        if(isScoreEnabled()){
        	for(int i = 1;i <= 5;i ++){
        		int posY = (fromY + (i * getScoreLineSpan()));
        		gc.drawLine(posX, posY, posX + clientArea.width,posY);
        	}
        	fromY += getScoreSpan();
        }
        
        Iterator it = trackCoords.getTrack().getStrings().iterator();
        while(it.hasNext()){
            InstrumentString string = (InstrumentString)it.next();
            int stringSpan = string.getNumber() * getStringSpan();
            gc.drawLine(posX, fromY + stringSpan, posX + clientArea.width, fromY + stringSpan);
        }       
    }    
    
    
    public void followMeasure(MeasureCoords measure,boolean redraw){
        getTablature().moveScrollHorizontalTo(measure,50,getTablature().getClientArea().width - 100,redraw);
    }
    
    
    public SongTrackCoords getTrackAt(List tracksCoords,int y,int vScroll){
        if(!isMultitrack()){
            tracksCoords = new ArrayList();
            tracksCoords.add(getTablature().getCaret().getSongTrackCoords());
        }        
        SongTrackCoords trackCoords = null;
        int posY = getDefaultFirstTrackSpan() + vScroll;        
        for (int trackIdx = 0; trackIdx < tracksCoords.size(); trackIdx++) {
            SongTrackCoords track = (SongTrackCoords) tracksCoords.get(trackIdx);            
            int trackWidth = track.getWidth();
            int trackHeight = track.getHeight();
            /*if(isScoreEnabled()){
            	trackHeight += getScoreSpan();
            }*/
            if(y >= posY && y <= posY + trackHeight){
                trackCoords = track;
            }            
            if(isScoreEnabled()){
            	posY += getScoreSpan();
            }            
            posY += DEFAULT_TRACK_SPAN;
        }     
        return trackCoords;
    }    
    
}
