/*
 * Created on 25-nov-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.tab;

import java.util.ArrayList;
import java.util.List;

import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.TimeSignature;
/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class TablatureUtil {
  
    /**
     * Calcula la posicion inicial de una nota, dependiendo de el span
     */
    public static final int getStartPosition(Measure measure,long start,int span){
        double newStart = (double)start - (double)measure.getStart();
        double displayPosition = 0.0;
        if(newStart > 0){
            double position = ((double)newStart / (double)Duration.QUARTER_TIME);               
            displayPosition = (position * span);
        }
        return (int)displayPosition;
    }
    

    
    public static List createDurations(long time){
        List durations = new ArrayList();
        Duration tempDuration = new Duration(Duration.WHOLE);
        tempDuration.setDotted(true);
        long tempTime = time;
        
        boolean finish = false;
        while(!finish){
            long currentDurationTime = tempDuration.getTime();
            if(currentDurationTime <= tempTime){
                durations.add((Duration)tempDuration.clone());
                tempTime -= currentDurationTime;
            }else{
                if(tempDuration.isDotted()){                
                    tempDuration.setDotted(false);
                }else{
                    tempDuration.setValue(tempDuration.getValue() * 2);
                    tempDuration.setDotted(true);
                }
            }
            if(tempDuration.getValue() > Duration.SIXTY_FOURTH){
                finish = true;
            }
        }
        return durations;        
    }    
    
    public static long getBeatLength(TimeSignature timeSignature){        
        long defaultLenght = Duration.QUARTER_TIME;
        
        int denominator = timeSignature.getDenominator().getValue();
        switch(denominator){
    		case Duration.EIGHTH:
    		    if(timeSignature.getNumerator() % 3 == 0){
    		        defaultLenght += Duration.QUARTER_TIME / 2;
    		    }
    		    break;
        }        
        
        return defaultLenght;
    }
}
