/*
 * Created on 01-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.tab;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.tab.layout.ViewLayout;
import org.herac.tuxguitar.song.models.Component;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.Silence;
/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class SilenceCoords implements MeasureComponent {
	private static final String ALTERNATIVE_SILENCE = "S";
    /**
     * Widget de la tablatura
     */
    private Tablature tablature;
    /**
     * Coordenadas del compas
     */
    private MeasureCoords meassureCoords;
    /**
     * Silencio de Referencia
     */    
    private Silence silence;
    /**
     * Imagen del Silencio
     */
    private Image image;
    /**
     * Posicion X dentro del compas
     */
    private int posX;
    /**
     * Posicion Y dentro del compas
     */
    private int posY;    
    /**
     * Coordenadas de los dibujos de las figuras
     */
    private DurationCoords durationCoords;
    /**
     * Ancho del silencio
     */
    private int height;
    
    
    private int span;
    
    private boolean shouldSetSpan;
    
    private int pointX;
    
    private int pointY;    
    
    public SilenceCoords(Tablature tablature, MeasureCoords meassureCoords,Silence silence, int posX) {
        this.tablature = tablature;
        this.meassureCoords = meassureCoords;
        this.silence = silence;
        this.posX = posX;
    }

    public void update() {
    	this.shouldSetSpan = true;
        if (getDuration() != null) {
        	this.image = SystemImages.getSilence(getDuration().getValue());        	
        	this.height = this.image.getImageData().height;        	
        }else{
        	this.height = 4;
        }
    }

    public void paint(ViewLayout layout,GC gc, int fromX, int fromY) {
        int x = 0;
        int y = 0;
        
        int centerY = 0;
        if(layout.isScoreEnabled()){
        	centerY = (((layout.getScoreLineSpan() * 5) / 2) - (height / 2));
            x = this.posX + fromX + getSpan() - 5;
            y = fromY + centerY;        	
        }else{        	
        	centerY =  (((this.meassureCoords.getHeight()) / 2) - (height / 2));
        	centerY += 6;        	
            x = this.posX + fromX + getSpan() - 10;
            y = fromY + centerY;        	
        }
        
        if (this.silence != null && this.image != null) {                        
            gc.drawImage(this.image, x, y);
            this.pointX = x + 10;
            
            if(this.silence.getDuration().isDotted() || this.silence.getDuration().isDoubleDotted()){
                gc.drawOval(x + 23,y + 15,1,1);
                if(this.silence.getDuration().isDoubleDotted()){
                    gc.drawOval(x + 26,y + 15,1,1);
                }
            }              
            if(!this.silence.getDuration().getTupleto().isEqual(Duration.NO_TUPLETO)){
            	if(layout.isScoreEnabled()){
            		gc.drawString(Integer.toString(this.silence.getDuration().getTupleto().getEnters()),x + 12,fromY + 95);
            	}else{
            		gc.drawString(Integer.toString(this.silence.getDuration().getTupleto().getEnters()),x + 12,y + 81);
            	}
            }            
        } else {
            x = this.posX + fromX + 3 + getSpan();
            y = fromY + centerY;
            gc.drawString(ALTERNATIVE_SILENCE, x, y);
        }
        
        if(layout.isPlayModeEnabled() && isPlaying()){
            gc.setForeground(this.tablature.getDisplay().getSystemColor(SWT.COLOR_RED));
            gc.drawString(">", this.posX + fromX + 3 + getSpan(),fromY +  this.meassureCoords.getHeight() + 50);  
            gc.setForeground(new Color(this.tablature.getDisplay(),0, 0, 0));
        }      
        this.posY = y;
    }

    
    private boolean isPlaying(){
        if(meassureCoords.getTrackCoords().hasCaret()  && meassureCoords.isPlaying()){
            long playerTickPosition = this.tablature.getSongManager().getPlayer().getTickPosition();
            if(playerTickPosition >= getSilence().getStart()  && playerTickPosition < getSilence().getStart() + getSilence().getDuration().getTime()){            
                return true;
            }
        }
        return false;
    }
    
    /**
     * Asigna la duracion del silencio
     */    
    public void setDuration(Duration duration){
        this.silence.setDuration(duration);
    }       
    
    public Duration getDuration() {
        return this.silence.getDuration();
    }

    /**
     * Asigna el start de el silencio
     */
    public void setStart(long start){
        this.silence.setStart(start);
    }    
    
    public long getStart() {
        return this.silence.getStart();
    }

    public Silence getSilence(){
        return this.silence;
    }
    
    public int getPosX(){
        return this.posX;
    }
    
    public int getPosY(){
        return this.posY;
    }    
    
    
    public int getSpan(){
    	if(this.shouldSetSpan){
    		this.span = meassureCoords.getSpanForComponent(this);
    		this.shouldSetSpan = false;    		
    	}
        return this.span;
    }
    
    public void setSpan(int span){
        this.span = span;
    }
    
    
    public int getPointX(){
        return this.pointX;
    }
    public int getPointY(){
        return this.pointY;
    }    
    
	public Component getComponent() {
		return getSilence();
	}
}