/*
 * Created on 26-nov-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.tab;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.tab.layout.ViewLayout;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.Silence;
import org.herac.tuxguitar.song.models.TimeSignature;
/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class MeasureCoords {
	
	public static final int SCORE_KEY_OFFSETS[] = new int[]{160,100,120,130};	
	
	private static final int SCORE_NATURAL_POSITIONS[] = new int[]{7,7,6,6,5,4,4,3,3,2,2,1};	
	//private static final int SCORE_FLAT_POSITIONS[] = new int[]{7,6,6,5,5,4,3,3,2,2,1,1};	
    /**
     * Espacio por defecto a la izquierda
     */
    public static final int DEFAULT_LEFT_SPAN = 15;
    /**
     * Espacio por defecto a la derecha
     */
    public static final int DEFAULT_RIGHT_SPAN = 15;    
    /**
     * Espacio por defecto del timeSignature
     */
    public static final int DEFAULT_TIME_SIGNATURE_SPAN = 40;
    /**
     * Espacio por defecto de la clave
     */
    public static final int DEFAULT_CLEF_SPAN = 40;        
    /**
     * Espacio por defecto entre negra y negra
     */
    public static final int DEFAULT_QUARTER_SPAN = 30;
    /**
     * Widget de la tablatura
     */    
    private Tablature tablature;    
    /**
     * Posicion X dentro del compas
     */
    private int posX;
    /** 
     * Posicion Y dentro del compas
     */
    private int posY;
    /**
     * Ultima Posicion X
     */
    private int lastFromX;
    /**
     * Ultima Posicion Y
     */
    private int lastFromY;
    /**
     * Ancho del Compas
     */
    private int width;
    /**
     * Alto del Compas
     */
    private int height;
    /**
     * Espacio entre negras
     */
    private int quarterSpan;
    /**
     * Espacio entre pulsos
     */        
    private long beatLength;
    /**
     * Boolean para saber si hay que pintar el TimeSignature
     */
    private boolean paintTimeSignature;
    /**
     * Boolean para saber si hay que pintar el Tempo
     */
    private boolean paintTempo;
    /**
     * Boolean para saber si hay que pintar la clave
     */
    private boolean paintClef = true;
    /**
     * Boolean para saber si hay que pintar el KeySignature
     */
    private boolean paintKeySignature = true;            
    /**
     * Coordenadas de notas
     */
    private List measureComponents;
    /**
     * Compas de Referencia
     */
    private Measure measure;
    /**
     * Compas anterior
     */
    private Measure prevMeasure;    
    /**
     * Pista de Referencia
     */
    private SongTrackCoords trackCoords;
    /**
     * Tema de Referencia
     */
    private SongManager songManager;    
    /**
     * Boolean para saber si el compas esta en el area de pantalla
     */
    private boolean outOfBounds;
    /**
     * Boolean para saber si el compas es el primero de la linea
     */    
    private boolean firstOfLine;
    /**
     * El caret para editar la tablatura
     */    
    private Caret caret;
    
    private int span;
       

    public MeasureCoords(SongManager songManager,Tablature tablature, Measure measure, SongTrackCoords trackCoords) {
        this.measure = measure;
        this.trackCoords = trackCoords;
        this.tablature = tablature;
        this.songManager = songManager;
        this.measureComponents = new ArrayList();
    }

    
    /**
     * Crea los valores necesarios
     */
    public void create(ViewLayout layout) {        
        this.measureComponents.clear();
        this.beatLength =  TablatureUtil.getBeatLength(getMeasure().getTimeSignature());
        autoCompleteSilences();        
        calculateQuarterSpan(layout);
    }    
    
    
    /**
     * Actualiza los valores para dibujar
     */
    public void update(ViewLayout layout) {        
        
    	orderNotes();
    	calculateMeasureChanges(layout);
        calculateWidth();
        calculateHeight(layout);
        calcuateComponents(layout);        
        updateComponents();        
        orderComponents();
    }

    /**
     * Calcula el espacio que debe haber entre negras
     */
    private void calculateQuarterSpan(ViewLayout layout) {        
        if (measure.getNotes().isEmpty() && measure.getSilences().isEmpty()) {
            this.quarterSpan = DEFAULT_QUARTER_SPAN;
        } else {
            Duration minDuration = null;
            if(!measure.getNotes().isEmpty()){
                Note minNote = null;
                for (int noteIdx = 0; noteIdx < measure.getNotes().size(); noteIdx++) {
                    Note currentNote = (Note) measure.getNotes().get(noteIdx);

                    if (minNote == null || currentNote.getDuration().getTime() <= minNote.getDuration().getTime()) {
                        minNote = currentNote;
                    }
                }
                minDuration = minNote.getDuration();
            }
            if(!measure.getSilences().isEmpty()){
                Silence minSilence = null;
                for (int silenceIdx = 0; silenceIdx < measure.getSilences().size(); silenceIdx++) {
                    Silence currentSilence = (Silence) measure.getSilences().get(silenceIdx);

                    if (minSilence == null || currentSilence.getDuration().getTime() <= minSilence.getDuration().getTime()) {
                        minSilence = currentSilence;
                    }
                }            
                
                if(minDuration == null || minSilence.getDuration().getTime() <= minDuration.getTime()){
                    minDuration = minSilence.getDuration();
                }
            }
            this.quarterSpan = layout.getSpanForQuarter(minDuration);
        }
    }

    
    /**
     * Calcula si debe pintar el TimeSignature
     */
    public void calculateMeasureChanges(ViewLayout layout) {
    	this.paintTempo = false;
    	this.paintClef = false;
    	this.paintKeySignature = false;
        this.paintTimeSignature = false;
                
        MeasureCoords prevMeasureCoords = this.trackCoords.getPrevMeasure(this);
        if(prevMeasureCoords != null){
        	this.prevMeasure = prevMeasureCoords.getMeasure(); 
        }
        if(this.prevMeasure == null){
        	this.paintTempo = true;    	
            this.paintTimeSignature = true;       
            if(layout.isScoreEnabled()){
            	this.paintClef = true;
            	this.paintKeySignature = true;                	
            }
        }else{
        	//Tempo
        	if(getMeasure().getTempo().getValue() != this.prevMeasure.getTempo().getValue()){
                this.paintTempo = true;
            }                    	     	
        	//Time Signature
            int thisNumerator = getMeasure().getTimeSignature().getNumerator();
            int thisValue = getMeasure().getTimeSignature().getDenominator().getValue();
            int prevNumerator = this.prevMeasure.getTimeSignature().getNumerator();
            int prevValue = this.prevMeasure.getTimeSignature().getDenominator().getValue();            
            if(thisNumerator != prevNumerator || thisValue != prevValue){
                this.paintTimeSignature = true;
            }            
            if(layout.isScoreEnabled()){
            	//Clef
            	if(getMeasure().getClef() != this.prevMeasure.getClef()){
            		this.paintClef = true;
            	}
            	//Key Signature
            	if(getMeasure().getKeySignature() != this.prevMeasure.getKeySignature()){
            		this.paintKeySignature = true;
            	}               
            }
        }
    }
    
    
    /**
     * Calcula si debe pintar el Tempo
     *//*
    private void calculateTempo() {    
        this.paintTempo = false;
        MeasureCoords prevMeasure = this.trackCoords.getPrevMeasure(this);
        if(prevMeasure == null){
            this.paintTempo = true;
        }else{         
            if(getMeasure().getTempo().getValue() != prevMeasure.getMeasure().getTempo().getValue()){
                this.paintTempo = true;
            }            
        }
    }    
    */
    /**
     * Calcula las coordenadas de los componentes
     */    
    private void calcuateComponents(ViewLayout layout){
        this.measureComponents.clear();
        calculateComponentsCoords(layout);
    }
    
    /**
     * Calcula las coordenadas de las notas y silencios
     */
    private void calculateComponentsCoords(ViewLayout layout) {
        int posX = 0;
        int posY = 0;        
        int span = getClefSpan() + getKeySignatureSpan() + getTimeSignatureSpan() + getTempoSpan();
        //---------------------------------Notas-------------------------------------
        for (int noteIdx = 0; noteIdx < measure.getNotes().size(); noteIdx++) {
            Note note = (Note) measure.getNotes().get(noteIdx);
            posY = note.getString() * layout.getStringSpan();
            posX = TablatureUtil.getStartPosition(measure, note.getStart(), this.quarterSpan) + 10;
            measureComponents.add(new NoteCoords(this.tablature,this.trackCoords,this, note, posX + span, posY));
        }
        //---------------------------------Silencios---------------------------------
        for (int silenceIdx = 0; silenceIdx < measure.getSilences().size(); silenceIdx++) {
            Silence silence = (Silence) measure.getSilences().get(silenceIdx);
            posX = TablatureUtil.getStartPosition(measure, silence.getStart(), this.quarterSpan) + 5;                        
            measureComponents.add(new SilenceCoords(this.tablature,this,silence,posX + span));
        }        
    }

    /**
     * Calcula si hay espacios libres. y crea nuevos silencios
     */   
    private void autoCompleteSilences(){   
    	songManager.getMeasureManager().autoCompleteSilences(measure);
    }    
    
    /**
     * Llama a update de todas las notas del compas
     */
    private void updateComponents() {
    	ScoreBeatHelper beatHelper = null;
    	NoteCoords prevNote = null;
    	
    	
        Iterator it = measureComponents.iterator();
        while (it.hasNext()) {
            MeasureComponent component = (MeasureComponent) it.next();            
            if(component instanceof NoteCoords){
            	NoteCoords note = (NoteCoords)component;            	
            	if(prevNote == null || !areInSameBeat(prevNote,component)){
            		beatHelper = new ScoreBeatHelper();
            	}            	
            	beatHelper.check(note,getMeasure().getClef());
            	note.setScoreBeatHelper(beatHelper);
            	prevNote = note;
            }
            component.update();
        }
    }
    
    /*
    private void updateComponents() {
        Iterator it = measureComponents.iterator();
        while (it.hasNext()) {
            MeasureComponent component = (MeasureComponent) it.next();
            component.update();
        }
    }
    */

    /**
     * Calcula el width del compas
     */
    public void calculateWidth() {                
        TimeSignature timeSignature = getMeasure().getTimeSignature();
        
        double quartersInSignature = ((1.00 / (double)timeSignature.getDenominator().getValue()) * 4.00) * (double)timeSignature.getNumerator();
        
        this.width = (int)((double)this.quarterSpan * quartersInSignature);
        
        this.width += getClefSpan();
        this.width += getKeySignatureSpan();
        this.width += getTimeSignatureSpan();
        this.width += getTempoSpan();
        
        this.width += DEFAULT_LEFT_SPAN;
        this.width += DEFAULT_RIGHT_SPAN;        
    }

    /**
     * Calcula el width del compas
     */
    public void calculateHeight(ViewLayout layout) {
    	this.height = (trackCoords.getTrack().getStrings().size() * layout.getStringSpan());
    	if(layout.isScoreEnabled()){
    		this.height += layout.getScoreSpan();
    	}
    }

    
    private void orderNotes(){
    	songManager.getMeasureManager().orderNotes(measure);
    }
       
    private void orderComponents(){
        for(int i = 0;i < measureComponents.size();i++){
            MeasureComponent minComponent = null;
            for(int j = i;j < measureComponents.size();j++){
                MeasureComponent component = (MeasureComponent)measureComponents.get(j);
                if(minComponent == null || component.getStart() < minComponent.getStart()){
                    minComponent = component;
                }
            }
            measureComponents.remove(minComponent);
            measureComponents.add(i,minComponent);
        }
    }    
    
    /**
     * Pinta el compas
     */
    public void paintMeasure(ViewLayout layout,GC gc, int fromX, int fromY,Rectangle clientArea,int span) {                
        setOutOfBounds(false);
    	paintTempo(layout,gc, fromX, fromY);
        paintTimeSignature(layout,gc, fromX, fromY);
        paintComponents(layout,gc, fromX, fromY,clientArea);
        paintDivisions(layout,gc, fromX, fromY);
        paintClef(layout,gc, fromX, fromY);
        paintKeySignature(layout,gc, fromX, fromY);
        paintCaret(layout,gc,fromX,fromY);
        paintPlayMode(layout,gc,fromX,fromY);
        this.lastFromX = fromX;
        this.lastFromY = fromY;        
    }
    
    public void paintMeasure(ViewLayout layout,GC gc, int fromX, int fromY,Rectangle clientArea) {
        paintMeasure(layout,gc,fromX,fromY,clientArea,0);
    }    

    /**
     * Pinta las notas
     */
    public void paintComponents(ViewLayout layout,GC gc, int fromX, int fromY,Rectangle clientArea) {             
        /*
    	if(layout.isScoreEnabled()){
        	for (int noteIdx = 0; noteIdx < measureComponents.size(); noteIdx++) {
            	MeasureComponent component = (MeasureComponent) measureComponents.get(noteIdx);                                     
            	component.setSpan(getSpanForComponent(component));                          
        	}
        }*/
    	for (int noteIdx = 0; noteIdx < measureComponents.size(); noteIdx++) {
            MeasureComponent component = (MeasureComponent) measureComponents.get(noteIdx);                         
          /*
            if(!layout.isScoreEnabled()){    
            	component.setSpan(getSpanForComponent(component));
            }*/
            component.paint(layout,gc, fromX + DEFAULT_LEFT_SPAN , fromY);            
        }
                
    }
    
    /**
     * Pinta las notas
     */
    public void paintCaret(ViewLayout layout,GC gc, int fromX, int fromY) {    	
    	if(layout.isCaretVisible() && hasCaret()){            
    		int span = DEFAULT_LEFT_SPAN + getClefSpan() + getKeySignatureSpan() + getTimeSignatureSpan() + getTempoSpan();
    		if(layout.isScoreEnabled()){
        		fromY += layout.getScoreSpan();
        	}        	        	
            caret.paintCaret(gc, fromX + span , fromY);
        }
    }    

    /**
     * Pinta las divisiones del compas
     */
    private void paintDivisions(ViewLayout layout,GC gc, int fromX, int fromY) {    	    	
    	//-----SCORE ------------------------------------//
    	if(layout.isScoreEnabled()){
        	int scoreY1 = fromY + layout.getScoreLineSpan();
            int scoreY2 = fromY + (layout.getScoreLineSpan() * 5);
            int offsetY = scoreY2;
            if(isFirstMeasure() || isFirstOfLine()){
            	offsetY = (scoreY1 + layout.getScoreSpan() + layout.getStringSpan());
            }
            
            //principio
            if(measure.isRepeatStart()){
                gc.setLineWidth(3);
                gc.drawLine(fromX, scoreY1, fromX, offsetY);
                
                gc.drawOval(fromX + 7, scoreY1 + ((scoreY2 - scoreY1) / 2) - 7,1,2);
                gc.drawOval(fromX + 7, scoreY1 + ((scoreY2 - scoreY1) / 2) + 7,1,2);
                
                gc.setLineWidth(1);
                gc.drawLine(fromX + 3, scoreY1, fromX + 3, offsetY);
            }else if(isFirstMeasure()){
                gc.setLineWidth(3);
                gc.drawLine(fromX, scoreY1, fromX, offsetY);                
                gc.setLineWidth(1);
                gc.drawLine(fromX + 3, scoreY1, fromX + 3, offsetY);            	
            	
                //gc.setLineWidth(3);
                //gc.drawLine(fromX, y1, fromX, (y1 + layout.getScoreSpan() + layout.getStringSpan()));    
                //gc.setLineWidth(1);
                //gc.drawLine(fromX + 3, y1, fromX + 3, (y1 + layout.getScoreSpan() + layout.getStringSpan()));            
        	}else{
                gc.drawLine(fromX, scoreY1, fromX, offsetY);
            }
            
            //fin
            if(measure.getNumberOfRepetitions() > 0){            
                gc.setLineWidth(3);
                gc.drawLine(fromX + getWidth() + getSpan(), scoreY1, fromX + getWidth() + getSpan(), scoreY2);            

                gc.drawOval(fromX + getWidth() -8 + getSpan(), scoreY1 + ((scoreY2 - scoreY1) / 2) - 7,2,2);
                gc.drawOval(fromX + getWidth() -8 + getSpan(), scoreY1 + ((scoreY2 - scoreY1) / 2) + 7,2,2);
                
                gc.setLineWidth(1);            
                gc.drawLine(fromX + getWidth() - 3 + getSpan(), scoreY1, fromX + getWidth() - 3 + getSpan(), scoreY2);
                
                gc.drawString("x" + Integer.toString(measure.getNumberOfRepetitions()),fromX + getWidth() - 10 + getSpan(),fromY - 5);
            }else if(isLastMeasure()){
                gc.setLineWidth(3);
                gc.drawLine(fromX + getWidth() + getSpan(), scoreY1, fromX + getWidth() + getSpan(), scoreY2);            
                gc.setLineWidth(1);            
                gc.drawLine(fromX + getWidth() - 3 + getSpan(), scoreY1, fromX + getWidth() - 3 + getSpan(), scoreY2);      
        	}else{        
                gc.drawLine(fromX + getWidth() + getSpan(), scoreY1, fromX + getWidth() + getSpan(), scoreY2);
            }    		
    		
    		
    		fromY += layout.getScoreSpan();
    	}       
    	//-----FIN SCORE ------------------------------------//
    	
    	int y1 = fromY + layout.getStringSpan();
        int y2 = fromY + (trackCoords.getTrack().getStrings().size() * layout.getStringSpan());
                
        //principio
        if(measure.isRepeatStart()){
            gc.setLineWidth(3);
            gc.drawLine(fromX, y1, fromX, y2);
            
            gc.drawOval(fromX + 7, y1 + ((y2 - y1) / 2) - 7,1,2);
            gc.drawOval(fromX + 7, y1 + ((y2 - y1) / 2) + 7,1,2);
            
            gc.setLineWidth(1);
            gc.drawLine(fromX + 3, y1, fromX + 3, y2);
        }else if(isFirstMeasure()){
            gc.setLineWidth(3);
            gc.drawLine(fromX, y1, fromX, y2);    
            gc.setLineWidth(1);
            gc.drawLine(fromX + 3, y1, fromX + 3, y2);            
    	}else{
            gc.drawLine(fromX, y1, fromX, y2);
        }
        
        //fin
        if(measure.getNumberOfRepetitions() > 0){            
            gc.setLineWidth(3);
            gc.drawLine(fromX + getWidth() + getSpan(), y1, fromX + getWidth() + getSpan(), y2);            

            gc.drawOval(fromX + getWidth() -8 + getSpan(), y1 + ((y2 - y1) / 2) - 7,2,2);
            gc.drawOval(fromX + getWidth() -8 + getSpan(), y1 + ((y2 - y1) / 2) + 7,2,2);
            
            gc.setLineWidth(1);            
            gc.drawLine(fromX + getWidth() - 3 + getSpan(), y1, fromX + getWidth() - 3 + getSpan(), y2);
            
            gc.drawString("x" + Integer.toString(measure.getNumberOfRepetitions()),fromX + getWidth() - 10 + getSpan(),fromY - 5);
        }else if(isLastMeasure()){
            gc.setLineWidth(3);
            gc.drawLine(fromX + getWidth() + getSpan(), y1, fromX + getWidth() + getSpan(), y2);            
            gc.setLineWidth(1);            
            gc.drawLine(fromX + getWidth() - 3 + getSpan(), y1, fromX + getWidth() - 3 + getSpan(), y2);      
    	}else{        
            gc.drawLine(fromX + getWidth() + getSpan(), y1, fromX + getWidth() + getSpan(), y2);
        }
        
    }

    
    /**
     * Pinta la Clave
     */
    private void paintClef(ViewLayout layout,GC gc, int fromX, int fromY) {    	    	
    	//-----SCORE ------------------------------------//
    	if(layout.isScoreEnabled() && this.paintClef){
        	if(measure.getClef() == Measure.CLEF_TREBLE){    		
        		gc.drawImage(SystemImages.CLEF_TREBLE,fromX + 14,fromY);
        	}
        	else if(measure.getClef() == Measure.CLEF_BASS){    		
        		gc.drawImage(SystemImages.CLEF_BASS,fromX + 14,fromY + 6);
        	}
        	else if(measure.getClef() == Measure.CLEF_TENOR){    		
        		gc.drawImage(SystemImages.CLEF_TENOR,fromX + 14,fromY - 2);
        	}        	
        	else if(measure.getClef() == Measure.CLEF_ALTO){    		
        		gc.drawImage(SystemImages.CLEF_ALTO,fromX + 14,fromY + 8);
        	}
    	}               
    }
    
    /**
     * Pinta la Armadura de Clave
     */
    private void paintKeySignature(ViewLayout layout,GC gc, int fromX, int fromY) {    	    	
    	fromX += getClefSpan();

    	if(layout.isScoreEnabled() && this.paintKeySignature){
    		int x = fromX + 10;
    		int scale = (layout.getScoreLineSpan() / 2);    		    		
    		int value = 0;
    		int scoreLineY = 0;
    		int minY = fromY - scale;
    		
    		int clefOffset = 0;
    		switch(measure.getClef()){
    		case Measure.CLEF_TREBLE:
    			clefOffset = (scale * 4) - 1;
    			break;
    		case Measure.CLEF_BASS:
    			clefOffset = (scale * 6) - 1;
    			break;
    		case Measure.CLEF_TENOR:
    			clefOffset = (scale * 3) - 1;
    			break;
    		case Measure.CLEF_ALTO:
    			clefOffset = (scale * 5) - 1;
    			break;    			
    		}
    		
    		//if(measure.getKeySignature() <= 7){
    			if(measure.getKeySignature() >= 1 && measure.getKeySignature() <= 7){
    				value = 17; //F
    				scoreLineY = fromY + ((SCORE_NATURAL_POSITIONS[value  % 12]) * scale - (7 * (value / 12)) * scale);
    				scoreLineY += clefOffset;
    				scoreLineY = (minY < scoreLineY + scale )?scoreLineY:(scoreLineY + (scale * 7));
    				x += 6;
    				gc.drawImage(SystemImages.KEY_SHARP,x ,scoreLineY);		
    			}else if(prevMeasure != null && prevMeasure.getKeySignature() >= 1 && prevMeasure.getKeySignature() <=7){
    				value = 17; //F
    				scoreLineY = fromY + ((SCORE_NATURAL_POSITIONS[value  % 12]) * scale - (7 * (value / 12)) * scale);
    				scoreLineY += clefOffset - 3;
    				scoreLineY = (minY < scoreLineY)?scoreLineY:(scoreLineY + (scale * 7));
    				x += 6;
    				gc.drawImage(SystemImages.KEY_NATURAL,x ,scoreLineY);		    				
    			}
    			
    			if(measure.getKeySignature() >= 2 && measure.getKeySignature() <= 7){
    				value = 12; //C
    				scoreLineY = fromY + ((SCORE_NATURAL_POSITIONS[value  % 12]) * scale - (7 * (value / 12)) * scale);
    				scoreLineY += clefOffset;
    				scoreLineY = (minY < scoreLineY)?scoreLineY:(scoreLineY + (scale * 7));
    				x += 6;
    				gc.drawImage(SystemImages.KEY_SHARP,x,scoreLineY);		
    			}else if(prevMeasure != null && prevMeasure.getKeySignature() >= 2 && prevMeasure.getKeySignature() <=7){
    				value = 12; //C
    				scoreLineY = fromY + ((SCORE_NATURAL_POSITIONS[value  % 12]) * scale - (7 * (value / 12)) * scale);
    				scoreLineY += clefOffset - 3;
    				scoreLineY = (minY < scoreLineY)?scoreLineY:(scoreLineY + (scale * 7));
    				x += 6;
    				gc.drawImage(SystemImages.KEY_NATURAL,x,scoreLineY);	    				
    			}  
    			
    			if(measure.getKeySignature() >= 3 && measure.getKeySignature() <= 7){
    				value = 19; //G
    				scoreLineY = fromY + ((SCORE_NATURAL_POSITIONS[value  % 12]) * scale - (7 * (value / 12)) * scale);
    				scoreLineY += clefOffset;
    				scoreLineY = (minY < scoreLineY)?scoreLineY:(scoreLineY + (scale * 7));
    				x += 6;
    				gc.drawImage(SystemImages.KEY_SHARP,x,scoreLineY);		
    			}else if(prevMeasure != null && prevMeasure.getKeySignature() >= 3 && prevMeasure.getKeySignature() <=7){
    				value = 19; //G
    				scoreLineY = fromY + ((SCORE_NATURAL_POSITIONS[value  % 12]) * scale - (7 * (value / 12)) * scale);
    				scoreLineY += clefOffset - 3;
    				scoreLineY = (minY < scoreLineY)?scoreLineY:(scoreLineY + (scale * 7));
    				x += 6;
    				gc.drawImage(SystemImages.KEY_NATURAL,x,scoreLineY);	   				
    			}    
    			
    			if(measure.getKeySignature() >= 4 && measure.getKeySignature() <= 7){
    				value = 14; //D
    				scoreLineY = fromY + ((SCORE_NATURAL_POSITIONS[value % 12]) * scale - (7 * (value / 12)) * scale);
    				scoreLineY += clefOffset;
    				scoreLineY = (minY < scoreLineY)?scoreLineY:(scoreLineY + (scale * 7));
    				x += 6;
    				gc.drawImage(SystemImages.KEY_SHARP,x,scoreLineY);		
    			}else if(prevMeasure != null && prevMeasure.getKeySignature() >= 4 && prevMeasure.getKeySignature() <=7){
    				value = 14; //D
    				scoreLineY = fromY + ((SCORE_NATURAL_POSITIONS[value % 12]) * scale - (7 * (value / 12)) * scale);
    				scoreLineY += clefOffset - 3;
    				scoreLineY = (minY < scoreLineY)?scoreLineY:(scoreLineY + (scale * 7));
    				x += 6;
    				gc.drawImage(SystemImages.KEY_NATURAL,x,scoreLineY);   				
    			}  
    			
    			if(measure.getKeySignature() >= 5 && measure.getKeySignature() <= 7){
    				value = 10; //A
    				scoreLineY = fromY + ((SCORE_NATURAL_POSITIONS[value % 12]) * scale - (7 * (value / 12)) * scale);
    				scoreLineY += clefOffset;
    				scoreLineY = (minY < scoreLineY)?scoreLineY:(scoreLineY + (scale * 7));
    				x += 6;
    				gc.drawImage(SystemImages.KEY_SHARP,x,scoreLineY);		
    			}else if(prevMeasure != null && prevMeasure.getKeySignature() >= 5 && prevMeasure.getKeySignature() <=7){
    				value = 10; //A
    				scoreLineY = fromY + ((SCORE_NATURAL_POSITIONS[value % 12]) * scale - (7 * (value / 12)) * scale);
    				scoreLineY += clefOffset - 3;
    				scoreLineY = (minY < scoreLineY)?scoreLineY:(scoreLineY + (scale * 7));
    				x += 6;
    				gc.drawImage(SystemImages.KEY_NATURAL,x,scoreLineY);				
    			}  
    			
    			if(measure.getKeySignature() >= 6 && measure.getKeySignature() <= 7){
    				value = 16; //E
    				scoreLineY = fromY + ((SCORE_NATURAL_POSITIONS[value % 12]) * scale - (7 * (value / 12)) * scale);
    				scoreLineY += clefOffset;
    				scoreLineY = (minY < scoreLineY)?scoreLineY:(scoreLineY + (scale * 7));
    				x += 6;
    				gc.drawImage(SystemImages.KEY_SHARP,x,scoreLineY);		
    			}else if(prevMeasure != null && prevMeasure.getKeySignature() >= 6 && prevMeasure.getKeySignature() <=7){
    				value = 16; //E
    				scoreLineY = fromY + ((SCORE_NATURAL_POSITIONS[value % 12]) * scale - (7 * (value / 12)) * scale);
    				scoreLineY += clefOffset - 3;
    				scoreLineY = (minY < scoreLineY)?scoreLineY:(scoreLineY + (scale * 7));
    				x += 6;
    				gc.drawImage(SystemImages.KEY_NATURAL,x,scoreLineY);					
    			}  
    			
    			if(measure.getKeySignature() >= 7 && measure.getKeySignature() <= 7){
    				value = 11; //B
    				scoreLineY = fromY + ((SCORE_NATURAL_POSITIONS[value % 12]) * scale - (7 * (value / 12)) * scale);
    				scoreLineY += clefOffset;
    				scoreLineY = (minY < scoreLineY)?scoreLineY:(scoreLineY + (scale * 7));
    				x += 6;
    				gc.drawImage(SystemImages.KEY_SHARP,x,scoreLineY);		
    			}else if(prevMeasure != null && prevMeasure.getKeySignature() >= 7 && prevMeasure.getKeySignature() <=7){
    				value = 11; //B
    				scoreLineY = fromY + ((SCORE_NATURAL_POSITIONS[value % 12]) * scale - (7 * (value / 12)) * scale);
    				scoreLineY += clefOffset - 3;
    				scoreLineY = (minY < scoreLineY)?scoreLineY:(scoreLineY + (scale * 7));
    				x += 6;
    				gc.drawImage(SystemImages.KEY_NATURAL,x,scoreLineY);					
    			}    	
    			
    		//}else{
    			if(measure.getKeySignature() >= 1 + 7){
    				value = 11; //B
    				scoreLineY = fromY + ((SCORE_NATURAL_POSITIONS[value  % 12]) * scale - (7 * (value / 12)) * scale);
    				scoreLineY += clefOffset;
    				scoreLineY = (minY < scoreLineY)?scoreLineY:(scoreLineY + (scale * 7));
    				x += 6;
    				gc.drawImage(SystemImages.KEY_FLAT,x ,scoreLineY);		
    			}else if(prevMeasure != null && prevMeasure.getKeySignature() >= 1 + 7){
    				value = 11; //B
    				scoreLineY = fromY + ((SCORE_NATURAL_POSITIONS[value  % 12]) * scale - (7 * (value / 12)) * scale);
    				scoreLineY += clefOffset - 3;
    				scoreLineY = (minY < scoreLineY)?scoreLineY:(scoreLineY + (scale * 7));
    				x += 6;
    				gc.drawImage(SystemImages.KEY_NATURAL,x ,scoreLineY);						
    			}    	
    			
    			if(measure.getKeySignature() >= 2 + 7){
    				value = 16; //E
    				scoreLineY = fromY + ((SCORE_NATURAL_POSITIONS[value  % 12]) * scale - (7 * (value / 12)) * scale);
    				scoreLineY += clefOffset;
    				scoreLineY = (minY < scoreLineY)?scoreLineY:(scoreLineY + (scale * 7));
    				x += 6;
    				gc.drawImage(SystemImages.KEY_FLAT,x,scoreLineY);		
    			}else if(prevMeasure != null && prevMeasure.getKeySignature() >= 2 + 7){
    				value = 16; //E
    				scoreLineY = fromY + ((SCORE_NATURAL_POSITIONS[value  % 12]) * scale - (7 * (value / 12)) * scale);
    				scoreLineY += clefOffset - 3;
    				scoreLineY = (minY < scoreLineY)?scoreLineY:(scoreLineY + (scale * 7));
    				x += 6;
    				gc.drawImage(SystemImages.KEY_NATURAL,x,scoreLineY);						
    			}       
    			
    			if(measure.getKeySignature() >= 3 + 7){
    				value = 10;//A
    				scoreLineY = fromY + ((SCORE_NATURAL_POSITIONS[value  % 12]) * scale - (7 * (value / 12)) * scale);
    				scoreLineY += clefOffset;
    				scoreLineY = (minY < scoreLineY)?scoreLineY:(scoreLineY + (scale * 7));
    				x += 6;
    				gc.drawImage(SystemImages.KEY_FLAT,x,scoreLineY);		
    			}else if(prevMeasure != null && prevMeasure.getKeySignature() >= 3 + 7){
    				value = 10;//A
    				scoreLineY = fromY + ((SCORE_NATURAL_POSITIONS[value  % 12]) * scale - (7 * (value / 12)) * scale);
    				scoreLineY += clefOffset - 3;
    				scoreLineY = (minY < scoreLineY)?scoreLineY:(scoreLineY + (scale * 7));
    				x += 6;
    				gc.drawImage(SystemImages.KEY_NATURAL,x,scoreLineY);								
    			}   
    			
    			if(measure.getKeySignature() >= 4 + 7){
    				value = 14; //D
    				scoreLineY = fromY + ((SCORE_NATURAL_POSITIONS[value % 12]) * scale - (7 * (value / 12)) * scale);
    				scoreLineY += clefOffset;
    				scoreLineY = (minY < scoreLineY)?scoreLineY:(scoreLineY + (scale * 7));
    				x += 6;
    				gc.drawImage(SystemImages.KEY_FLAT,x,scoreLineY);		
    			}else if(prevMeasure != null && prevMeasure.getKeySignature() >= 4 + 7){
    				value = 14; //D
    				scoreLineY = fromY + ((SCORE_NATURAL_POSITIONS[value % 12]) * scale - (7 * (value / 12)) * scale);
    				scoreLineY += clefOffset - 3;
    				scoreLineY = (minY < scoreLineY)?scoreLineY:(scoreLineY + (scale * 7));
    				x += 6;
    				gc.drawImage(SystemImages.KEY_NATURAL,x,scoreLineY);										
    			}    			
    			
    			if(measure.getKeySignature() >= 5 + 7){
    				value = 19; //G
    				scoreLineY = fromY + ((SCORE_NATURAL_POSITIONS[value % 12]) * scale - (7 * (value / 12)) * scale);
    				scoreLineY += clefOffset;
    				scoreLineY = (minY < scoreLineY)?scoreLineY:(scoreLineY + (scale * 7));
    				x += 6;
    				gc.drawImage(SystemImages.KEY_FLAT,x,scoreLineY);		
    			}else if(prevMeasure != null && prevMeasure.getKeySignature() >= 5 + 7){
    				value = 19; //G
    				scoreLineY = fromY + ((SCORE_NATURAL_POSITIONS[value % 12]) * scale - (7 * (value / 12)) * scale);
    				scoreLineY += clefOffset - 3;
    				scoreLineY = (minY < scoreLineY)?scoreLineY:(scoreLineY + (scale * 7));
    				x += 6;
    				gc.drawImage(SystemImages.KEY_NATURAL,x,scoreLineY);												
    			}
    			
    			if(measure.getKeySignature() >= 6 + 7){
    				value = 12; //C
    				scoreLineY = fromY + ((SCORE_NATURAL_POSITIONS[value % 12]) * scale - (7 * (value / 12)) * scale);
    				scoreLineY += clefOffset;
    				scoreLineY = (minY < scoreLineY)?scoreLineY:(scoreLineY + (scale * 7));
    				x += 6;
    				gc.drawImage(SystemImages.KEY_FLAT,x,scoreLineY);		
    			}else if(prevMeasure != null && prevMeasure.getKeySignature() >= 6 + 7){
    				value = 12; //C
    				scoreLineY = fromY + ((SCORE_NATURAL_POSITIONS[value % 12]) * scale - (7 * (value / 12)) * scale);
    				scoreLineY += clefOffset - 3;
    				scoreLineY = (minY < scoreLineY)?scoreLineY:(scoreLineY + (scale * 7));
    				x += 6;
    				gc.drawImage(SystemImages.KEY_NATURAL,x,scoreLineY);														
    			}
    			
    			if(measure.getKeySignature() >= 7 + 7){
    				value = 17; //F
    				scoreLineY = fromY + ((SCORE_NATURAL_POSITIONS[value % 12]) * scale - (7 * (value / 12)) * scale);
    				scoreLineY += clefOffset;
    				scoreLineY = (minY < scoreLineY)?scoreLineY:(scoreLineY + (scale * 7));
    				x += 6;
    				gc.drawImage(SystemImages.KEY_FLAT,x,scoreLineY);		
    			}else if(prevMeasure != null && prevMeasure.getKeySignature() >= 7 + 7){
    				value = 17; //F
    				scoreLineY = fromY + ((SCORE_NATURAL_POSITIONS[value % 12]) * scale - (7 * (value / 12)) * scale);
    				scoreLineY += clefOffset - 3;
    				scoreLineY = (minY < scoreLineY)?scoreLineY:(scoreLineY + (scale * 7));
    				x += 6;
    				gc.drawImage(SystemImages.KEY_NATURAL,x,scoreLineY);																
    			}    		    			
    			
    			
    		//}
    	}               
    }    
    
    private void paintTimeSignature(ViewLayout layout,GC gc, int fromX, int fromY){
        if(this.paintTimeSignature){        	        	
        	layout.setTimeSignatureStyle(gc);
        	
        	fromX += getClefSpan();
        	fromX += getKeySignatureSpan();
        	
        	if(layout.isScoreEnabled()){
            	int center =  ((layout.getScoreLineSpan() * 5) / 2);
            	int x = fromX + DEFAULT_LEFT_SPAN + 10;
            	int y1 = fromY + (center - 12);
            	int y2 = fromY + (center + 5);        
            
            	gc.drawString(Integer.toString(getMeasure().getTimeSignature().getNumerator()),x,y1);
            	gc.drawString(Integer.toString(getMeasure().getTimeSignature().getDenominator().getValue()),x,y2);        		
        		
        		
        		
        		fromY += layout.getScoreSpan();
        	}else{
        	
        		int tabHeight = (trackCoords.getTrack().getStrings().size() * layout.getStringSpan());
        		int center =  (tabHeight / 2);
        		int x = fromX + DEFAULT_LEFT_SPAN + 10;
        		int y1 = fromY + (center - 12);
        		int y2 = fromY + (center + 5);        
        
        		gc.drawString(Integer.toString(getMeasure().getTimeSignature().getNumerator()),x,y1);
        		gc.drawString(Integer.toString(getMeasure().getTimeSignature().getDenominator().getValue()),x,y2);
        	}
        	layout.setDefaultStyle(gc);
        }
    }
    
    
    private void paintTempo(ViewLayout layout,GC gc, int fromX, int fromY){
        if(this.paintTempo){
            int x = fromX;
            int y = fromY - 10;            
            gc.drawImage(SystemImages.TEMPO_IMAGE,x - 5,y - 10);
            gc.drawString(" = " + getMeasure().getTempo().getValue(),x + 10,y - 3);
        }
    }
    
    private void paintPlayMode(ViewLayout layout,GC gc, int fromX, int fromY){
        if(layout.isPlayModeEnabled() && isPlaying()){
            gc.setLineStyle(SWT.LINE_DASH);
            gc.drawRectangle(fromX + 5,fromY,getWidth() + getSpan() - 10,getHeight() + 10);
            gc.setLineStyle(SWT.LINE_SOLID);        
        }        
    }
    
    /**
     * Retorna true si se esta reproduciendo y la posicion del player esta en este compas.
     */    
    public boolean isPlaying(){
        if(this.songManager.getPlayer().isRunning() && getTrackCoords().hasCaret()){
            long playerTickPosition = this.songManager.getPlayer().getTickPosition();
            if(playerTickPosition >= getMeasure().getStart()  && playerTickPosition < getMeasure().getStart() + getMeasure().getLength()){            
                return true;
            }
        }        
        return false;
    }
    
    
    
    public int getSpanForComponent(MeasureComponent component){        
        return  (int)((component.getStart() - getMeasure().getStart())  * getSpan() / getMeasure().getLength());
    }    
    
    /**
     * Retorna el ancho del Compas
     */
    public int getWidth() {
        return this.width;
    }

    /**
     * Retorna el alto del Compas
     */
    public int getHeight() {
        return this.height;
    }

    public int getTimeSignatureSpan(){
        int span = 0;
        if(paintTimeSignature){
            span = DEFAULT_TIME_SIGNATURE_SPAN;
        }
        return span;
    }

    public int getClefSpan(){
        int span = 0;
        if(paintClef){
            span = DEFAULT_CLEF_SPAN;
        }
        return span;
    }    
    
    public int getKeySignatureSpan(){
        int span = 0;
        if(paintKeySignature){
        	if(measure.getKeySignature() <= 7){
        		span += 6 * (measure.getKeySignature());	
        	}else{
        		span += 6 * (measure.getKeySignature() - 7);
        	}
        	if(prevMeasure != null ){
        		if(prevMeasure.getKeySignature() <= 7){
        			span += 6 * (prevMeasure.getKeySignature());	
        		}else{
        			span += 6 * (prevMeasure.getKeySignature() - 7);
        		}        	
        	}
        }         
        return span;
    }      
    
    public int getTempoSpan(){
    	int span = 0;
    	if(paintTempo){
    		
    		int currentSpan = getClefSpan() + getKeySignatureSpan() + getTimeSignatureSpan();
    		if(currentSpan < 40){
    			span += (40 - currentSpan);
    		}
    	}
    	return span;
    }
    
    /**
     * Retorna el Componente Anterior
     */
    public MeasureComponent getPreviousComponent(MeasureComponent component) {
        MeasureComponent prevComponent = null;
        for (int noteIdx = 0; noteIdx < measureComponents.size(); noteIdx++) {
            MeasureComponent currComponent = (MeasureComponent) measureComponents.get(noteIdx);

            if (currComponent.getStart() < component.getStart()) {
                if (prevComponent == null) {
                    prevComponent = currComponent;
                } else if (currComponent.getStart() > prevComponent.getStart()) {
                    prevComponent = currComponent;
                } else if (currComponent.getStart() == prevComponent.getStart()
                        && currComponent.getDuration().getTime() <= prevComponent.getDuration().getTime()) {
                    prevComponent = currComponent;
                }
            }
        }
        return prevComponent;
    }

    /**
     * Retorna el Siguiente Componente
     */
    public MeasureComponent getNextComponent(MeasureComponent component) {
        MeasureComponent nextComponent = null;
        for (int noteIdx = 0; noteIdx < measureComponents.size(); noteIdx++) {
            MeasureComponent currComponent = (MeasureComponent) measureComponents.get(noteIdx);
            
            if (currComponent.getStart() > component.getStart()) {
                if (nextComponent == null) {
                    nextComponent = currComponent;
                } else if (currComponent.getStart() < nextComponent.getStart()) {
                    nextComponent = currComponent;
                } else if (currComponent.getStart() == nextComponent.getStart()
                        && currComponent.getDuration().getTime() <= nextComponent.getDuration().getTime()) {
                    nextComponent = currComponent;
                }
            }
        }
        return nextComponent;
    }

    
    /**
     * Retorna el Primer Componente
     */
    public MeasureComponent getFirstComponent() {
        MeasureComponent firstComponent = null;
        for (int noteIdx = 0; noteIdx < measureComponents.size(); noteIdx++) {
            MeasureComponent currComponent = (MeasureComponent) measureComponents.get(noteIdx);            
            if (firstComponent == null || currComponent.getStart() < firstComponent.getStart()) {
                firstComponent = currComponent;
            }
        }
        return firstComponent;
    }    
    
    /**
     * Retorna el Ultimo Componente
     */
    public MeasureComponent getLastComponent() {
        MeasureComponent lastComponent = null;
        for (int noteIdx = 0; noteIdx < measureComponents.size(); noteIdx++) {
            MeasureComponent currComponent = (MeasureComponent) measureComponents.get(noteIdx);            
            if (lastComponent == null || lastComponent.getStart() < currComponent.getStart()) {
                lastComponent = currComponent;
            }
        }
        return lastComponent;
    }     
    
    /**
     * Retorna Un Componente en la posicion start
     */
    public MeasureComponent getComponent(long start) {
        MeasureComponent component = null;
        for (int noteIdx = 0; noteIdx < measureComponents.size(); noteIdx++) {
            MeasureComponent currComponent = (MeasureComponent) measureComponents.get(noteIdx);            
            
            if (currComponent.getStart() <= start && (currComponent.getStart() + currComponent.getDuration().getTime() > start)) {
                component = currComponent;
                break;
            }
        }
        return component;
    }        

    /**
     * Retorna Todos los Componentes en la posicion Start
     */
    public List getComponents(long start) {
        List components = new ArrayList();        
        Iterator it = measureComponents.iterator();
        while(it.hasNext()){           
            MeasureComponent currComponent = (MeasureComponent)it.next();
            if (currComponent.getStart() == start) {
                components.add(currComponent);
            }
        }
        return components;
    }            
    
    
    /**
     * Retorna el Componente en la posicion Start, y en la cuerda
     */
    public MeasureComponent getComponent(long start,int string) {
        MeasureComponent component = null;
        for (int noteIdx = 0; noteIdx < measureComponents.size(); noteIdx++) {            
            MeasureComponent currComponent = (MeasureComponent) measureComponents.get(noteIdx);
            if(currComponent instanceof NoteCoords){
                NoteCoords note = (NoteCoords)currComponent;
                if (note.getStart() <= start && (note.getStart() + note.getDuration().getTime() > start) && note.getNote().getString() == string) {
                    component = currComponent;
                    break;
                }
            }
        }
        return component;
    }    
    
    /**
     * Retorna el Componente en la posicion Start, y en la cuerda
     */
    public MeasureComponent getComponentOrSilence(long start,int string) {
        MeasureComponent component = getComponent(start,string);
        if(component == null){
        	component = getComponent(start);
        	if(!(component instanceof SilenceCoords)){
        		component = null;
        	}
        }
        return component;
    }  
    
    /**
     * Retorna Todos los desde Start hasta el final del compas
     */
    public List getComponentsBeforeEnd(long fromStart) {
        List components = new ArrayList();        
        Iterator it = measureComponents.iterator();
        while(it.hasNext()){           
            MeasureComponent currComponent = (MeasureComponent)it.next();
            if (currComponent.getStart() >= fromStart) {
                components.add(currComponent);
            }
        }
        return components;
    }            
    
    
    public List getComponents(){
        return this.measureComponents;
    }
    
    
    /**
     * Retorna el Siguiente Componente en la cuerda. que sea de una nota
     */
    public MeasureComponent getNextNoteComponent(MeasureComponent component,int string) {
        MeasureComponent nextComponent = null;
        for (int noteIdx = 0; noteIdx < measureComponents.size(); noteIdx++) {
            MeasureComponent currComponent = (MeasureComponent) measureComponents.get(noteIdx);
            if(currComponent instanceof NoteCoords){                
                Note currNote = ((NoteCoords)currComponent).getNote();
                if(currNote.getString() == string && currNote.getStart() > component.getStart()){
                    if(nextComponent == null || currNote.getStart() < nextComponent.getStart()){
                        nextComponent = currComponent;
                    }
                }                
            }
        }
        return nextComponent;
    }      

    /**
     * Retorna el Siguiente Componente que sea de una nota
     */
    public MeasureComponent getNextNoteComponent(MeasureComponent component) {
        MeasureComponent nextComponent = null;
        for (int noteIdx = 0; noteIdx < measureComponents.size(); noteIdx++) {
            MeasureComponent currComponent = (MeasureComponent) measureComponents.get(noteIdx);
            if(currComponent instanceof NoteCoords){
            if (currComponent.getStart() > component.getStart()) {
                if (nextComponent == null) {
                    nextComponent = currComponent;
                } else if (currComponent.getStart() < nextComponent.getStart()) {
                    nextComponent = currComponent;
                } else if (currComponent.getStart() == nextComponent.getStart()
                        && currComponent.getDuration().getTime() <= nextComponent.getDuration().getTime()) {
                    nextComponent = currComponent;
                }
            }
            }
        }
        return nextComponent;
    }    
    

    /**
     * Retorna el Siguiente Componente que sea de un silencio
     */
    public MeasureComponent getNextSilenceComponent(MeasureComponent component) {
        MeasureComponent nextComponent = null;
        for (int noteIdx = 0; noteIdx < measureComponents.size(); noteIdx++) {
            MeasureComponent currComponent = (MeasureComponent) measureComponents.get(noteIdx);
            if(currComponent instanceof SilenceCoords){
            if (currComponent.getStart() > component.getStart()) {
                if (nextComponent == null) {
                    nextComponent = currComponent;
                } else if (currComponent.getStart() < nextComponent.getStart()) {
                    nextComponent = currComponent;
                } else if (currComponent.getStart() == nextComponent.getStart()
                        && currComponent.getDuration().getTime() <= nextComponent.getDuration().getTime()) {
                    nextComponent = currComponent;
                }
            }
            }
        }
        return nextComponent;
    }        
    
    
    /**
     * Retorna el componente mas cercano a X
     */    
    public MeasureComponent getComponentAt(int x){  
        MeasureComponent component = null;        
        Iterator it = measureComponents.iterator();
        while(it.hasNext()){           
            MeasureComponent currComponent = (MeasureComponent)it.next();
            if(component == null){
                component = currComponent;
            }else{                                    
                int distanceX = Math.abs(x - (component.getPointX()));
                int currDistanceX = Math.abs(x - (currComponent.getPointX()));
                if(currDistanceX < distanceX){
                    component = currComponent;
                }
            }
            
        }
        return component;
    }          

    /**
     * Retorna la cuerda en la posicion y
     */
    public InstrumentString getStringAt(int y) {
        InstrumentString string = null;
        int stringSpan = this.tablature.getViewLayout().getStringSpan();        
        int minorDistance = 0;
        int firstStringY = this.lastFromY;
        if(tablature.getViewLayout().isScoreEnabled()){
        	firstStringY += tablature.getViewLayout().getScoreSpan();	
        }
        Iterator it = trackCoords.getTrack().getStrings().iterator();
        while(it.hasNext()){
            InstrumentString currString = (InstrumentString)it.next();                        
            int distanceX = Math.abs(y - ((currString.getNumber() * stringSpan) + firstStringY));
            if(string == null || distanceX < minorDistance){
                string = currString;
                minorDistance = distanceX;
            }
        }        
            
        return string;    
    }    
   
    
    public long getBeatLength(){
        return this.beatLength;
    }
        
    public boolean areInSameBeat(MeasureComponent arg0,MeasureComponent arg1){
    	return songManager.getMeasureManager().areInSameBeat(measure,arg0.getComponent(),arg1.getComponent());
    }
    
    /**
     * Retorna true si es el primer compas
     */         
    public boolean isFirstMeasure(){
    	return songManager.getTrackManager().isFirstMeasure(measure);
    }

    /**
     * Retorna true si es el ultimo compas
     */         
    public boolean isLastMeasure(){
    	return songManager.getTrackManager().isLastMeasure(trackCoords.getTrack(),measure);
    }    
    
    /**
     * Reproduce las notas en el pulso
     */
    public void playBeat(long start){
    	if(!this.songManager.getPlayer().isRunning()){
    		List notes = songManager.getMeasureManager().getNotes(measure,start);
    		songManager.getPlayer().playBeat(getTrackCoords().getTrack(),notes);
    	}
    }
    
    /**
     * Retorna true si el Caret esta en este compas
     */     
    public boolean hasCaret() {
        return caret != null;
    }    
    
    /**
     * Retorna el Caret
     */     
    public Caret getCaret() {
        return caret;
    }
    /**
     * Asigna el Caret a este compas 
     */    
    public void setCaret(Caret caret) {
        this.caret = caret;
    }
        
    
    /**
     * Retorna la posicion X dentro del compas 
     */        
    public int getPosX() {
        return posX;
    }
    
    /**
     * Asigna la posicion X dentro del compas 
     */        
    public void setPosX(int posX) {
        this.posX = posX;
    }
    
    /**
     * Retorna la posicion Y dentro del compas 
     */       
    public int getPosY() {
        return posY;
    }
    
    /**
     * Asigna la posicion Y dentro del compas 
     */    
    public void setPosY(int posY) {
        this.posY = posY;
    }
    
    /**
     * Retorna la ultima posicion X asignada 
     */
    public int getLastFromX() {
        return lastFromX;
    }
    /**
     * Retorna la ultima posicion Y asignada 
     */    
    public int getLastFromY() {
        return lastFromY;
    }
    
    
    /**
     * Asigna el span de negras
     */       
    public void setQuarterSpan(int quarterSpan){
        this.quarterSpan = quarterSpan;
    }    
    
    /**
     * Retorna el span de negras
     */       
    public int getQuarterSpan(){
        return this.quarterSpan;
    }
    
    /**
     * Retorna el Compas     
     */
    public Measure getMeasure(){
        return this.measure;
    }   
    
    public int getSpan() {
        return span;
    }
    public void setSpan(int span) {
        this.span = span;
    }
            
    public boolean isOutOfBounds() {
		return outOfBounds;
	}   

	public void setOutOfBounds(boolean outOfBounds) {
		this.outOfBounds = outOfBounds;
	}
	
	public boolean isFirstOfLine() {
		return firstOfLine;
	}

	public void setFirstOfLine(boolean firstOfLine) {
		this.firstOfLine = firstOfLine;
	}


	public SongTrackCoords getTrackCoords(){
        return this.trackCoords;
    }
}