package org.herac.tuxguitar.gui.mixer;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.song.managers.SongManager;

public class SongVolume {
	private SongManager manager;
	private Scale volumeScale;
	private Text volumeText;
	private Label volumeLabel;
	
	public SongVolume(SongManager manager){
		this.manager = manager;
	}
	
	public void init(final Composite parent) {
		final Composite composite = new Composite(parent, SWT.NONE);

		this.volumeLabel = new Label(composite, SWT.NULL);
		this.volumeScale = new Scale(composite, SWT.VERTICAL);
		this.volumeText = new Text(composite, SWT.BORDER | SWT.SINGLE);

		composite.setLayout(new GridLayout(1, true));
		composite.setLayoutData(new GridData(GridData.FILL_VERTICAL));
		
		
		
		
		GridData data = new GridData(GridData.HORIZONTAL_ALIGN_CENTER | GridData.FILL_VERTICAL);
		this.volumeScale.setMaximum(10);
		this.volumeScale.setMinimum(0);
		this.volumeScale.setIncrement(1);
		this.volumeScale.setPageIncrement(1);
		this.volumeScale.setLayoutData(data);

		data = new GridData(GridData.HORIZONTAL_ALIGN_CENTER);
		data.widthHint = 16;
		data.heightHint = 13;
		this.volumeText.setEditable(false);
		this.volumeText.setLayoutData(data);

		this.volumeScale.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				manager.getSong().setVolume((short)(volumeScale.getMaximum() - volumeScale.getSelection()));
				volumeScale.setToolTipText(TuxGuitar.getProperty("song.volume") + ": " + manager.getSong().getVolume());
				volumeText.setText(Integer.toString(volumeScale.getMaximum() - volumeScale.getSelection()));
				if (TuxGuitar.instance().getTablatureEditor().getSongManager().getPlayer().isRunning()) {
					TuxGuitar.instance().getTablatureEditor().getSongManager().getPlayer().updateChannels();
				}				
			}
		});

		this.volumeScale.setSelection(this.volumeScale.getMaximum() - this.manager.getSong().getVolume());
		this.volumeText.setText(Integer.toString(this.volumeScale.getMaximum() - this.volumeScale.getSelection()));
	}
	
	public void loadProperties(){
		this.volumeLabel.setText(TuxGuitar.getProperty("song.volume") + ":");
		this.volumeScale.setToolTipText(TuxGuitar.getProperty("song.volume") + ": " + manager.getSong().getVolume());
	}
}
