/*
 * Created on 09-ene-2006
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.language;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Locale;
import java.util.ResourceBundle;

import org.herac.tuxguitar.gui.TuxGuitar;

/**
 * @author julian
 * 
 */
public class LanguageManager {
	private static final String LANGUAGE_FOLDER = "lang";
	
    private ResourceBundle resources;
    private String[] languages;
    
    public LanguageManager() {
        this.loadLanguages();
    }
    
    public void setLanguage(String lang) {                
        try {
        	if(lang == null){
        		this.resources = ResourceBundle.getBundle("lang.messages");
        	}else{
        		this.resources = ResourceBundle.getBundle("lang.messages", new Locale(lang));
        	}
        } catch (Exception e) {
        	e.printStackTrace();
        }
    }
    
    
    public String getProperty(String key) {
    	String s = null;

    	try {
    		s = resources.getString(key);
    	}catch(Exception e){}
    	
        return (s == null)?key:s;
    }    
        
    public String getLanguage() {
    	return this.resources.getLocale().getLanguage();
    }
    
    
    public String[] getLanguages() {
        return languages;
    }
    
    /**
     * Load language files from lang folder
     *
     */
    private void loadLanguages(){
    	// we need .properties files only
        final FilenameFilter filter = new FilenameFilter() {
            public boolean accept(File dir, String name) {
                return (name.indexOf("messages") != -1 && name.indexOf(".properties") != -1);
            }
        };  
        
        // get the files
        String[] fileNames = new File(TuxGuitar.getResourcePath(LANGUAGE_FOLDER)).list(filter);
        languages = new String[fileNames.length];
        
        // now iterate over them
        for(int i = 0;i < fileNames.length;i++){
        	
        	if (fileNames[i].indexOf("messages_") != -1){
        		languages[i] = fileNames[i].substring(9,11);
        	}

        }
    }    

}