/*
 * Created on 02-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.items.tool;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.edit.RedoAction;
import org.herac.tuxguitar.gui.actions.edit.UndoAction;
import org.herac.tuxguitar.gui.items.ItemContainer;
/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class EditToolItems implements ItemContainer {
    public static final String NAME = "EDIT_ITEMS";
    private TablatureEditor tablatureEditor;
    private ToolBar toolBar;   
    private ToolItem undo;
    private ToolItem redo;
    
    public EditToolItems(TablatureEditor tablatureEditor,ToolBar toolBar){
        this.tablatureEditor = tablatureEditor;
        this.toolBar = toolBar;
    }
   
    public void showItems(){                       
        this.undo = new ToolItem(toolBar, SWT.PUSH);
        this.undo.setImage(SystemImages.UNDO_IMAGE);
        this.undo.addSelectionListener(TuxGuitar.instance().getAction(UndoAction.NAME));
       
        this.redo = new ToolItem(toolBar, SWT.PUSH);
        this.redo.setImage(SystemImages.REDO_IMAGE);
        this.redo.addSelectionListener(TuxGuitar.instance().getAction(RedoAction.NAME));

        this.loadProperties();
    }
    
    
    public void update(){
        this.undo.setEnabled(this.tablatureEditor.getUndoManager().canUndo());
        this.redo.setEnabled(this.tablatureEditor.getUndoManager().canRedo());
    }
    
    public void loadProperties(){
        this.undo.setToolTipText(TuxGuitar.getProperty("edit.undo"));  
        this.redo.setToolTipText(TuxGuitar.getProperty("edit.redo"));  
    }        
}

