/*
 * Created on 02-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.items.menu;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.file.ExportMidiAction;
import org.herac.tuxguitar.gui.actions.file.ExportPDFAction;
import org.herac.tuxguitar.gui.actions.file.NewFileAction;
import org.herac.tuxguitar.gui.actions.file.OpenFileAction;
import org.herac.tuxguitar.gui.actions.file.PrintAction;
import org.herac.tuxguitar.gui.actions.file.PrintPreviewAction;
import org.herac.tuxguitar.gui.actions.file.SaveAsFileAction;
import org.herac.tuxguitar.gui.actions.file.SaveFileAction;
import org.herac.tuxguitar.gui.items.ItemContainer;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class FileMenuItem implements ItemContainer {
    private TablatureEditor tablatureEditor;
    private MenuItem fileMenuItem;
    private Menu menu;
    private Menu exportMenu; 
    private MenuItem newSong;
    private MenuItem open;
    private MenuItem save;
    private MenuItem saveAs;
    private MenuItem export;
    private MenuItem exportMidi;
    private MenuItem exportPDF;
    private MenuItem printPreview;
    private MenuItem print;
    private MenuItem exit;
    
    public FileMenuItem(Shell shell,Menu parent, int style, TablatureEditor tablatureEditor) {
        this.fileMenuItem = new MenuItem(parent, style);
        this.tablatureEditor = tablatureEditor;
        this.menu = new Menu(shell, SWT.DROP_DOWN);
    }

    
    public void showItems(){  
        //---------------------------------------------------
        //--NEW--
        this.newSong = new MenuItem(this.menu, SWT.PUSH);
        this.newSong.setImage(SystemImages.NEW_IMAGE);
        this.newSong.addSelectionListener(TuxGuitar.instance().getAction(NewFileAction.NAME));
        //--OPEN--
        this.open = new MenuItem(this.menu, SWT.PUSH);
        this.open.setImage(SystemImages.OPEN_IMAGE);
        this.open.addSelectionListener(TuxGuitar.instance().getAction(OpenFileAction.NAME)); 
        //--SEPARATOR--
        new MenuItem(this.menu, SWT.SEPARATOR);
        //--SAVE--
        this.save = new MenuItem(this.menu, SWT.PUSH);
        this.save.setImage(SystemImages.SAVE_IMAGE);
        this.save.addSelectionListener(TuxGuitar.instance().getAction(SaveFileAction.NAME));       
        //--SAVE AS--
        this.saveAs = new MenuItem(this.menu, SWT.PUSH);
        this.saveAs.addSelectionListener(TuxGuitar.instance().getAction(SaveAsFileAction.NAME));             
        //--SEPARATOR--
        new MenuItem(this.menu, SWT.SEPARATOR);
        //--EXPORT--
        this.export = new MenuItem(this.menu,SWT.CASCADE);
        this.exportMenu = new Menu(this.menu.getShell(), SWT.DROP_DOWN);
        //midi
        this.exportMidi = new MenuItem(this.exportMenu, SWT.PUSH);
        this.exportMidi.addSelectionListener(TuxGuitar.instance().getAction(ExportMidiAction.NAME));
        //pdf
        this.exportPDF = new MenuItem(this.exportMenu, SWT.PUSH);
        this.exportPDF.addSelectionListener(TuxGuitar.instance().getAction(ExportPDFAction.NAME));        
        //--SEPARATOR--
        new MenuItem(this.menu, SWT.SEPARATOR);
        //--PRINT PREVIEW--
        this.printPreview = new MenuItem(this.menu, SWT.PUSH);
        this.printPreview.addSelectionListener(TuxGuitar.instance().getAction(PrintPreviewAction.NAME));          
        //--PRINT--
        this.print = new MenuItem(this.menu, SWT.PUSH);
        this.print.addSelectionListener(TuxGuitar.instance().getAction(PrintAction.NAME));         
        //--SEPARATOR--
        new MenuItem(this.menu, SWT.SEPARATOR);
        //--EXIT--
        this.exit = new MenuItem(this.menu, SWT.PUSH);        
        this.exit.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent arg0) {
                tablatureEditor.getTablature().dispose();
                tablatureEditor.getSongManager().getPlayer().close();
                System.exit(0);
            }
        });
        //---------------------------------------------------
        this.export.setMenu(this.exportMenu);
        this.fileMenuItem.setMenu(menu);
        
        this.loadProperties();
    }

    
    public void update(){
        
    }
    
    public void loadProperties(){
        this.fileMenuItem.setText(TuxGuitar.getProperty("file"));  
        this.newSong.setText(TuxGuitar.getProperty("file.new"));  
        this.open.setText(TuxGuitar.getProperty("file.open"));  
        this.save.setText(TuxGuitar.getProperty("file.save"));
        this.saveAs.setText(TuxGuitar.getProperty("file.save-as"));
        this.export.setText(TuxGuitar.getProperty("file.export"));
        this.exportMidi.setText(TuxGuitar.getProperty("file.export-midi"));
        this.exportPDF.setText(TuxGuitar.getProperty("file.export-pdf"));
        this.printPreview.setText(TuxGuitar.getProperty("file.print-preview"));
        this.print.setText(TuxGuitar.getProperty("file.print"));
        this.exit.setText(TuxGuitar.getProperty("file.exit"));
    }         
}