/*
 * Created on 02-ene-2006
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.chord;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.herac.tuxguitar.song.models.Chord;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class ChordList extends Composite {
    private ChordEditor editor;
    private List graphicChords;    
    private int height;
    private int selectedChord;
    
    public ChordList(Composite parent) {
        super(parent, SWT.BORDER | SWT.V_SCROLL);
                
        this.setLayout(new GridLayout());
        this.setBackground(this.getDisplay().getSystemColor(SWT.COLOR_WHITE));
        this.graphicChords = new ArrayList();
        this.addPaintListener(new PaintListener() {
            public void paintControl(PaintEvent e) {
                paintChords(e.gc);
                e.gc.dispose();
            }
        });
        this.addMouseListener(new MouseListener() {
            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                showChord(getChord(e.x, e.y,true));
                redraw();
            }
        });
        
        final Point origin = new Point(0, 0);
        final ScrollBar vBar = getVerticalBar();
        vBar.addListener(SWT.Selection, new Listener() {
          public void handleEvent(Event e) {
            int vSelection = vBar.getSelection();
            int destY = -vSelection - origin.y;
            Rectangle rect = getBounds();
            getShell().scroll(0, destY, 0, 0, rect.width, rect.height, false);
            origin.y = -vSelection;            
            redraw();
          }
        });
        
        GridData data = new GridData(SWT.FILL,SWT.FILL,true,true);
        data.minimumHeight = 170;
        this.setLayoutData(data);
    }

    private void paintChords(GC gc) {
        int fromX = 20;
        int fromY = 20;
        
        int vScroll = getVerticalBar().getSelection();  
        
        Iterator it = graphicChords.iterator();
        while (it.hasNext()) {
            GraphicChord chord = (GraphicChord) it.next();
            
            if(fromX + chord.getWidth() >= ((getBounds().x + getBounds().width) - 30)){
                fromX = 20;
                fromY += chord.getHeigth() + 20;
            }
            
            chord.paintChord(gc, fromX, fromY -vScroll,this.selectedChord);
            fromX += chord.getWidth() + 30;
        }
        
        this.height = fromY +50;
        
        this.updateScroll();
    }
    
    public void updateScroll(){     
		Rectangle rect = getBounds();
		Rectangle client = getClientArea();        
        ScrollBar vBar = getVerticalBar();
		vBar.setMaximum(height + 20);
		vBar.setThumb(Math.min(rect.height, client.height));		
    }    

    private Chord getChord(int x, int y,boolean setAsSelected) {
        Iterator it = graphicChords.iterator();
        while (it.hasNext()) {
            GraphicChord chord = (GraphicChord) it.next();
            int x1 = chord.getX();
            int x2 = x1 + chord.getWidth();
            int y1 = chord.getY();
            int y2 = y1 + chord.getHeigth();
            if (x > x1 && x < x2 && y > y1 && y < y2) {
                if(setAsSelected){
                    this.selectedChord = chord.getId();
                }
                return chord.getChord();
            }
        }
        return null;
    }

    private void showChord(Chord chord) {
        if (chord != null) {
            int firstFret = -1;
            for (int i = 0; i < chord.getStrings().length; i++) {
                int fretValue = chord.getFretValue(i);
                if (firstFret < 0 || (fretValue < firstFret && fretValue >= 0)) {
                    firstFret = fretValue;
                }
            }
            editor.setFret((short)((firstFret<=0?1:firstFret)));
            for (int i = 0; i < chord.getStrings().length; i++) {
                int fretValue = chord.getFretValue(i);
                editor.addValue(fretValue, i + 1);
            }                       
            editor.redraw();
            
        }
    }

    public void setEditor(ChordEditor editor) {
        this.editor = editor;
    }

    public void setChords(List chords) {
        int tempId = 0;
        this.graphicChords.clear();
        this.selectedChord = 0;        
        Iterator it = chords.iterator();
        while (it.hasNext()) {
            Chord chord = (Chord) it.next();
            this.graphicChords.add(new GraphicChord(chord,++tempId));
        }
    }

    private class GraphicChord {
        private static final int STRING_SPAN = 8;
        private static final int FRET_SPAN = 10;                 
        private Chord chord;
        private int id;
        private int firstFret;
        private int x;
        private int y;
        private int width = 100;
        private int heigth = 100;
        
        public GraphicChord(Chord chord,int id) {
            this.chord = chord;
            this.id = id;
            this.width = ((STRING_SPAN * getChord().getStrings().length) - STRING_SPAN);
            this.heigth = ((FRET_SPAN * ChordEditor.VIEWING_FRETS) - FRET_SPAN);
            
            this.firstFret = -1;
            for (int i = 0; i < chord.getStrings().length; i++) {
                int fretValue = chord.getFretValue(i);
                if (this.firstFret < 0 || (fretValue < this.firstFret && fretValue >= 0)) {
                    this.firstFret = fretValue;
                }
            }
            this.firstFret = ((firstFret<=0?1:firstFret));              
        }


        private void paintChord(GC gc, int fromX, int fromY,int selectedChord) {
            if(getId() == selectedChord){
                gc.setForeground(getDisplay().getSystemColor(SWT.COLOR_BLUE));
            }else{
                gc.setForeground(getDisplay().getSystemColor(SWT.COLOR_BLACK));
            }
            
            this.x = fromX;
            this.y = fromY;          
            
            //dibujo las cuerdas
            for(int i = 0;i < getChord().getStrings().length;i++){
                int x1 = this.x + (i * STRING_SPAN);
                int x2 = this.x +  (i * STRING_SPAN);
                int y1 = this.y;
                int y2 = this.y + this.heigth;                                
                gc.drawLine(x1,y1,x2,y2);
            }
            
            //dibujo las cegillas
            for(int i = 0;i < ChordEditor.VIEWING_FRETS;i++){
                int x1 = this.x;
                int x2 = this.x + this.width;     
                int y1 = this.y + (i * FRET_SPAN);
                int y2 = this.y + (i * FRET_SPAN);                
                gc.drawLine(x1,y1,x2,y2);
            }                
                  
            //dibujo las notas
            for(int i = 0;i < getChord().getStrings().length;i++){
                int fretValue = getChord().getFretValue(i);
                if(fretValue > 0){
                    fretValue -= (this.firstFret - 1);
                    int noteX = this.x + (this.width - (STRING_SPAN * i)) - (STRING_SPAN / 2); 
                    int noteY = this.y + ((FRET_SPAN * fretValue) - FRET_SPAN) + (FRET_SPAN / 2);
                    
                    gc.setLineWidth(5);
                    gc.drawOval(noteX + 4,noteY ,1,1);
                    gc.setLineWidth(1);
                }
            }
                       
        }

        public Chord getChord() {
            return chord;
        }

        public void setChord(Chord chord) {
            this.chord = chord;
        }
        
        public int getId() {
            return id;
        }

        public void setId(int id) {
            this.id = id;
        }
        
        public int getHeigth() {
            return heigth;
        }

        public void setHeigth(int heigth) {
            this.heigth = heigth;
        }

        public int getWidth() {
            return width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getX() {
            return x;
        }

        public void setX(int x) {
            this.x = x;
        }

        public int getY() {
            return y;
        }

        public void setY(int y) {
            this.y = y;
        }
    }
 
}