/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.settings;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.config.PropertyNames;
import org.herac.tuxguitar.gui.config.SystemConfigManager;
import org.herac.tuxguitar.gui.tab.layout.ViewLayout;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class EditConfigAction extends Action{
    public static final String NAME = "EDIT_CONFIG";
    private SystemConfigManager config;
    private Shell dialog;
    private Option options[];
    
    public EditConfigAction(TablatureEditor tablatureEditor) {
        super(NAME,tablatureEditor);  
        this.config = TuxGuitar.instance().getConfig();
    }

    public boolean doAction(TypedEvent e) {
        showDialog(getEditor().getTablature().getShell());
        return true;
    }

    
    
    public void showDialog(Shell shell) {
            this.dialog = new Shell(shell, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);           

            dialog.setLayout(new GridLayout());
            dialog.setText(TuxGuitar.getProperty("settings.config"));

            //-------main-------------------------------------         
            Composite mainComposite = new Composite(dialog,SWT.NONE);
            mainComposite.setLayout(new GridLayout(2,false));
            createComposites(mainComposite);
            
            //-------buttons-------------------------------------

            Composite buttonComposite = new Composite(dialog,SWT.NONE);
            buttonComposite.setLayout(new GridLayout(2,true));
            buttonComposite.setLayoutData(new GridData(SWT.END,SWT.FILL,true,true));                          
            
            final Button buttonOK = new Button(buttonComposite, SWT.PUSH);
            buttonOK.setLayoutData(makeGridData(80,25)); 
            buttonOK.setText(TuxGuitar.getProperty("ok"));             
            buttonOK.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {   
                    updateOptions();
                    dialog.dispose();
                }
            });

            Button buttonCancel = new Button(buttonComposite, SWT.PUSH);
            buttonCancel.setLayoutData(makeGridData(80,25)); 
            buttonCancel.setText(TuxGuitar.getProperty("cancel"));
            buttonCancel.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {
                    dialog.dispose();
                }
            });

            dialog.pack();
            dialog.open();

            int x = shell.getBounds().x + (shell.getBounds().width - dialog.getSize().x) / 2;
            int y = shell.getBounds().y + (shell.getBounds().height - dialog.getSize().y) / 2;
            dialog.setLocation(x, y);
        
    }
    
    
    
    
    
    
    
	private void createComposites(Composite parent) {	    
		ToolBar toolBar = new ToolBar(parent, SWT.VERTICAL | SWT.BORDER);
		toolBar.setLayoutData(makeGridData(60,350));
			
	    Composite option = new Composite(parent,SWT.NONE);	
	    option.setLayout(new FormLayout());
	    option.setLayoutData(makeGridData(250,350));
	    
	    initOptions(toolBar,option);		

		select(options[0]);
	}
	
    protected GridData makeGridData(int minWith,int minHeight){   
    	GridData data = new GridData();
    	data.horizontalAlignment = SWT.FILL;
    	data.verticalAlignment = SWT.FILL;
    	data.grabExcessHorizontalSpace = true;
    	data.grabExcessVerticalSpace = true;    	
    	data.minimumWidth = minWith;
    	data.minimumHeight = minHeight;
    	
    	return data;
    }  
	
	private void initOptions(ToolBar toolBar,Composite parent){
	    this.options = new Option[2];
	    this.options[0] = new ViewOption(this.config,toolBar,parent);
		this.options[1] = new LanguageOption(this.config,toolBar,parent);

		for(int i = 0;i < this.options.length;i++){
			this.options[i].createOption();		   
		}
	}

    private void select(Option option){
        hideAll();
        option.setVisible(true);
        dialog.layout();
    }
    
    private void hideAll(){
        for(int i = 0;i < this.options.length;i++){
            this.options[i].setVisible(false);
            this.options[i].setVisible(false);
        }
    }

    private void updateOptions(){        
        this.config.clear();
        for(int i = 0;i < this.options.length;i++){
            this.options[i].updateConfig();
        }
        this.config.save();
    }

    
    private abstract class Option extends SelectionAdapter{ 
        private SystemConfigManager config;
        private ToolBar toolBar;
        private Composite parent;
        private Group group;
        private Composite composite;
        private ToolItem toolItem;
        
        public Option(SystemConfigManager config,ToolBar toolBar,final Composite parent,String text){
            this.config = config;
            this.toolBar = toolBar;
            this.parent = parent;
            this.toolItem = new ToolItem(toolBar, SWT.RADIO);
            this.group = new Group(parent, SWT.SHADOW_ETCHED_IN);
            this.group.setLayout(new GridLayout());
            this.group.setLayoutData(getGroupData());
            this.group.setText(text);
            this.composite = new Composite(this.group, SWT.SHADOW_ETCHED_IN);   
            this.composite.setLayout(new GridLayout());
        }
        
        public abstract void createOption();   
        
        public abstract void updateConfig();       
        
        public void setVisible(boolean visible){
            this.toolItem.setSelection(visible);
            this.group.setVisible(visible);            
        }
        
        protected FormData getGroupData(){
            FormData data = new FormData();
            data.top = new FormAttachment(0,0);
            data.bottom = new FormAttachment(100,0);
            data.left = new FormAttachment(0,0);
            data.right = new FormAttachment(100,0);
            return data;
        }                 
        
        protected GridData getTabbedData(){   
        	GridData data = new GridData();
        	data.horizontalAlignment = SWT.FILL;
        	data.grabExcessHorizontalSpace = true;
        	data.horizontalIndent = 20;
		
        	return data;
        }
        
	    public void widgetSelected(SelectionEvent e) {
	        select(this);
	    }        	
	    
	    public SystemConfigManager getConfig(){
	        return this.config;
	    }
	    
	    public Composite getComposite(){	        
	        return this.composite;
	    }
	    
	    public ToolItem getToolItem(){
	        return this.toolItem;
	    }
    }
    
    private class ViewOption extends Option{
        private static final int MIN_WIDHT = 640;
        private static final int MIN_HEIGHT = 480;
        
        private Button mixer;
        private Button transport;
        private Button fretBoard;
        private Button maximized;
        private Button multitrack;
        private Button scoreEnabled;
        private Button[] layoutModes;
        private Spinner width;
        private Spinner height;
        public ViewOption(SystemConfigManager config,ToolBar toolBar,final Composite parent){
            super(config,toolBar,parent,TuxGuitar.getProperty("settings.config.view"));            
        }        

        public void createOption(){		
    		getToolItem().setText(TuxGuitar.getProperty("settings.config.view"));	
    		getToolItem().setImage(SystemImages.OPTION_VIEW);
    		getToolItem().addSelectionListener(this);

    		Label title = new Label(getComposite(),SWT.NONE);
    		title.setText(TuxGuitar.getProperty("settings.config.view.mode"));
    		
    		this.mixer = new Button(getComposite(),SWT.CHECK);
    		this.mixer.setText(TuxGuitar.getProperty("show-mixer"));
    		this.mixer.setLayoutData(getTabbedData());
    		this.mixer.setSelection(getConfig().getBooleanConfigValue(PropertyNames.SHOW_MIXER));
    		
    		this.transport = new Button(getComposite(),SWT.CHECK);
    		this.transport.setText(TuxGuitar.getProperty("show-transport"));
    		this.transport.setLayoutData(getTabbedData());
    		this.transport.setSelection(getConfig().getBooleanConfigValue(PropertyNames.SHOW_TRANSPORT));    		
    		
    		this.fretBoard = new Button(getComposite(),SWT.CHECK);
    		this.fretBoard.setText(TuxGuitar.getProperty("show-fretboard"));
    		this.fretBoard.setLayoutData(getTabbedData());
    		this.fretBoard.setSelection(getConfig().getBooleanConfigValue(PropertyNames.SHOW_FRETBOARD));

    		this.scoreEnabled = new Button(getComposite(),SWT.CHECK);
    		this.scoreEnabled.setText(TuxGuitar.getProperty("layout.score-enabled"));
    		this.scoreEnabled.setLayoutData(getTabbedData());
    		this.scoreEnabled.setSelection(getConfig().getBooleanConfigValue(PropertyNames.SHOW_SCORE));    		
    		
    		this.multitrack = new Button(getComposite(),SWT.CHECK);
    		this.multitrack.setText(TuxGuitar.getProperty("layout.multitrack"));
    		this.multitrack.setLayoutData(getTabbedData());
    		this.multitrack.setSelection(getConfig().getBooleanConfigValue(PropertyNames.SHOW_MULTITRACK));    		    	
    		
    		this.layoutModes = new Button[2];		
    		this.layoutModes[0] = new Button(getComposite(),SWT.RADIO); 
    		this.layoutModes[0].setText(TuxGuitar.getProperty("layout.page"));	
    		this.layoutModes[0].setLayoutData(getTabbedData());
    		this.layoutModes[1] = new Button(getComposite(),SWT.RADIO); 
    		this.layoutModes[1].setText(TuxGuitar.getProperty("layout.linear"));
    		this.layoutModes[1].setLayoutData(getTabbedData());
    		int currentMode = getConfig().getIntConfigValue(PropertyNames.LAYOUT_MODE);
    		switch(currentMode){
    			case ViewLayout.MODE_PAGE:
    			    this.layoutModes[0].setSelection(true);
    			    break;
    			case ViewLayout.MODE_LINEAR:
    			    this.layoutModes[1].setSelection(true);
    			    break;    			
    		}

    		
    		title = new Label(getComposite(),SWT.NONE);
    		title.setText(TuxGuitar.getProperty("settings.config.view.size"));
    		
    		this.maximized = new Button(getComposite(),SWT.CHECK);
    		this.maximized.setText(TuxGuitar.getProperty("settings.config.view.size.maximized"));
    		this.maximized.setLayoutData(getTabbedData());
    		this.maximized.setSelection(getConfig().getBooleanConfigValue(PropertyNames.MAXIMIZED));    		
    		
    		Composite size = new Composite(getComposite(),SWT.NONE);
    		size.setLayout(new GridLayout(2,true));
    		
    		Label widthLabel = new Label(size,SWT.NONE);
    		widthLabel.setText(TuxGuitar.getProperty("settings.config.view.size.width"));
    		
            widthLabel.setLayoutData(getTabbedData());
            
    		this.width = new Spinner(size, SWT.BORDER);    		
    		this.width.setMinimum(MIN_WIDHT);
    		this.width.setMaximum(getEditor().getTablature().getDisplay().getBounds().width);
    		this.width.setSelection(getConfig().getIntConfigValue(PropertyNames.WIDTH));  
            
            this.width.setLayoutData(getTabbedData());
    		
    		
            
            
    		Label heightLabel = new Label(size,SWT.NONE);
    		heightLabel.setText(TuxGuitar.getProperty("settings.config.view.size.height"));
    		
            heightLabel.setLayoutData(getTabbedData());
            
    		this.height = new Spinner(size, SWT.BORDER);
    		this.height.setMinimum(MIN_HEIGHT);
    		this.height.setMaximum(getEditor().getTablature().getDisplay().getBounds().height);
    		this.height.setSelection(getConfig().getIntConfigValue(PropertyNames.HEIGHT));      		

            this.height.setLayoutData(getTabbedData());

            width.setEnabled(!maximized.getSelection());
            height.setEnabled(!maximized.getSelection());
    		this.maximized.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent e) {
                    width.setEnabled(!maximized.getSelection());
                    height.setEnabled(!maximized.getSelection());
                }
            });
    		
    		
    		
        }                  
    
        
        public void updateConfig(){
            for(int i = 0;i < this.layoutModes.length;i++){
                if(this.layoutModes[i].getSelection()){
                    getConfig().setProperty(PropertyNames.LAYOUT_MODE,i + 1); 
                }
            }                   
            getConfig().setProperty(PropertyNames.SHOW_SCORE,this.scoreEnabled.getSelection());
            getConfig().setProperty(PropertyNames.SHOW_MULTITRACK,this.multitrack.getSelection());
            getConfig().setProperty(PropertyNames.SHOW_MIXER,this.mixer.getSelection());
            getConfig().setProperty(PropertyNames.SHOW_TRANSPORT,this.transport.getSelection());
            getConfig().setProperty(PropertyNames.SHOW_FRETBOARD,this.fretBoard.getSelection());    
            
            getConfig().setProperty(PropertyNames.MAXIMIZED,this.maximized.getSelection());
            getConfig().setProperty(PropertyNames.WIDTH,this.width.getSelection());
            getConfig().setProperty(PropertyNames.HEIGHT,this.height.getSelection());
        }
        
    }    
    
    
    
    
    private class LanguageOption extends Option{
        private Button[] languages;
       
        
        public LanguageOption(SystemConfigManager config,ToolBar toolBar,final Composite parent){
            super(config,toolBar,parent,TuxGuitar.getProperty("settings.config.language"));  
        }
        
        public void createOption(){		
    		getToolItem().setText(TuxGuitar.getProperty("settings.config.language"));	
    		getToolItem().setImage(SystemImages.OPTION_LANGUAGE);
    		getToolItem().addSelectionListener(this);
    		
    		Label title = new Label(getComposite(),SWT.NONE);
    		title.setText(TuxGuitar.getProperty("settings.config.language.choose"));    		
    		
    		String currenLanguage = getConfig().getStringConfigValue(PropertyNames.LANGUAGE);
    		String[] availableLanguages = TuxGuitar.instance().getLanguageManager().getLanguages();
    		this.languages = new Button[availableLanguages.length];
    		for(int i = 0;i < this.languages.length;i++){
    		    this.languages[i] = new Button(getComposite(),SWT.RADIO); 
    		    this.languages[i].setData(availableLanguages[i]);
    		    this.languages[i].setLayoutData(getTabbedData());
    		    this.languages[i].setText(TuxGuitar.getProperty(availableLanguages[i]));	    		    
    			if(availableLanguages[i].equals(currenLanguage)){
    			    this.languages[i].setSelection(true);
    			}
    		}
    		
    		
        }                        
       
        public void updateConfig(){    		
            String selected = "";
    		for(int i = 0;i < this.languages.length;i++){
    		    if(this.languages[i].getSelection()){
    		        selected = (String)this.languages[i].getData();
    		    }
    		}
    		getConfig().setProperty(PropertyNames.LANGUAGE,selected);
        }
        
    }
}
