/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.measure;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.clipboard.MeasureTransferable;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;
import org.herac.tuxguitar.song.models.Measure;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class CopyMeasureAction extends Action{
    public static final String NAME = "COPY_MEASURE";
    
    private boolean copyAllTracks;
    
    public CopyMeasureAction(TablatureEditor tablatureEditor) {
        super(NAME,true,tablatureEditor);       
    }

    public boolean doAction(TypedEvent e) {
    	showDialog(getEditor().getTablature().getShell());

	    return true;
    }

    private void copyCurrentMeasure(){
        Caret caret = getEditor().getTablature().getCaret();
	    MeasureCoords measure = caret.getMeasureCoords();
	    if(measure != null){
	        long p1 = measure.getMeasure().getStart();
	        long p2 = measure.getMeasure().getStart();
	        MeasureTransferable transferable = new MeasureTransferable(getEditor(),p1,p2,true);
	        getEditor().getClipBoard().addTransferable(transferable);
	    }
    }


    public void showDialog(Shell shell) {
    	SongTrackCoords track = getEditor().getTablature().getCaret().getSongTrackCoords();
        MeasureCoords measure = getEditor().getTablature().getCaret().getMeasureCoords();
        if (measure != null) {
            final Shell dialog = new Shell(shell, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);  
            dialog.setLayout(new GridLayout());
            dialog.setText(TuxGuitar.getProperty("edit.copy"));
            
            //----------------------------------------------------------------------
            Composite range = new Composite(dialog,SWT.NONE);
            range.setLayout(new GridLayout(4,false));
            range.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));   
            
            int measureCount = getSongManager().countMeasures();
            
            
            GridData spinnerData = new GridData();
            spinnerData.widthHint = 26;
            spinnerData.verticalAlignment = SWT.CENTER;
            spinnerData.grabExcessVerticalSpace = true;
            
            Label fromLabel = new Label(range, SWT.NULL);            
            fromLabel.setText(TuxGuitar.getProperty("edit.from"));                        
            final Spinner fromSpinner = new Spinner(range, SWT.BORDER);        
            fromSpinner.setLayoutData(spinnerData);  
            fromSpinner.setMinimum(1);
            fromSpinner.setMaximum(measureCount);     
            fromSpinner.setSelection(measure.getMeasure().getNumber());
            
            Label toLabel = new Label(range, SWT.NULL);
            toLabel.setText(TuxGuitar.getProperty("edit.to"));
            final Spinner toSpinner = new Spinner(range, SWT.BORDER);                       
            toSpinner.setLayoutData(spinnerData);      
            toSpinner.setMinimum(1);
            toSpinner.setMaximum(measureCount);     
            toSpinner.setSelection(measure.getMeasure().getNumber());
            
            final int minSelection = 1;
            final int maxSelection = track.getMeasuresCoords().size();
            
            
            fromSpinner.addSelectionListener(new SelectionAdapter() {		
				public void widgetSelected(SelectionEvent e) {
					int fromSelection = fromSpinner.getSelection();
					int toSelection = toSpinner.getSelection();
										
					if(fromSelection < minSelection){
						fromSpinner.setSelection(minSelection);
					}else if(fromSelection > toSelection){
						fromSpinner.setSelection(toSelection);
					}
				}		
			});
            toSpinner.addSelectionListener(new SelectionAdapter() {		
				public void widgetSelected(SelectionEvent e) {					
					int toSelection = toSpinner.getSelection();
					int fromSelection = fromSpinner.getSelection();
					if(toSelection < fromSelection){
						toSpinner.setSelection(fromSelection);
					}else if(toSelection > maxSelection){
						toSpinner.setSelection(maxSelection);
					}
				}		
			});
            //----------------------------------------------------------------------            
            copyAllTracks = false;
            if(getEditor().getSongManager().countTracks() > 1){
                Composite checkComposites = new Composite(dialog,SWT.NONE);            
                checkComposites.setLayout(new GridLayout());
                checkComposites.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));                      	
            	
            	final Button allTracks = new Button(checkComposites,SWT.CHECK);
            	allTracks.setText(TuxGuitar.getProperty("edit.all-tracks"));
            	allTracks.addSelectionListener(new SelectionAdapter() {
					public void widgetSelected(SelectionEvent e) {
						copyAllTracks = allTracks.getSelection();
					}				
				});
            }
            //------------------BUTTONS--------------------------            
            Composite buttons = new Composite(dialog, SWT.NONE);
            buttons.setLayout(new GridLayout(2,false));
            buttons.setLayoutData(new GridData(SWT.END,SWT.FILL,true,true));    	
            
            GridData data = new GridData(SWT.FILL,SWT.FILL,true,true);    
            data.minimumWidth = 80;
            data.minimumHeight = 25;     
            
            final Button buttonOK = new Button(buttons, SWT.PUSH);
            buttonOK.setText(TuxGuitar.getProperty("ok"));
            buttonOK.setLayoutData(data);
            buttonOK.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {   
                	copyMeasures(fromSpinner.getSelection(),toSpinner.getSelection(),copyAllTracks);
                    dialog.dispose();
                }
            });

            Button buttonCancel = new Button(buttons, SWT.PUSH);            
            buttonCancel.setText(TuxGuitar.getProperty("cancel"));
            buttonCancel.setLayoutData(data);
            buttonCancel.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {
                    dialog.dispose();
                }
            });

            dialog.pack();
            dialog.open();

            int x = shell.getBounds().x + (shell.getBounds().width - dialog.getSize().x) / 2;
            int y = shell.getBounds().y + (shell.getBounds().height - dialog.getSize().y) / 2;
            dialog.setLocation(x, y);
            
    		while (!dialog.isDisposed()) {
                if (!dialog.getDisplay().readAndDispatch()) {
                	dialog.getDisplay().sleep();
                }

            }	            
        }
    }
    
    
    private void copyMeasures(int m1,int m2,boolean allTracks){
    	if(m1 > 0 && m1 <= m2){    	
    		Caret caret = getEditor().getTablature().getCaret();
    		Measure measure1 = getSongManager().getTrackManager().getMeasure(caret.getSongTrackCoords().getTrack(),m1);
    		Measure measure2 = getSongManager().getTrackManager().getMeasure(caret.getSongTrackCoords().getTrack(),m2);
    		if(measure1 != null && measure2 != null){
    	        long p1 = measure1.getStart();
    	        long p2 = measure2.getStart();
    	        MeasureTransferable transferable = new MeasureTransferable(getEditor(),p1,p2,allTracks);
    	        getEditor().getClipBoard().addTransferable(transferable);    	        
    		}
    	}
    }
}
