/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.help;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.doc.DocReader;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window -
 * Preferences - Java - Code Style - Code Templates
 */
public class ShowAboutHelpAction extends Action {
	public static final String NAME = "SHOW_ABOUT_HELP";

	private static final String TUXGUITAR_VERSION = "TuxGuitar 0.7";
	
	private static final int IMAGE_WIDTH = 100;
	private static final int IMAGE_HEIGHT = 100;

	private static final int TAB_ITEM_WIDTH = 500;
	private static final int TAB_ITEM_HEIGHT = 200;	
	
	public ShowAboutHelpAction(TablatureEditor tablatureEditor) {
		super(NAME, false, tablatureEditor);
	}

	public boolean doAction(TypedEvent e) {
		showDialog(getEditor().getTablature().getShell());
		return true;
	}

	public void showDialog(Shell shell) {

		final Shell dialog = new Shell(shell,SWT.DIALOG_TRIM|SWT.APPLICATION_MODAL);

		dialog.setLayout(new GridLayout());
		dialog.setText(TuxGuitar.getProperty("help.about"));

		
		//--------------------HEADER----------------------------------
		final Composite header = new Composite(dialog,SWT.NONE);
		final Canvas imageCanvas = new Canvas(header,SWT.NONE);
		final Image image = SystemImages.TUXGUITAR_SPLASH;
		final Label title = new Label(header,SWT.NONE);
		final Font font = new Font(dialog.getDisplay(),"Serif",36, SWT.BOLD | SWT.ITALIC);
		
		header.setLayout(new GridLayout(2,false));		
		
		imageCanvas.setLayoutData(new GridData(IMAGE_WIDTH,IMAGE_HEIGHT));
		imageCanvas.addPaintListener(new PaintListener() {
			public void paintControl(PaintEvent e) {
				e.gc.drawImage(image,0,0,image.getBounds().width,image.getBounds().height,0,0,IMAGE_WIDTH,IMAGE_HEIGHT);
			}
		});
		
		title.setFont(font);
		title.setForeground(dialog.getDisplay().getSystemColor(SWT.COLOR_GRAY));
		title.setText(TUXGUITAR_VERSION);		
		font.dispose();
		//-------------------TABS-----------------------
        Composite tabs = new Composite(dialog, SWT.NONE);
        tabs.setLayout(new GridLayout());
        tabs.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));  
        
		TabFolder tabFolder = new TabFolder(tabs, SWT.NONE);
		tabFolder.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));  
		tabFolder.setLayout(new FormLayout());
	
        DocReader docReader = new DocReader();
        
        makeTabItem(tabFolder,DocReader.DESCRIPTION,docReader.read(DocReader.DESCRIPTION).toString());
        makeTabItem(tabFolder,DocReader.AUTHORS,docReader.read(DocReader.AUTHORS).toString());
		makeTabItem(tabFolder,DocReader.LICENSE,docReader.read(DocReader.LICENSE).toString());
        
		//------------------BUTTONS--------------------------            
        Composite buttons = new Composite(dialog, SWT.NONE);
        buttons.setLayout(new GridLayout());
        buttons.setLayoutData(new GridData(SWT.END,SWT.FILL,true,true));    	
        
        GridData data = new GridData(SWT.FILL,SWT.FILL,true,true);    
        data.minimumWidth = 80;
        data.minimumHeight = 25;    
        
		Button buttonExit = new Button(buttons, SWT.PUSH);
		buttonExit.setLayoutData(data);
		buttonExit.setText(TuxGuitar.getProperty("exit"));
		buttonExit.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent arg0) {
				dialog.dispose();
			}
		});

		dialog.pack();
		dialog.open();

		int x = shell.getBounds().x
				+ (shell.getBounds().width - dialog.getSize().x) / 2;
		int y = shell.getBounds().y
				+ (shell.getBounds().height - dialog.getSize().y) / 2;
		dialog.setLocation(x, y);

	}
	
	private void makeTabItem(TabFolder tabFolder,String itemName,String itemText){		
        Composite control = new Composite(tabFolder, SWT.NONE);                    
        control.setLayout(new GridLayout());
        control.setLayoutData(new FormData(TAB_ITEM_WIDTH,TAB_ITEM_HEIGHT));
        
        Text text = new Text(control,SWT.BORDER | SWT.MULTI | SWT.WRAP | SWT.V_SCROLL);
        text.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));  
        text.setEditable(false);
        text.append(itemText);        
        text.setSelection(0);
        
        TabItem tabItem = new TabItem(tabFolder, SWT.NONE);
        tabItem.setText(itemName);
        tabItem.setControl(control);		
	}
}
