/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.file;

import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.net.URI;
import java.net.URISyntaxException;

import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.PageRanges;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.PrinterData;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.printer.PrintDialog;
import org.herac.tuxguitar.gui.printer.PrintDocument;
import org.herac.tuxguitar.gui.printer.PrintableImpl;
import org.herac.tuxguitar.gui.tab.Tablature;
import org.herac.tuxguitar.gui.tab.layout.PrinterViewLayout;
import org.herac.tuxguitar.gui.util.MessageDialog;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class PrintAction extends Action{
    public static final String NAME = "PRINT";
    
    private static final double PAPER_MARGIN = 36.00;
    
    public PrintAction(TablatureEditor tablatureEditor) {
        super(NAME,true,tablatureEditor);       
    }
    
    public boolean doAction(TypedEvent e) {    	
		if(!TuxGuitar.isDisposed()){		
    		new SyncThread(new Runnable() {
    			public void run() {				
    				final PrinterData printerData = new PrintDialog(getEditor().getTablature().getShell()).open();
    				if(printerData != null){	    					
    					new SyncThread(new Runnable() {
    						public void run() {			
    							try {		    					
    								PrintService service = getPrintService(printerData);
	    							
    								if(service != null){
    									DocPrintJob printJob = service.createPrintJob();	        								
    									PrintDocument document = makePrintDocument(new PageFormat());
    									Printable printable = new PrintableImpl(document);		    					
    									DocFlavor flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;		
    									HashPrintRequestAttributeSet aset= new HashPrintRequestAttributeSet();
	    					
    									//COPIES
    									aset.add(new Copies(printerData.copyCount));
	    					
    									//RANGE
    									if(printerData.scope == PrinterData.PAGE_RANGE){
    										printerData.startPage = (printerData.startPage <= 0)?1:printerData.startPage;
    										printerData.startPage = (printerData.startPage > document.count())?document.count():printerData.startPage;
    										printerData.endPage = (printerData.endPage < printerData.startPage)?printerData.startPage:printerData.endPage;
    										printerData.endPage = (printerData.endPage > document.count())?document.count():printerData.endPage;

    										aset.add(new PageRanges(printerData.startPage,printerData.endPage));
    									}
	    					
    									//PRINT TO FILE
    									if(printerData.printToFile && printerData.fileName != null && printerData.fileName.length() > 0){
    										aset.add(new Destination(new URI(printerData.fileName)));
    									}
	    					
    									//START PRINT
    									Doc doc = new SimpleDoc(printable,flavor,null);	    					
    									printJob.print(doc,aset);	 
    								}			
    							} catch (PrintException e1) {
    								e1.printStackTrace();
    							} catch (URISyntaxException e2) {
    								e2.printStackTrace();
    							}catch(OutOfMemoryError error){
    								showErrorMessage(error);                            	
    							}				    					
    						}       		               		    		
    					}).start();	
    				}
    			}       		               		    		
    		}).start();	    			
		}
	   	return true;	    
    } 
    
	public PrintService getPrintService(PrinterData printerData){
		if(printerData != null && printerData.name != null){
			PrintService[] services = PrintServiceLookup.lookupPrintServices(null,null);
			for(int i = 0;i < services.length;i++){
				if(services[i].getName().equals(printerData.name)){
					return services[i];
				}
			}
				
		}
		
		PrintService service = PrintServiceLookup.lookupDefaultPrintService();
		if(service != null){
			return service;
		}						
		return null;
	}
	
	public PrintDocument makePrintDocument(PageFormat pageFormat){	
		Tablature tablature = new Tablature(getEditor().getTablature(),SWT.NONE);
        tablature.setSongManager(getEditor().getSongManager());
        
        PrinterViewLayout layout = new PrinterViewLayout(tablature,getEditor().getSongManager(),false,false);
        tablature.initDefaults(layout);			
        tablature.updateTablature();		
        tablature.getCaret().update(getEditor().getTablature().getCaret().getSongTrackCoords().getTrack().getNumber());
        
        PrintDocument doc = layout.makeDocument(new Rectangle(0,0,(int)pageFormat.getImageableWidth() - 13,(int)pageFormat.getImageableHeight()));        
        tablature.dispose();        
		return doc;
	}
    
    private void showErrorMessage(final Error error){
        new SyncThread( new Runnable() {
            public void run() {
                if(!TuxGuitar.isDisposed()){                              
                	String name = error.getClass().getName();
                	String message = error.getMessage();
                	new MessageDialog(name,message,SWT.ICON_ERROR | SWT.OK).show(getEditor().getTablature().getShell());
                }
            }
        }).start();        
    }
}
