/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.composition;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.SongCoords;
import org.herac.tuxguitar.gui.undo.undoables.custom.UndoableChangeTimeSignature;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.TimeSignature;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class ChangeTimeSignatureAction extends Action{
    public static final String NAME = "CHANGE_TIME_SIGNATURE";
    
    public ChangeTimeSignatureAction(TablatureEditor tablatureEditor) {
        super(NAME,true,tablatureEditor);       
    }

    public boolean doAction(TypedEvent e) {
        showDialog(getEditor().getTablature().getShell()); 
        return true;
    }

    
    public void showDialog(Shell shell) {
        MeasureCoords measure = getEditor().getTablature().getCaret().getMeasureCoords();
        if (measure != null) {
            final Shell dialog = new Shell(shell, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);

            dialog.setLayout(new GridLayout());
            dialog.setText(TuxGuitar.getProperty("composition.timesignature"));
            
            //-------------TIME SIGNATURE-----------------------------------------------
            Composite timeSignature = new Composite(dialog, SWT.NONE);
            timeSignature.setLayout(new GridLayout(2,false));
            timeSignature.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));   
            
            TimeSignature currentTimeSignature = measure.getMeasure().getTimeSignature();
            //numerator
            Label numeratorLabel = new Label(timeSignature, SWT.NULL);
            numeratorLabel.setText(TuxGuitar.getProperty("composition.timesignature.Numerator"));
            final Combo numerator = new Combo(timeSignature, SWT.NULL);
            for (int i = 1; i <= 32; i++) {
                numerator.add(Integer.toString(i));
            }            
            numerator.setText(Integer.toString(currentTimeSignature.getNumerator()));
            numerator.setLayoutData(new GridData(SWT.END,SWT.FILL,true,true));
            //denominator
            Label denominatorLabel = new Label(timeSignature, SWT.NULL);
            denominatorLabel.setText(TuxGuitar.getProperty("composition.timesignature.denominator"));
            final Combo denominator = new Combo(timeSignature, SWT.NULL);
            for (int i = 1; i <= 32; i = i * 2) {
                denominator.add(Integer.toString(i));
            }
            denominator.setText(Integer.toString(currentTimeSignature.getDenominator().getValue()));
            denominator.setLayoutData(new GridData(SWT.END,SWT.FILL,true,true));
            //--------------------To End Checkbox-------------------------------
            Composite check = new Composite(dialog, SWT.NONE);
            check.setLayout(new GridLayout());
            check.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));    
           
            final Button toEnd = new Button(check, SWT.CHECK);
            toEnd.setText(TuxGuitar.getProperty("composition.timesignature.to-the-end"));            
            
            //------------------BUTTONS--------------------------            
            Composite buttons = new Composite(dialog, SWT.NONE);
            buttons.setLayout(new GridLayout(2,false));
            buttons.setLayoutData(new GridData(SWT.END,SWT.FILL,true,true));    	
            
            GridData data = new GridData(SWT.FILL,SWT.FILL,true,true);    
            data.minimumWidth = 80;
            data.minimumHeight = 25;            
            
            
            final Button buttonOk = new Button(buttons, SWT.PUSH);
            buttonOk.setText(TuxGuitar.getProperty("ok"));
            buttonOk.setLayoutData(data);
            buttonOk.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {   
                    boolean toEndValue = toEnd.getSelection();
                    int numeratorValue = Integer.parseInt(numerator.getText());
                    int denominatorValue = Integer.parseInt(denominator.getText());
                    TimeSignature timeSignature = new TimeSignature(numeratorValue,new Duration(denominatorValue));                    
                    setTimeSignature(timeSignature,toEndValue);
                    
                    dialog.dispose();
                }
            });

            Button buttonCancel = new Button(buttons, SWT.PUSH);
            buttonCancel.setLayoutData(data);
            buttonCancel.setText(TuxGuitar.getProperty("cancel"));
            buttonCancel.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {
                    dialog.dispose();
                }
            });

            dialog.pack();
            dialog.open();

            int x = shell.getBounds().x + (shell.getBounds().width - dialog.getSize().x) / 2;
            int y = shell.getBounds().y + (shell.getBounds().height - dialog.getSize().y) / 2;
            dialog.setLocation(x, y);
            
    		while (!dialog.isDisposed()) {
                if (!dialog.getDisplay().readAndDispatch()) {
                	dialog.getDisplay().sleep();
                }
            }
        }
    }
    
    
    private void setTimeSignature(TimeSignature timeSignature,boolean toEnd){
        //comienza el undoable
    	UndoableChangeTimeSignature undoable = UndoableChangeTimeSignature.startUndo(); 
    	
        Caret caret = getEditor().getTablature().getCaret();
        SongCoords songCoords = caret.getSongCoords();
        MeasureCoords measure = caret.getMeasureCoords();
        
        getSongManager().changeTimeSignature(measure.getMeasure().getStart(),timeSignature,toEnd);
        
        //actualizo la tablatura
        updateTablature();
        redraw();                
        
        //termia el undoable
        getEditor().getUndoManager().addEdit(undoable.endUndo(timeSignature,toEnd));
    }    

}
