/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.composition;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.song.models.Song;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class ChangeInfoAction extends Action{
    public static final String NAME = "CHANGE_INFO";
    
    public ChangeInfoAction(TablatureEditor tablatureEditor) {
        super(NAME,true,tablatureEditor);       
    }

    public boolean doAction(TypedEvent e) {
        showDialog(getEditor().getTablature().getShell());
        return true;
    }

    
    public void showDialog(Shell shell) {
        Song song = getEditor().getSongManager().getSong();
        if (song != null) {
            final Shell dialog = new Shell(shell, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);

            dialog.setLayout(new GridLayout());            
            dialog.setText(TuxGuitar.getProperty("composition.properties"));
            
            //-------NAME------------------------------------
            Composite nameComposite = new Composite(dialog, SWT.NONE);
            nameComposite.setLayout(new GridLayout(2,false));
            nameComposite.setLayoutData(new GridData(SWT.RIGHT,SWT.FILL,true,true));   
            
            Label nameLabel = new Label(nameComposite, SWT.NULL);
            nameLabel.setText(TuxGuitar.getProperty("composition.name"));
            
            final Text name = new Text(nameComposite, SWT.BORDER);
            name.setLayoutData(new GridData(200,13));
            name.setText(song.getName());
            
            //-------INTERPRET------------------------------------
            Composite interpretComposite = new Composite(dialog, SWT.NONE);
            interpretComposite.setLayout(new GridLayout(2,false));
            interpretComposite.setLayoutData(new GridData(SWT.RIGHT,SWT.FILL,true,true));   
            
            Label interpretLabel = new Label(interpretComposite, SWT.NULL);
            interpretLabel.setText(TuxGuitar.getProperty("composition.interpret"));
            
            final Text interpret = new Text(interpretComposite, SWT.BORDER);
            interpret.setLayoutData(new GridData(200,13));
            interpret.setText(song.getInterpret());            
            
            //-------ALBUM------------------------------------
            Composite albumComposite = new Composite(dialog, SWT.NONE);
            albumComposite.setLayout(new GridLayout(2,false));
            albumComposite.setLayoutData(new GridData(SWT.RIGHT,SWT.FILL,true,true));  
            
            Label albumLabel = new Label(albumComposite, SWT.NULL);
            albumLabel.setText(TuxGuitar.getProperty("composition.album"));
            
            final Text album = new Text(albumComposite, SWT.BORDER);
            album.setLayoutData(new GridData(200,13));
            album.setText(song.getAlbum());              
            
            //-------AUTHOR------------------------------------
            Composite authorComposite = new Composite(dialog, SWT.NONE);
            authorComposite.setLayout(new GridLayout(2,false));
            authorComposite.setLayoutData(new GridData(SWT.RIGHT,SWT.FILL,true,true));  
            
            Label authorLabel = new Label(authorComposite, SWT.NULL);
            authorLabel.setText(TuxGuitar.getProperty("composition.author"));
            
            final Text author = new Text(authorComposite, SWT.BORDER);
            author.setLayoutData(new GridData(200,13));
            author.setText(song.getAuthor());  
            
            
            //------------------BUTTONS--------------------------            
            Composite buttons = new Composite(dialog, SWT.NONE);
            buttons.setLayout(new GridLayout(2,false));
            buttons.setLayoutData(new GridData(SWT.END,SWT.FILL,true,true));    	
            
            GridData data = new GridData(SWT.FILL,SWT.FILL,true,true);    
            data.minimumWidth = 80;
            data.minimumHeight = 25;     
          
            
            final Button buttonOK = new Button(buttons, SWT.PUSH);
            buttonOK.setText(TuxGuitar.getProperty("ok"));
            buttonOK.setLayoutData(data);
            buttonOK.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {      
                    setProperties(name.getText(),interpret.getText(),album.getText(),author.getText());
                    dialog.dispose();
                }
            });

            Button buttonCancel = new Button(buttons, SWT.PUSH);
            buttonCancel.setText(TuxGuitar.getProperty("cancel"));
            buttonCancel.setLayoutData(data);
            buttonCancel.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {
                    dialog.dispose();
                }
            });

            dialog.pack();
            dialog.open();

            int x = shell.getBounds().x + (shell.getBounds().width - dialog.getSize().x) / 2;
            int y = shell.getBounds().y + (shell.getBounds().height - dialog.getSize().y) / 2;
            dialog.setLocation(x, y);
        }
    }
    
    
    private void setProperties(String name,String interpret,String album,String author){
        getEditor().getSongManager().setProperties(name,interpret,album,author);   
        redraw();
    }    

}
