/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.song.managers.SongManager;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public abstract class Action implements SelectionListener,MouseListener{
    private String name;
    private boolean editableKeyBinding;
    private TablatureEditor tablatureEditor;
    	
    public Action(String name,boolean editableKeyBinding,TablatureEditor tablatureEditor){
        this.name = name;
        this.editableKeyBinding = editableKeyBinding;
        this.tablatureEditor = tablatureEditor;        
    }
    
    public Action(String name,TablatureEditor tablatureEditor){
        this(name,false,tablatureEditor);   
    }

    public abstract boolean doAction(TypedEvent e);

    protected void update(){
        TuxGuitar.instance().updateItems();
    }        
    
    public synchronized void process(TypedEvent e){
        boolean canDo = doAction(e);        
        if(canDo){
            setLastEvent(e);
            update();
        }
    }
    
    public boolean isEditableKeyBinding(){
    	return this.editableKeyBinding;
    }
    
    public String getName() {
        return name;
    }    
    
    protected synchronized void redraw(){
        TuxGuitar.instance().redraw();        
    }
    
    protected synchronized void updateTablature(){    
        TuxGuitar.instance().fireUpdate();
    }

    protected void fireUpdate(int measureNumber,boolean isNew){
        this.tablatureEditor.getTablature().getViewLayout().fireUpdate(measureNumber,isNew);      
    }
    
    protected void fireUpdate(int measureNumber){
        this.fireUpdate(measureNumber,false);        
    }    
    
    protected TablatureEditor getEditor(){
        return this.tablatureEditor;        
    }
    
    protected SongManager getSongManager(){
        return this.tablatureEditor.getSongManager();        
    }
    
    protected TypedEvent getLastEvent(){
        return TuxGuitar.instance().getActionContainer().getLastEvent();
    }
    
    private void setLastEvent(TypedEvent e){
        TuxGuitar.instance().getActionContainer().setLastEvent(e);
    }    
    
    
    public void widgetDefaultSelected(SelectionEvent e) {        
    }
    
    public void widgetSelected(SelectionEvent e) {
        process(e);
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {        
    }

    public void mouseUp(MouseEvent e) {     
        process(e);
    }    
    
}
